<?php
/**
 * Define the website environment status. When this flag is set to TRUE, some
 * module demonstration controllers will result in 404 errors.
 *
 */
define('IN_PRODUCTION', FALSE);

/**
 * Website application directory. This directory should contain your attach
 * backup, cache, configuration, languages, logs, themes and other resources.
 *
 * This path can be absolute or relative to this file.
 */
$arlicle_webroot = 'webroot';

/**
 * Arlicle modules directory. This directory should contain all the modules used
 * by arlicle application. Modules are enabled and disabled by the application
 * configuration file.
 *
 * This path can be absolute or relative to this file.
 */
$arlicle_modules = 'arlicle/modules';

/**
 * Kohana system directory. 
 * This path can be absolute or relative to this file.
 */
$kohana_system = 'arlicle/system';

/**
 * Test to make sure that Arlicle is running on PHP 5.2 or newer. Once you are
 * sure that your environment is compatible with Arlicle, you can comment this
 * line out. When running an application on a new server, uncomment this line
 * to check the PHP version quickly.
 */
version_compare(PHP_VERSION, '5.2', '<') and exit('Arlicle requires PHP 5.2 or newer.');

/**
 * Set the error reporting level. Unless you have a special need, E_ALL is a
 * good level for error reporting.
 */
error_reporting(E_ALL & ~E_STRICT);

/**
 * Turning off display_errors will effectively disable Arlicle error display
 * and logging. You can turn off Arlicle errors in webroot/config/config.php
 */
ini_set('display_errors', TRUE);

/**
 * If you rename all of your .php files to a different extension, set the new
 * extension here. This option can left to .php, even if this file has a
 * different extension.
 */
define('EXT', '.php');

//
// DO NOT EDIT BELOW THIS LINE, UNLESS YOU FULLY UNDERSTAND THE IMPLICATIONS.
// ----------------------------------------------------------------------------
//

$arlicle_pathinfo = pathinfo(__FILE__);
// Define the front controller name and docroot
define('DOCROOT', $arlicle_pathinfo['dirname'].DIRECTORY_SEPARATOR);
define('ARLICLE',  $arlicle_pathinfo['basename']);
define('KOHANA',  $arlicle_pathinfo['basename']);

// If the front controller is a symlink, change to the real docroot
is_link(ARLICLE) and chdir(dirname(realpath(__FILE__)));

// If arlicle folders are relative paths, make them absolute.
$arlicle_modules = file_exists($arlicle_modules) ? $arlicle_modules : DOCROOT.$arlicle_modules;
$kohana_system = file_exists($kohana_system) ? $kohana_system : DOCROOT.$kohana_system;

// Define application and system paths
define('APPPATH', str_replace('\\', '/', realpath($arlicle_webroot)).'/');
define('MODPATH', str_replace('\\', '/', realpath($arlicle_modules)).'/');
define('SYSPATH', str_replace('\\', '/', realpath($kohana_system)).'/');
// Define arlicle plugin path
define('PLUPATH', APPPATH . 'plugins/');
// Define arlicle user webroot directory name
define('WEBROOT', $arlicle_webroot);

// Clean up
unset($arlicle_webroot, $arlicle_modules, $kohana_system, $arlicle_pathinfo);

require SYSPATH.'core/Bootstrap'.EXT;
