<?php defined('SYSPATH') OR die('No direct access allowed.');

class MyTag {

    // get the type is page or home page 
    public static function mainmenu_as_ul() {
        $diagrams = ORM::factory('diagram')->where(array('parent_id'=>0, 'type'=>'page'))->orwhere('uri','/')->find_all();
        $count = count($diagrams) - 1;
        $output = "<ul>\n";
        $current_uri = DiagramTag::uri();
        foreach($diagrams as $key => $diagram) {
            $output .= '<li';
            if ($diagram->uri == '/') {
                $output .= ' class="first"';
                $output .= ($current_uri == '/') ? ' id="firstcurrent"' : '';
            } else if ($key == $count) {
                $output .= ' class="last"';
                $output .= ($current_uri == $diagram->uri) ? ' id="lastcurrent"' : '';
            } else if ($current_uri == $diagram->uri) {
                $output .= ' id="current"';
            }
            $output .= '>';
            $output .= html::anchor($diagram->uri, $diagram->title) . '</li>';
        }
        $output .= "\n</ul>";
        return $output;
    }

    public static function post_list_as_div() {
        $posts = PostsTag::post_list(array('per_page'=>5, 'pagination'=>'wordpress'));
        $output = '';
        foreach($posts as $post) {
            $output .= '<div class="post hentry category-' . $post->diagram->id . '" id="post-' . $post->id . '">
            <h1>' . date('j M y', $post->date) . ' ' . html::anchor($post->link, $post->title, array('rel'=>'bookmark', 'title'=>$post->title)) . '</h1>       
            <p>' . $post->content . '</p>
            <div style="clear:both;"></div>
            <div class="postmeta">Filed in ' . html::anchor($post->diagram->uri, $post->diagram->title, array('title'=>'View all posts in ' . $post->diagram->title)) . ' with ' . html::anchor($post->link . '#comments', count($post->comments) . ' Comment', array('title'=> 'Comment on ' . $post->title)) . '</div>
            </div>';
        }
        $output .= '<div style="clear:both"></div>';
        $output .= PostsTag::pagelink();
        /*
        $output .= '<div class="navigation">
            <div class="alignleft">上一页</div>
            <div class="alignright">下一页</div>
        </div>';
        */

        return $output;
    }
}

?>
