<?php
require_once(yxphp_path.'bin/txtsql/txtSQL.core.php'); class txtSQL { var $_STRICT = TRUE; var $_LIBPATH = NULL; var $_USER = NULL; var $_PASS = NULL; var $_CACHE = array(); var $_SELECTEDDB = NULL; var $_QUERYCOUNT = 0; function txtSQL ($path='./data') { $this->_LIBPATH = $path; return TRUE; } function connect ($user, $pass) { if ( !is_dir($this->_LIBPATH) ) { $this->_error(E_USER_ERROR, 'Invalid data directory specified'); } $this->_query = new txtSQLCore; $this->_query->_LIBPATH = $this->_LIBPATH; if ( ($DATA = $this->_readFile("$this->_LIBPATH/txtsql/txtsql.MYI")) === FALSE ) { $this->_error(E_USER_WARNING, 'Database file is corrupted!'); return FALSE; } $this->_data = $DATA; if ( !isset($DATA[strtolower($user)]) || $DATA[strtolower($user)] != md5($pass) ) { $this->_error(E_USER_NOTICE, 'Access denied for user \''.$user.'\' (using password: '.(!empty($pass)?'yes':'no').')'); return FALSE; } $this->_USER = $user; $this->_PASS = $pass; return TRUE; } function disconnect () { if( !$this->_isconnected() ) { $this->_error(E_USER_NOTICE, 'Can only disconnect when connected!'); return FALSE; } unset($this->_USER, $this->_PASS, $this->_query); return TRUE; } function select ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->select($arguments); } function insert ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->insert($arguments); } function update ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->update($arguments); } function delete ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->delete($arguments); } function showdbs () { $this->_validate(array()); $this->_QUERYCOUNT++; return $this->_query->showdatabases(); } function createdb ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->createdatabase($arguments); } function dropdb ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->dropdatabase($arguments); } function renamedb ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->renamedatabase($arguments); } function showtables ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->showtables($arguments); } function createtable ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->createtable($arguments); } function droptable ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->droptable($arguments); } function altertable ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->altertable($arguments); } function describe ($arguments) { $this->_validate($arguments); $this->_QUERYCOUNT++; return $this->_query->describe($arguments); } function _validate ($arguments) { if ( !$this->_isconnected() ) { $this->_error(E_USER_NOTICE, 'Can only perform queries when connected!'); return FALSE; } if ( !empty($arguments) && !is_array($arguments) ) { $this->_error(E_USER_ERROR, 'txtSQL can only accept arguments in an array'); } return TRUE; } function execute ($action, $arguments = NULL) { if ( !$this->_isconnected() ) { $this->_error(E_USER_NOTICE, 'Can only perform queries when connected!'); return FALSE; } if ( empty($action) ) { $this->_error(E_USER_NOTICE, 'You have an error in your txtSQL query'); return FALSE; } if ( !empty($arguments) && !is_array($arguments) ) { $this->_error(E_USER_ERROR, 'txtSQL Can only accept arguments in an array'); } switch ( strtolower($action) ) { case 'show databases': $results = $this->_query->showdatabases(); break; case 'create database': $results = $this->_query->createdatabase($arguments); break; case 'drop database': $results = $this->_query->dropdatabase($arguments); break; case 'rename database': $results = $this->_query->renamedatabase($arguments); break; case 'show tables': $results = $this->_query->showtables($arguments); break; case 'create table': $results = $this->_query->createtable($arguments); break; case 'drop table': $results = $this->_query->droptable($arguments); break; case 'alter table': $results = $this->_query->altertable($arguments); break; case 'describe': $results = $this->_query->describe($arguments); break; case 'select': $results = $this->_query->select($arguments); break; case 'insert': $results = $this->_query->insert($arguments); break; case 'update': $results = $this->_query->update($arguments); break; case 'delete': $results = $this->_query->delete($arguments); break; default: $this->_error(E_USER_NOTICE, 'Unknown action: '.$action); return FALSE; } $this->_QUERYCOUNT++; return isset($results) ? $results : ''; } function strict ($strict = FALSE) { $strict = (bool) $strict; $this->_STRICT = $strict; if ( $this->_isconnected() ) { $this->_query->strict($strict); } return TRUE; } function grant_permissions($action, $user, $pass = NULL, $pass1 = NULL) { if ( !$this->_isconnected() ) { $this->_error(E_USER_NOTICE, 'Not connected'); return FALSE; } if ( !is_string($action) || !is_string($user) || (!empty($pass) && !is_string($pass)) || (!empty($pass1) && !is_string($pass1)) ) { $this->_error(E_USER_NOTICE, 'The arguments must be a string'); return FALSE; } if ( ($DATA = $this->_readFile("$this->_LIBPATH/txtsql/txtsql.MYI")) === FALSE ) { $this->_error(E_USER_WARNING, 'Database file is corrupted!'); return FALSE; } if ( empty($user) ) { $this->_error(E_USER_NOTICE, 'Forgot to input username'); return FALSE; } switch ( strtolower($action) ) { case 'add': if ( isset($DATA[strtolower($user)]) ) { $this->_error(E_USER_NOTICE, 'User already exists'); return FALSE; } $DATA[strtolower($user)] = md5($pass); break; case 'drop': if ( strtolower($user) == strtolower($this->_USER) ) { $this->_error(E_USER_NOTICE, 'Can\'t drop yourself'); return FALSE; } elseif ( strtolower($user) == 'root' ) { $this->_error(E_USER_NOTICE, 'Can\'t drop user root'); return FALSE; } elseif ( !isset($DATA[strtolower($user)]) ) { $this->_error(E_USER_NOTICE, 'User doesn\'t exist'); return FALSE; } elseif ( md5($pass) != $DATA[strtolower($user)] ) { $this->_error(E_USER_NOTICE, 'Incorrect password'); return FALSE; } unset($DATA[strtolower($user)]); break; case 'edit': if ( !isset($DATA[strtolower($user)]) ) { $this->_error(E_USER_NOTICE, 'User doesn\'t exist'); return FALSE; } if ( md5($pass) != $DATA[strtolower($user)] ) { $this->_error(E_USER_NOTICE, 'Incorrect password'); return FALSE; } $DATA[strtolower($user)] = md5($pass1); break; default: $this->_error(E_USER_NOTICE, 'Invalid action specified'); return FALSE; } $fp = @fopen("$this->_LIBPATH/txtsql/txtsql.MYI", 'w') or $this->_error(E_USER_FATAL, "Couldn't open $this->_LIBPATH/txtsql/txtsql.MYI for writing"); @flock($fp, LOCK_EX); @fwrite($fp, serialize($DATA)) or $this->_error(E_USER_FATAL, "Couldn't write to $this->_LIBPATH/txtsql/txtsql.MYI"); @flock($fp, LOCK_UN); @fclose($fp) or $this->_error(E_USER_NOTICE, "Error closing $this->_LIBPATH/txtsql/txtsql.MYI"); $this->_CACHE["$this->_LIBPATH/txtsql/txtsql.MYI"] = $DATA; return TRUE; } function getUsers () { if ( !$this->_isconnected() ) { $this->_error(E_USER_NOTICE, 'Not connected'); return FALSE; } if ( ($DATA = $this->_readFile("$this->_LIBPATH/txtsql/txtsql.MYI")) === FALSE ) { $this->_error(E_USER_WARNING, 'Database file is corrupted!'); return FALSE; } $users = array(); foreach ( $DATA as $key => $value ) { $users[] = $key; } return $users; } function isLocked ($db) { if ( !$this->_dbexist($db) ) { $this->_error(E_USER_NOTICE, 'Database '.$db.' doesn\'t exist'); return FALSE; } return is_file("$this->_LIBPATH/$db/txtsql.lock") ? TRUE : FALSE; } function lockdb ($db) { if ( !$this->_isConnected() ) { $this->_error(E_USER_NOTICE, 'You must be connected'); return FALSE; } elseif ( $this->isLocked($db) ) { $this->_error(E_USER_NOTICE, 'Lock for database '.$db.' already exists'); return FALSE; } $fp = fopen("$this->_LIBPATH/$db/txtsql.lock", 'a') or $this->_error(E_USER_ERROR, 'Err1or creating a lock for database '.$db); fclose($fp) or $this->_error(E_USER_ERROR, 'Error creating a lock for database '.$db); return TRUE; } function unlockdb ($db) { if ( !$this->_isConnected() ) { $this->_error(E_USER_NOTICE, 'You must be connected'); return FALSE; } elseif ( !$this->isLocked($db) ) { $this->_error(E_USER_NOTICE, 'Lock for database '.$db.' doesn\'t exist'); return FALSE; } if ( !@unlink("$this->_LIBPATH/$db/txtsql.lock") ) { $this->_error(E_USER_ERROR, 'Error removing lock for database '.$db); } return TRUE; } function selectdb ($db) { if ( empty($db) ) { $this->_error(E_USER_NOTICE, 'Cannot select database '.$db); return FALSE; } if ( !$this->_dbexist($db) ) { $this->_error(E_USER_NOTICE, 'Database '.$db.' doesn\'t exist'); return FALSE; } $this->_SELECTEDDB = $db; $this->_query->_SELECTEDDB = $db; return TRUE; } function table_exists ($table, $db) { return $this->_tableexist($table, $db); } function db_exists ($db) { return $this->_dbexist($db); } function table_count ($table, $database=NULL) { if ( !empty($database) ) { if ( !$this->selectdb($database) ) { return FALSE; } } if ( empty($this->_SELECTEDDB) || empty($table) ) { $this->_error(E_USER_NOTICE, 'No database selected'); return FALSE; } $filename = "$this->_LIBPATH/$this->_SELECTEDDB/$table"; if ( !is_file($filename.'.MYD') || !is_file($filename.'.FRM') ) { $this->_error(E_USER_NOTICE, 'Table '.$table.' doesn\'t exist'); return FALSE; } if ( ($rows = @file($filename.'.MYD')) === FALSE ) { $this->_error(E_USER_NOTICE, 'Table '.$table.' doesn\'t exist'); return FALSE; } $count = substr($rows[0], 2, strpos($rows[0], '{') - 3); return $count; } function last_insert_id( $table, $db = '', $column = '' ) { if ( !empty($db) ) { if ( !$this->selectdb($db) ) { return FALSE; } } if ( empty($this->_SELECTEDDB) ) { $this->_error(E_USER_NOTICE, 'No database selected'); return FALSE; } if ( ( $cols = $this->_readFile("$this->_LIBPATH/$this->_SELECTEDDB/$table.FRM") ) === FALSE ) { $this->_error(E_USER_NOTICE, 'Table "'.$table.'" doesn\'t exist'); return FALSE; } if ( !empty($column) ) { if ( $this->_getColPos($column, $cols) === FALSE ) { $this->_error(E_USER_NOTICE, 'Column '.$column.' doesn\'t exist'); return FALSE; } elseif ( $cols[$column]['auto_increment'] != 1 ) { $this->_error(E_USER_NOTICE, 'Column '.$column.' is not an auto_increment field'); return FALSE; } $cols['primary'] = $column; } elseif ( empty($cols['primary']) && empty($column) ) { $this->_error(E_USER_NOTICE, 'There is no primary key defined for table "'.$table.'"'); return FALSE; } return $cols[$cols['primary']]['autocount']; } function query_count() { return $this->_QUERYCOUNT; } function last_error() { if ( !empty($this->_query->_ERRORS) ) { print '<pre>'.$this->_query->_ERRORSPLAIN[count($this->_query->_ERRORS)-1].'</pre>'; } elseif ( !empty($this->_ERRORS) ) { print '<pre>'.$this->_ERRORSPLAIN[count($this->_ERRORS)-1].'</pre>'; } } function get_last_error() { if ( !empty($this->_query->_ERRORS) ) { return $this->_query->_ERRORSPLAIN[count($this->_query->_ERRORS)-1]; } elseif ( !empty($this->_ERRORS) ) { return $this->_ERRORSPLAIN[count($this->_ERRORS)-1]; } } function errordump() { if ( empty($this->_ERRORS) && empty($this->_query->_ERRORS) ) { echo 'No errors occurred during script execution'; return TRUE; } if ( !empty($this->_ERRORS) ) { foreach ( $this->_ERRORS as $key => $value ) { echo 'ERROR #['.$key.'] '.$value; } } elseif ( !empty($this->_query->_ERRORS) ) { foreach ( $this->_query->_ERRORS as $key => $value ) { echo 'ERROR #['.$key.'] '.$value; } } return TRUE; } function emptyCache() { $this->_CACHE = array(); return TRUE; } function _error ($errno, $errstr, $errtype=NULL) { $backtrace = array_reverse(@debug_backtrace()); $errfile = $backtrace[0]['file']; $errline = $backtrace[0]['line']; switch ($errno) { case E_USER_ERROR: $type = 'Fatal Error'; break; case E_USER_NOTICE: $type = "Warning"; break; default: $type = "Error"; break; } $type = isset($errtype) ? $errtype : $type; $this->_ERRORSPLAIN[] = $errstr; $errormsg = "<BR />\n<B>txtSQL $type:</B> $errstr in <B>$errfile</B> on line <B>$errline</B>\n<BR /></DIV>"; $this->_ERRORS[] = $errormsg; if ( $this->_STRICT === TRUE ) { echo $errormsg; } if ( $errno == E_USER_ERROR ) { exit; } return TRUE; } function _readFile ( $filename, $useCache = TRUE, $unserialize = TRUE ) { if ( is_file($filename) ) { if ( $useCache === TRUE ) { if ( isset($this->_CACHE[$filename]) ) { return $this->_CACHE[$filename]; } } if ( ( $contents = @implode('', @file($filename)) ) !== FALSE ) { if ( $unserialize === TRUE ) { if ( ( $contents = @unserialize($contents) ) === FALSE ) { return FALSE; } } if ( $useCache === TRUE ) { $this->_CACHE[$filename] = $contents; } return $contents; } } return FALSE; } function _isconnected () { if ( empty($this->_USER) ) { return FALSE; } if ( $this->_data[strtolower($this->_USER)] != md5($this->_PASS) ) { return FALSE; } return TRUE; } function _dbexist ($db) { return is_dir("$this->_LIBPATH/$db") ? TRUE : FALSE; } function _tableexist ($table, $db) { if ( !empty($db) ) { if ( !$this->selectdb($db) ) { $this->_error(E_USER_NOTICE, 'Database, \''.$db.'\', doesn\'t exist'); return FALSE; } } $filename = "$this->_LIBPATH/$this->_SELECTEDDB/$table"; if ( is_file($filename.'.MYD') && is_file($filename.'.FRM') ) { return TRUE; } return FALSE; } function _buildIf ($where, $cols) { if ( !is_array($where) || empty($where) ) { $this->_error(E_USER_NOTICE, 'Where clause must be an array'); return FALSE; } $query = ''; foreach ( $where as $key => $value ) { if ( $key % 2 == 1 ) { $and = strtolower($value) == 'and'; $or = strtolower($value) == 'or'; $xor = strtolower($value) == 'xor'; if ( $and === FALSE && $or === FALSE && $xor === FALSE ) { $this->_error(E_USER_NOTICE, 'Only boolean seperators AND, and OR are allowed'); return FALSE; } $query .= ( $and === TRUE ) ? ' && ' : ( ( $xor === TRUE ) ? ' XOR ' : ' || ' ); continue; } $f1 = '('; $f2 = ') '; switch ( TRUE ) { case strpos($value, '!='): $type = 1; $op = '!='; break; case strpos($value, '!~'): $type = 3; $op = '!~'; break; case strpos($value, '=~'): $type = 3; $op = '=~'; break; case strpos($value, '<='): $type = 2; $op = '<='; break; case strpos($value, '>='): $type = 2; $op = '>='; break; case strpos($value, '=' ): $type = 1; $op = '='; break; case strpos($value, '<>'): $type = 1; $op = '<>'; break; case strpos($value, '<' ): $type = 2; $op = '<'; break; case strpos($value, '>' ): $type = 2; $op = '>'; break; case strpos($value, '!?'): $type = 5; $op = '!?'; break; case strpos($value, '?' ): $type = 5; $op = '?'; break; default: $val = 'TRUE'; if ( substr(trim($value), 0, 1) == '!' ) { $val = 'FALSE'; $value = substr($value, strpos($value, '!')+1); } $function = substr($value, 0, strpos($value, '(')); $col = substr($value, strlen($function) + 1, strlen($value) - strlen($function) - 2 ); if ( $function !== FALSE ) { $type = 4; $op = '==='; switch ( strtolower($function) ) { case 'isnumeric': $f1 = 'is_numeric('; break 2; case 'isstring': $f1 = 'is_string('; break 2; case 'isfile': $f1 = 'is_file('; break 2; case 'isdir': $f1 = 'is_dir('; break 2; case 'iswritable': $f1 = 'is_writable('; break 2; } } $this->_error(E_USER_NOTICE, 'You have an error in your where clause, (operators allowed: =, !=, <>, =~, !~, <, >, <=, >=)'); return FALSE; } if ( !isset($function) ) { list ( $col, $val ) = explode($op, $value, 2); } if ( substr_count($col, '(') == 1 && substr_count($col, ')') == 1 ) { $function = substr($col, 0, strpos($col, '(')); if ( $val != '' && $col{strlen($col)-1}.$val{0} == "  " ) { $col = substr($col, strlen($function) + 1, strlen($col) - strlen($function) - ( ($col{strlen($col)-1} != " " ) ? 2 : 3 ) )." "; $val = $val; } else { $col = substr($col, strlen($function) + 1, strlen($col) - strlen($function) - ( ($col{strlen($col)-1} != " " ) ? 2 : 3 ) ); } switch ( strtolower($function) ) { case 'strlower': $f1 = 'strtolower('; break; case 'strupper': $f1 = 'strtoupper('; break; case 'chop': case 'rtrim': $f1 = 'rtrim('; break; case 'ltrim': $f1 = 'ltrim('; break; case 'trim': $f1 = 'trim('; break; case 'md5': $f1 = 'md5('; break; case 'stripslash': $f1 = 'stripslashes('; break; case 'strlength': $f1 = 'strlen('; break; case 'strreverse': $f1 = 'strrev('; break; case 'ucfirst': $f1 = 'ucfirst('; break; case 'ucwords': $f1 = 'ucwords('; break; case 'bin2hex': $f1 = 'bin2hex('; break; case 'entdecode': $f1 = 'html_entity_decode('; break; case 'entencode': $f1 = 'htmlentities('; break; case 'soundex': $f1 = 'soundex('; break; case 'ceil': $f1 = 'ceil('; break; case 'floor': $f1 = 'floor('; break; case 'round': $f1 = 'round('; break; case 'isnumeric': case 'isstring': case 'isfile': case 'isdir': $this->_error(E_USER_NOTICE, 'Function, '.$function.', requires that NO operator be present in the clause'); return FALSE; default: $this->_error(E_USER_NOTICE, 'Function, '.$function.', hasn\'t been implemented'); return FALSE; } } if ( strtolower(trim($col)) == 'primary' ) { if ( empty($cols['primary']) ) { $this->_error(E_USER_NOTICE, 'No primary key has been assigned to this table'); return FALSE; } $col = $cols['primary']; } if ( ( $position = $this->_getColPos(rtrim($col), $cols) ) === FALSE ) { $this->_error(E_USER_NOTICE, 'Column \''.rtrim($col).'\' doesn\'t exist'); return FALSE; } $val = str_replace("\'", "'", addslashes($val)); $val = ( $col{strlen($col)-1}.$val{0} == "  " ) ? substr($val, 1) : $val; if ( empty($val) && ( $type == '5' || $f1 != '(' ) ) { $this->_error(E_USER_NOTICE, 'Forgot to specify a value to match in your where clause'); return FALSE; } switch ( $type ) { case 1: case 2: $quotes = ( !is_numeric($val) || $cols[rtrim($col)]['type'] != 'int' ) ? '"' : ''; $query .= ' ( '.$f1.'$value['.$position.']'.$f2.' '.( $op == '=' ? '==' : $op ).' '.$quotes.$val.$quotes.' ) '; break; case 3: $val = str_replace(array('(', ')', '{', '}', '.', '$', '/', '\%', '*', '%', '$$PERC$$'), array('\(', '\)', '\{', '\}', '\.', '\$', '\/', '$$PERC$$', '\*', '(.+)?', '%'), $val); $query .= ' ( '.($op == '!~' ? '!' : '').'preg_match("/^'.$val.'$/iU", '.$f1.'$value['.$position.']'.$f2.') ) '; break; case 4: $query .= ' ( '.$f1.'$value['.$position.']'.$f2.' === '.$val.' ) '; break; case 5: $query .= ' ( strpos('.$f1.'\' \'.$value['.$position.']), \''.$val.'\') '.(($op == '!?') ? '=' : '!' ).'== FALSE ) '; } unset($function, $f1, $f2, $quotes, $position, $val, $col, $op); } $andor = substr($query, -3, -1); if ( $andor == '&&' || $andor == '||' || $andor == 'OR' ) { $this->_error(E_USER_NOTICE, 'You have an error in your where clause, cannot end statement with an AND, OR, or XOR'); return FALSE; } return $query; } function _getColPos ($colname, $cols) { if ( empty($cols) || !is_array($cols) || !array_key_exists($colname, $cols) ) { return FALSE; } unset($cols['primary']); if ( ( $position = array_search($colname, array_keys($cols)) ) === FALSE ) { return FALSE; } return $position; } function _qsort($array, $num = 0, $order = "ASC", $left = 0, $right = -1) { if ( count($array) >= 1 ) { if ( $right == -1 ) { $right = count($array) - 1; } $links = $left; $rechts = $right; $mitte = $array[($left + $right) / 2][$num]; if ( $rechts > $links ) { do { if ( strtolower($order) == 'asc' ) { while ( $array[$links][$num] < $mitte ) { $links++; } while ( $array[$rechts][$num] > $mitte ) { $rechts--; } } else { while ( $array[$links][$num] > $mitte ) { $links++; } while ( $array[$rechts][$num] < $mitte) { $rechts--; } } if ( $links <= $rechts ) { $tmp = $array[$links]; $array[$links++] = $array[$rechts]; $array[$rechts--] = $tmp; } } while ( $links <= $rechts ); if ( $left < $rechts ) { $array = $this->_qsort($array,$num,$order,$left, $rechts); } if ( $links < $right ) { $array = $this->_qsort($array,$num,$order,$links,$right); } } return $array; } return FALSE; } function unique_multi_array ( $array, $sub_key ) { $target = array(); $existing_sub_key_values = array(); foreach ( $array as $key => $sub_array ) { if ( !in_array($sub_array[$sub_key], $existing_sub_key_values) ) { $existing_sub_key_values[] = $sub_array[$sub_key]; $target[$key] = $sub_array; } } return $target; } function version() { return '2.2 Final'; } } ?>