<?
// | Author: Ulf Wendel <ulf.wendel@phpdoc.de> 
// $Id: IT.php,v 1.6 2003/03/12 02:25:16 pajoye Exp
// 
// stan@china.com do some change
// u can download original code at http://pear.php.net
// thanks to Ulf Wendel
class IntegratedTemplate {
	// new
	var $begin_int = "BEGIN";
	var $end_int = "END";

	// end new
    var $err = array();
    var $printError = false;
    var $haltOnError = false;
    var $clearCache = false;
    var $openingDelimiter = "{";
    var $closingDelimiter     = "}";
    var $blocknameRegExp    = "[0-9A-Za-z_-]+";
    var $variablenameRegExp    = "[0-9A-Za-z_-]+";
    var $variablesRegExp = "";
    var $removeVariablesRegExp = "";
    var $removeUnknownVariables = true;
    var $removeEmptyBlocks = true;
    var $blockRegExp = "";
    var $currentBlock = "__global__";  
    var $template = "";
    var $blocklist = array();
    var $blockdata = array();
    var $blockvariables = array();  
    var $blockinner         = array();
    var $touchedBlocks = array();
    var $variableCache = array();
    var $clearCacheOnParse = false;
    var $fileRoot = "";
    var $flagBlocktrouble = false;
    var $flagGlobalParsed = false;
    var $flagCacheTemplatefile = true;
    var $lastTemplatefile = "";
    function IntegratedTemplate($root = "",$begin_int="BEGIN",$end_int="END") {
		$this->begin_int = $begin_int;
		$this->end_int = $end_int;
        $this->variablesRegExp = "@" . $this->openingDelimiter . "(" . $this->variablenameRegExp . ")" . $this->closingDelimiter . "@sm";
        $this->removeVariablesRegExp = "@" . $this->openingDelimiter . "\s*(" . $this->variablenameRegExp . ")\s*" . $this->closingDelimiter . "@sm";
        
        $this->blockRegExp = '@<!--\s+'.$this->begin_int.'\s+(' . $this->blocknameRegExp . ')\s+-->(.*)<!--\s+'.$this->end_int.'\s+\1\s+-->@sm';

        $this->setRoot($root);        
    } // end constructor
    

    function show($block = "__global__") {
        print $this->get($block);
    } // end func show

    function get($block = "__global__") {
		GLOBAL $basic,$type_name,$subject;
		if (isset($subject))
			$title = $subject." - ";
		elseif(isset($type_name))
			$title = $type_name." - ";
		//echo $trial_okphp; // echo trial info for trialed users
		$this->setVariable("head_title",$title.$basic["web_name"]);
        if ("__global__" == $block && !$this->flagGlobalParsed)
            $this->parse("__global__");

        if (!isset($this->blocklist[$block])) {
            $this->halt("The block '$block' was not found in the template.", __FILE__, __LINE__);
            return true;
        }

        if ($this->clearCache) {

            $data = (isset($this->blockdata[$block])) ? $this->blockdata[$block] : "";
            unset($this->blockdata[$block]);
            return $data;

        } else {

            return (isset($this->blockdata[$block])) ? $this->blockdata[$block] : "";

        }

    } // end func get()
        

    function parse($block = "__global__", $flag_recursion = false) {

        if (!isset($this->blocklist[$block])) {
            $this->halt("The block '$block' was not found in the template.", __FILE__, __LINE__);
            return false;
        }

        if ("__global__" == $block)
            $this->flagGlobalParsed = true;
            
        $regs = array();
        $values = array();

        if ($this->clearCacheOnParse) {
            
            foreach ($this->variableCache as $name => $value) {
                $regs[] = "@" . $this->openingDelimiter . $name . $this->closingDelimiter . "@";
                $values[] = $value;
            }
            $this->variableCache = array();
        
        } else {

            foreach ($this->blockvariables[$block] as $allowedvar => $v) {
        
                if (isset($this->variableCache[$allowedvar])) {
                   $regs[]   = "@".$this->openingDelimiter . $allowedvar . $this->closingDelimiter . "@";
                   $values[] = $this->variableCache[$allowedvar];
                    unset($this->variableCache[$allowedvar]);
                }

            }        
            
        }

        $outer = (0 == count($regs)) ? $this->blocklist[$block] : preg_replace($regs, $values, $this->blocklist[$block]);
        $empty = (0 == count($values)) ? true : false;

        if (isset($this->blockinner[$block])) {
        
          foreach ($this->blockinner[$block] as $k => $innerblock) {

            $this->parse($innerblock, true);
                if ("" != $this->blockdata[$innerblock])
                    $empty = false;

                $placeholder = $this->openingDelimiter . "__" . $innerblock . "__" . $this->closingDelimiter;                
                $outer = str_replace($placeholder, $this->blockdata[$innerblock], $outer);
                $this->blockdata[$innerblock] = "";                
      }
            
    }

    if ($this->removeUnknownVariables)
            $outer = preg_replace($this->removeVariablesRegExp, "", $outer);

        if ($empty) {

            if (!$this->removeEmptyBlocks) {
            
                $this->blockdata[$block ].= $outer;
                
            } else {

                if (isset($this->touchedBlocks[$block]))
                    $this->blockdata[$block] .= $outer;
                
            }
                
        } else {
        
            $this->blockdata[$block] .= $outer;
        
        }

        return $empty;
    } // end func parse


    function parseCurrentBlock() {
        return $this->parse($this->currentBlock);
    } // end func parseCurrentBlock

  
    function setVariable($variable, $value = "") {
        
        if (is_array($variable)) {
			foreach($variable as $key=>$val)
            $this->variableCache[$key] = str_replace("\$","\\$",$val);
                
        } else {
            $this->variableCache[$variable] = str_replace("\$","\\$",$value);
            
        }
    
    } // end func setVariable
    

    function setCurrentBlock($block = "__global__") {
    
        if (!isset($this->blocklist[$block])) {
            $this->halt("Can't find the block '$block' in the template.", __FILE__, __LINE__);
            return false;
        }
            
        $this->currentBlock = $block;
        
        return true;
    } // end func setCurrentBlock
    

    function touchBlock($block) {
        
        if (!isset($this->blocklist[$block])) {
            $this->halt("Can't find the block '$block' in the template.", __FILE__, __LINE__);
            return false;
        }
        
        $this->touchedBlocks[$block] = true;
        
        return true;
    } // end func touchBlock

    function init() {
    
        $this->free();
        $this->findBlocks($this->template);
        $this->buildBlockvariablelist();
        
    } // end func init
    

    function free() {
    
        $this->err = array();
        
        $this->currentBlock = "__global__";
        
        $this->variableCache    = array();        
        $this->blocklookup      = array();
        $this->touchedBlocks    = array();
        
        $this->flagBlocktrouble = false;
        $this->flagGlobalParsed = false;
        
    } // end func free
    

    function setTemplate($template, $removeUnknownVariables = true, $removeEmptyBlocks = true) {
                
        $this->removeUnknownVariables = $removeUnknownVariables;
        $this->removeEmptyBlocks = $removeEmptyBlocks;
        
        if ("" == $template && $this->flagCacheTemplatefile) {
        
            $this->variableCache = array();
            $this->blockdata = array();
            $this->touchedBlocks = array();
            $this->currentBlock = "__global__";
            
        } else {
        
            $this->template = '<!-- '.$this->begin_int.' __global__ -->' . $template . '<!-- '.$this->end_int.' __global__ -->';
            $this->init();
            
        }
        
        if ($this->flagBlocktrouble)
            return false;
        
        return true;
    } // end func setTemplate
    

    function loadTemplatefile($filename, $removeUnknownVariables = true, $removeEmptyBlocks = true,$use_db_cache = "") {
		$removeUnknownVariables = false;

        $template = "";        
        if ((!$this->flagCacheTemplatefile || $this->lastTemplatefile != $filename) && "" == $use_db_cache)
            $template = $this->getfile($filename);
		else {
			$template = $use_db_cache;
		}
            
        $this->lastTemplatefile = $filename;

        /*
        return $this->setTemplate($template, $removeUnknownVariables, $removeEmptyBlocks, true);
		*/
		// change to fit My Block
		$this->setTemplate($template, $removeUnknownVariables, $removeEmptyBlocks, true);
		preg_match_all ("/\<!-- MyBlock:(.*)\-->/isU", $template, $myblocks,PREG_PATTERN_ORDER);
		return $myblocks[1];
    } // end func LoadTemplatefile
    

    function setRoot($root) {
        
        if ("" != $root && "/" != substr($root, -1))
            $root .= "/";
        
        $this->fileRoot = $root;
        
    } // end func setRoot

    /**
    * Build a list of all variables within of a block
    */    
    function buildBlockvariablelist() {

        foreach ($this->blocklist as $name => $content) {
            preg_match_all( $this->variablesRegExp, $content, $regs );

            if (0 != count($regs[1])) {

                foreach ($regs[1] as $k => $var)             
                    $this->blockvariables[$name][$var] = true;
                    
            } else {
            
                $this->blockvariables[$name] = array();
                
            }
                
        }    
        
    } // end func buildBlockvariablelist
    
    /**
    * Returns a list of all 
    */
    function getGlobalvariables() {

        $regs   = array();
        $values = array();

        foreach ($this->blockvariables["__global__"] as $allowedvar => $v) {
            
            if (isset($this->variableCache[$allowedvar])) {
                $regs[]   = "@" . $this->openingDelimiter . $allowedvar . $this->closingDelimiter."@";
                $values[] = $this->variableCache[$allowedvar];
                unset($this->variableCache[$allowedvar]);
            }
            
        }
        
        return array($regs, $values);
    } // end func getGlobalvariables

 
    function findBlocks($string) {

        $blocklist = array();

        if (preg_match_all($this->blockRegExp, $string, $regs, PREG_SET_ORDER)) {
            
            foreach ($regs as $k => $match) {
            
                $blockname         = $match[1];
                $blockcontent = $match[2];
            
                if (isset($this->blocklist[$blockname])) {
                    $this->halt("The name of a block must be unique within a template. Found '$blockname' twice. Unpredictable results may appear.", __FILE__, __LINE__);
                    $this->flagBlocktrouble = true;
                }                

                $this->blocklist[$blockname] = $blockcontent;
                $this->blockdata[$blockname] = "";

                $blocklist[] = $blockname;
                
                $inner = $this->findBlocks($blockcontent);
                foreach ($inner as $k => $name) {

                    $pattern = sprintf('@<!--\s+'.$this->begin_int.'\s+%s\s+-->(.*)<!--\s+'.$this->end_int.'\s+%s\s+-->@sm', 
                                                    $name,
                                                    $name
                                                );

                    $this->blocklist[$blockname] = preg_replace(    $pattern, 
                                                                    $this->openingDelimiter . "__" . $name . "__" . $this->closingDelimiter, 
                                                                    $this->blocklist[$blockname]
                                                               );
                    $this->blockinner[$blockname][] = $name;
                    $this->blockparents[$name] = $blockname;
                    
                }
                
            }
            
        }

        return $blocklist;
    } // end func findBlocks

   
    function getFile($filename) {
        
        if ("/" == $filename{0} && "/" == substr($this->fileRoot, -1)) 
            $filename = substr($filename, 1);
            
        $filename = $this->fileRoot . $filename;
        
        if (!($fh = @fopen($filename, "r"))) {
            $this->halt("Can't read '$filename'.", __FILE__, __LINE__);
            return "";
        }
    
        $content = fread($fh, filesize($filename));
        fclose($fh);
        
        return $content; 
    } // end func getFile
    

    function halt($message, $file = "", $line = 0) {
        
        
        $message = sprintf("IntegratedTemplate Error: %s [File: %s, Line: %d]",
                                                            $message,
                                                            $file,
                                                            $line
                                                    );

        $this->err[] = $message;

        if ($this->printError)
            print $message;
            
        if ($this->haltOnError)
            die($message);

    } // end func halt
    
} // end class IntegratedTemplate
?>
