<?php
//====================================================
//		FileName: index.php
//		Summary:  程序入口文件
//====================================================
header("Content-type: text/html; charset=utf-8");
session_start();
error_reporting(0);

//配置数据库
$cfg["dbhost"]="localhost";     //数据库主机名
$cfg["dbuser"]="root";		    //数据库用户名
$cfg["dbpass"]=""; 				//数据库密码
$cfg["dbname"]="esm";  			//数据库名称
$cfg["webname"]="ESM企业销售管理系统 V3.0"; //系统名称

//打卡时间
$attendance_txt ="注:公司打卡时间 早晨8:00-9:00 中午11:00-13:00 下午18:00-19:00"; 


//引入类库及公共方法
@define("CORE",dirname(__FILE__)."/"); 	    //根目录
require_once("lib/mysql.class.php");        //数据类
require_once("lib/smarty.class.php");       //模版类
require_once('lib/json.class.php');		    //JSON类
require_once("lib/func.class.php");         //核心类
require_once("lib/rabc.class.php");         //查询类
require_once("lib/image.class.php");        //图片类


//操作值
$action=empty($_GET['action'])?'':trim($_GET['action']); 	 //get action值
$do=empty($_GET['do'])?'':trim($_GET['do']);			 	 //get do值
$id=empty($_GET['id'])?'':intval($_GET['id']);				 //get id值
$cuserid=empty($_GET['userid'])?'':intval($_GET['userid']);  //get userid值


//读取参数数组
$sql_tt="SELECT id,title,type FROM `rv_type`";
$db->query($sql_tt);
$type_cut=$db->fetchAll();
foreach ($type_cut as $key => $val) {
	$type_cut[$val[type]][$val[id]] = $val[title];
	unset($type_cut[$key]);
}


//初始值参数数组
$areaid=$type_cut[areaid];				//区域参数
$typeid=$type_cut[typeid];				//类型参数
$productid=$type_cut[productid];		//产品参数
$doctid=$type_cut[doctid];				//文档参数


//读取用户数组
$sql_user="SELECT id,username FROM `rv_user`";
$db->query($sql_user);
$user_arr=$db->fetchAll();
foreach($user_arr as $key=>$val){
	$user_list[$user_arr[$key][id]]=$user_arr[$key][username];	 //用户数组
}


//执行页面
switch ($action){
	case "":
	  include('action/action.index.php');     //首页
	  break;
	case "info":
	  include('action/action.info.php');      //客户
	  break;
	case "sell":
	  include('action/action.sell.php');      //销售
	  break;
	case "daily":
	  include('action/action.daily.php');     //日报
	  break;
	case "photo":
	  include('action/action.photo.php');     //照片
	  break;
	case "tel":
	  include('action/action.tel.php');       //电话
	  break;
	case "doc":
	  include('action/action.doc.php');       //公告
	  break;
	case "track":
	  include('action/action.track.php');     //打卡
	  break;
	case "note":
	  include('action/action.note.php');      //反馈
	  break;
	case "report":
	  include('action/action.report.php');    //报表
	  break;
	case "config":
	  include('action/action.config.php');    //配置
	  break;
	case "role":
	  include('action/action.role.php');      //角色
	  break;
	case "user":
	  include('action/action.user.php');      //用户
	  break;
	case "data":
	  include('action/action.data.php');      //数据
	  break;
	case "mobile":
	  include('action/action.mobile.php');	  //手机
	  break;
	default:
	  echo "404!";
}

?>