<?php
// $Id: article.feed.inc 1 2010-04-13 13:59:57Z east $

/**
 * 全站或用户或分类最新文章 rss
 */
function article_get_feed_node($uid = NULL, $tid = NULL){
  global $conf,$base_url;
  $title = '';
  
  if($uid){
    $fetch = db_query('SELECT n.*, u.uid, u.name FROM {article} n INNER JOIN {users} u ON n.uid = u.uid WHERE n.uid = ? ORDER BY n.nid DESC', array($uid), array('limit' => 100));
    $link = $base_url;
    $title = t('article', '最新文章');
  }else if($tid){
    $fetch = db_query('SELECT n.*, u.uid, u.name FROM {article} n INNER JOIN {users} u ON n.uid = u.uid INNER JOIN {fields_term_node} t ON n.nid = t.nid WHERE t.tid = ? ORDER BY n.nid DESC', array($tid), array('limit' => 100));
  }else{
    $fetch = db_query('SELECT n.*, u.uid, u.name FROM {article} n INNER JOIN {users} u ON n.uid = u.uid ORDER BY n.nid DESC', array(''), array('limit' => 100));
  }
  
  if($fetch){
    foreach($fetch as $article){
      if(!$title){
        if($tid){
          $term = field_term_load($tid);
          $title = $term->name .'_'. t('article', '分类');
        }else{
          $link = $base_url;
          $title = t('article', '!string 的最新文章', array('!string' => $article->name));
        }
      }
      
      if($conf['article_rss_node'] == 1){
        $body = $article->description;
      }else{
        $body = $article->body;
      }
      
      $items .= dd_rss_item(
        array(
          'title' => check_plain($article->title),
          'description' => $body,
          'link' => url($base_url.'/article/'.$article->nid),
        ), 'item',
        array(
            array('key' => 'pubDate', 'value' => gmdate('r', $article->created)),
            array('key' => 'dc:creator', 'value' => $article->name),
            array('key' => 'guid', 'value' => $article->nid . ' at ' . $base_url, 'attributes' => array('isPermaLink' => 'false'))
         )
      );
    }
  }else{
    $items = t('article', '没有数据');
  }
  
  return article_get_feed($items, $title, $link);
}

function article_get_feed($items, $title, $link = NULL, $des = NULL){
  global $conf, $base_url;
  
  if(strpos($conf['site_global']['logo'], 'http') === false){
    $logo = $base_url . $conf['site_global']['logo'];
  }else{
    $logo = $conf['site_global']['logo'];
  }
  
  return dd_rss_feed($items, NULL, array(
    'title' => $title .'_'. $conf['site_global']['name'],
    'description' => ($des ? $des :$conf['site_global']['description']),
    'link' => ($link ? $link : $base_url),
    'image' => array(
      'url' => $logo,
      'title' => $conf['site_global']['name'],
      'link' => $base_url,
    ),
  ));
}