<?php
// $Id$

/**
 * @template 评论默认模板
 * 可根据评论的不同扩展类型，创建不同模板文件。
 * 如：ext_type 为 forum，则可使用 comment_forum.tpl.php
 */

?>

<div id="comment_<?php echo $comment->ext_type?>_<?php echo $comment->cid?>" 
class="comment_view comment_view_<?php echo $zebra; ?> comment_view_<?php echo $comment->ext_type?>">

  <p class="comment_header">
    <strong><?php echo $comment->count;?>.</strong>
    <span class="comment_name">
      <?php if ($comment->site) { ?>
        <a rel="external" target="_blank" href="<?php echo $comment->site; ?>">
          <?php echo $comment->name; ?>
        </a>
        <?php if (!$comment->uid) : ?> (未登录) <?php endif;?>
      <?php } else { ?>
        <?php echo theme('username', $comment); ?>
      <?php } ?>
    </span>
    - <?php echo format_date($comment->created); ?>
    <?php if($comment->title) : ?>
    - <?php echo $comment->title; ?>
    <?php endif?>
    <?php if ($comment->is_create) :?>
    - <a href="#comment_form" class="comment_quote" alt="<?php echo $comment->cid; ?>">#引用</a> | <a href="#comment_form" class="comment_reply" alt="<?php echo $comment->cid; ?>">#回复</a>
    <?php endif ?>
  </p>
  <div class="comment_body"><?php echo $comment->body; ?></div>
  
  <?php if($comment->links) : ?>
  <div class="comment_links"><?php echo $comment->links; ?></div>
  <?php endif?>
  
</div>