<?php
// $Id$
function ggad_node_form($ggad = NULL){
  /**
   * 表单与drupal略有不同
   * $form['settings'] 下是是表单的一些参数
   * $form['fields'] 则为表单字段
   */
  $form['settings'] = array(
    '#ajax_validate' => 1, // 是否ajax验证基本内容，即非必填内容等
    '#redirect' => url('admin/ggad'), // 提交成功后跳转地址
  );
  $form['fields']['nid'] = array(
    '#type' => 'hidden',
    '#default_value' => $ggad->nid,
    '#constant' => 1
  );  
  $form['fields']['title'] = array(
    '#title' => t('article', '标题'),
    '#type' => 'textfield',
    '#default_value' => $ggad->title,
    '#required' => 1,
    '#weight' => -10,
    '#attributes' => array('size' => 100)
  );
  $form['fields']['url'] = array(
    '#title' => t('ggad', '链接地址'),
    '#type' => 'textfield',
    '#default_value' => $ggad->url,
    '#required' => 1,
    '#weight' => -10,
    '#attributes' => array('size' => 100)
  ); 
  $form['fields']['litpic'] = array(
    '#title' => t('litpic', '缩略图'),
    '#type' => 'file',
		'#description' => isset($ggad->litpic) ? '<img src="/'.image_get_thumb($ggad->fid,$ggad->litpic,'60x60','scale_and_crop').'" /><a href="'.url('files/'.$ggad->fid.'/delete').'" class="confirmajax" level="parent" target="_blank">删除</a>' : '',
    '#filesave' => false,// 系统处理上传文件
    '#validate' => array(
      'savepath' => 'ggad',
      'no_insert' => true,
      'title' => '缩略图',
      'filename' => 'image',
      'image' => array(
        'type' => array('jpg', 'png', 'gif'),
      ),
    ),
  );  
  
  // 调用一个字段组
  field_get_node_form('ggad', 'my_field', $ggad, $form, 0);
  
  $form['fields']['submit'] = array(
    '#type' => 'submit',
    '#submit' => 'ggad_node_form_submit', // 提交时回调函数
    '#weight' => 100
  );
  
  return $form;
}

// 表单提交回调函数
function ggad_node_form_submit($form, $v){
	$f = file_save_upload($_FILES['litpic']);
	$v['fid'] = $f->fid;
	ggad_save($v);
}
