<?php
// $Id: product.feed.inc 1 2010-04-13 13:59:57Z east $

/**
 * 全站或用户或分类最新产品 rss
 */
function product_get_feed_node($uid = NULL, $tid = NULL){
  global $conf,$base_url;
  $title = '';
  
  if($uid){
    $fetch = db_query('SELECT n.*, u.uid, u.name FROM {product} n INNER JOIN {users} u ON n.uid = u.uid WHERE n.uid = ? ORDER BY n.nid DESC', array($uid), array('limit' => 100));
    $link = $base_url;
    $title = t('product', '最新产品');
  }else if($tid){
    $fetch = db_query('SELECT n.*, u.uid, u.name FROM {product} n INNER JOIN {users} u ON n.uid = u.uid INNER JOIN {fields_term_node} t ON n.nid = t.nid WHERE t.tid = ? ORDER BY n.nid DESC', array($tid), array('limit' => 100));
  }else{
    $fetch = db_query('SELECT n.*, u.uid, u.name FROM {product} n INNER JOIN {users} u ON n.uid = u.uid ORDER BY n.nid DESC', array(''), array('limit' => 100));
  }
  
  if($fetch){
    foreach($fetch as $product){
      if(!$title){
        if($tid){
          $term = field_term_load($tid);
          $title = $term->name .'_'. t('product', '分类');
        }else{
          $link = $base_url;
          $title = t('product', '!string 的最新产品', array('!string' => $product->name));
        }
      }
      
      if($conf['product_rss_node'] == 1){
        $body = $product->description;
      }else{
        $body = $product->body;
      }
      
      $items .= dd_rss_item(
        array(
          'title' => check_plain($product->title),
          'description' => $body,
          'link' => url($base_url.'/product/'.$product->nid),
        ), 'item',
        array(
            array('key' => 'pubDate', 'value' => gmdate('r', $product->created)),
            array('key' => 'dc:creator', 'value' => $product->name),
            array('key' => 'guid', 'value' => $product->nid . ' at ' . $base_url, 'attributes' => array('isPermaLink' => 'false'))
         )
      );
    }
  }else{
    $items = t('product', '没有数据');
  }
  
  return product_get_feed($items, $title, $link);
}

function product_get_feed($items, $title, $link = NULL, $des = NULL){
  global $conf, $base_url;
  
  if(strpos($conf['site_global']['logo'], 'http') === false){
    $logo = $base_url . $conf['site_global']['logo'];
  }else{
    $logo = $conf['site_global']['logo'];
  }
  
  return dd_rss_feed($items, NULL, array(
    'title' => $title .'_'. $conf['site_global']['name'],
    'description' => ($des ? $des :$conf['site_global']['description']),
    'link' => ($link ? $link : $base_url),
    'image' => array(
      'url' => $logo,
      'title' => $conf['site_global']['name'],
      'link' => $base_url,
    ),
  ));
}