<?php
// $Id: sina_open.admin.inc,v 1.3 2010/09/16 08:40:43 eastcn Exp $

/**
 * 管理设置
 */
function sina_open_admin_settings(){
  $form['fields']['sina_open_is_login'] = array(
    '#type' => 'radio',
    '#title' => '允许使用微博帐号登录',
    '#default_value' => var_get('sina_open_is_login', 1),
    '#options' => array('不允许', '允许'),
    '#description' => '将自动创建一个新用户'
  );
  $form['fields']['sina_open_oauth_consumer_key'] = array(
    '#type' => 'textfield',
    '#title' => '新浪微博 API',
    '#default_value' => var_get('sina_open_oauth_consumer_key', NULL),
    '#description' => '你可以到 http://open.t.sina.com.cn/wiki/index.php 申请，若没有，请留空。'
  );
  $form['fields']['sina_open_oauth_consumer_secret'] = array(
    '#type' => 'textfield',
    '#title' => 'API 密钥',
    '#default_value' => var_get('sina_open_oauth_consumer_secret', NULL),
    '#description' => '除非你自行设置了 API，否则请留空'
  );
  $form['fields']['sina_open_comment'] = array(
    '#type' => 'radio',
    '#title' => '在评论中启用',
    '#default_value' => var_get('sina_open_comment', 1),
    '#options' => array('否', '是')
  );
  
  $form['fields']['sina_open_types'] = array(
    '#type' => 'textfield',
    '#title' => '支持内容类型',
    '#default_value' => var_get('sina_open_types', NULL),
    '#description' => '支持内容类型'
  );
	$form['settings'] = array(
    '#validate' => array('sina_open_admin_settings_validate'),
  );
	$form['fields']['submit']['#type'] = 'submit';
  
  return $form;
}

function sina_open_admin_settings_validate($form, $value){
	foreach($value as $key=>$val){
		var_set($key,$val);
	}
}
/**
 * 绑定了新浪微博帐号或通过新浪微博帐号注册的用户
 */
function sina_open_admin_users() {
  $fetch = pager_query('SELECT u.uid, u.name FROM {sina_open_user} s INNER JOIN {users} u ON s.uid = u.uid ORDER BY u.uid DESC', 50);
  $table = NULL;
	if($fetch){
		foreach($fetch as $o) {
			$destination = array('query' => drupal_get_destination());
			$table[] = array(
				theme('username', $o),
				l('解除绑定', 'user/'.$o->uid.'/sina_open/remove', $destination),
				l('删除用户', 'user/'.$o->uid.'/delete', $destination)
			);
		}
	}
  
  if ($table) {
    $output =  theme('table', array(), $table);
    $output .= theme('pager');
  } else {
    $output = '没有数据';
  }
  
  return $output;
}