<?php

function admin_log($action, $content, $string='')
{
	global $_admin;
	$log_action = lang("log_action");
	$log_content = lang("log_content");
    $log_info = $log_action[$action] .'->'. $log_content[$content] .': '. addslashes($string);

    $sql = 	' INSERT INTO ' . table('adminlog') .
    		' (time, username, action, ip) ' .
            " VALUES ('" . date("Y-m-d G:i:s") . "', '". $_admin['username']."', '" . stripslashes($log_info) . "', '" . real_ip() . "')";
    $GLOBALS['db']->query($sql);
}

function lang ()
{
	global $admin_lang;
	
	$arg_list = func_get_args();
	
	if (count($arg_list) == 1)
		return $admin_lang[$arg_list[0]];
	
	$i = 0;
	$text = $admin_lang[$arg_list[0]];
	array_shift($arg_list);
	foreach ($arg_list as $item) {
		$text = str_replace("{".$i."}", $item, $text);
		$i++;
	}
	
	return $text;
}

function showmessage($message, $urlforward = '') {
	include admin_template('showmessage');
	exit();
}

function check_login() {
	global $_admin;
	
	if(empty($_admin['id'])) {
	header("Location: ./index.php?act=login\n");
    exit;
	}
}

function hsys_referer() {
	@$referer = $_POST['referer'] ? $_POST['referer'] : htmlspecialchars($_SERVER['HTTP_REFERER']);
	if(strpos($referer, 'logout') || strpos($referer, 'register') || strpos($referer, 'login')) {
		$referer = 'index.php';
	}
	return $referer;
}


function clearAllCookies() {
	foreach($_COOKIE as $k=>$v) {
		setcookie($k, '', -8640000,'/');
	}
}


//生成编辑器
function create_editor($editor_name, $editor_value = '')
{
	require_once(root_path . 'include/fckeditor/fckeditor.php');
    $editor = new FCKeditor($editor_name);
    $editor->BasePath   = '../include/fckeditor/';
    $editor->ToolbarSet = 'Normal';
    $editor->Width      = '100%';
    $editor->Height     = '320';
    $editor->Value      = $editor_value;
    return $editor->CreateHtml();
}

//更新数据库
function updatedb($tablename, $columns, $id)
{
	if($id&&$tablename){
	$sql = 	' UPDATE '.$tablename.
			' SET '.$columns.
			' WHERE id='.$id;
	return $GLOBALS['db']->query($sql);
	}else{
		return 0;
	}
}

//删除一条记录
function dropone($tablename, $id)
{
	if($id&&$tablename){
	$sql = 	' DELETE FROM '.$tablename.
			' WHERE id='.$id;
	return $GLOBALS['db']->query($sql);
	}else{
		return 0;
	}
}

//删除一条记录
function dropall($tablename, $filter)
{
	if($filter&&$tablename){
	$sql = 	' DELETE FROM '.$tablename.
			' WHERE '.$filter;
	return $GLOBALS['db']->query($sql);
	}else{
		return 0;
	}
}


//----------------------------------------
//下面是文章相关函数

/**
 * 返回是否
 * @param   int     $var    变量 1, 0
 */
function get_yes_no($var)
{
    return empty($var) ? '<img src="images/no.gif" border="0" />' : '<img src="images/yes.gif" border="0" />';
}

/**
 * 创建一个JSON格式的数据
 *
 * @access  public
 * @param   string      $content
 * @param   integer     $error
 * @param   string      $message
 * @param   array       $append
 * @return  void
 */
function make_json_response($content='', $error="0", $message='', $append=array())
{
    include_once(root_path . 'include/class.web.json.php');
    $json = new json;
    $res = array('error' => $error, 'message' => $message, 'content' => $content);
    if (!empty($append))
    {
        foreach ($append AS $key => $val)
        {
            $res[$key] = $val;
        }
    }
    $val = $json->encode($res);
    exit($val);
}

/**
 *
 *
 * @access  public
 * @param
 * @return  void
 */
function make_json_result($content, $message='', $append=array())
{
    make_json_response($content, 0, $message, $append);
}

/**
 * 创建一个JSON格式的错误信息
 *
 * @access  public
 * @param   string  $msg
 * @return  void
 */
function make_json_error($msg)
{
    make_json_response('', 1, $msg);
}

/**
 * 根据过滤条件获得排序的标记
 *
 * @access  public
 * @param   array   $filter
 * @return  array
 */
function sort_flag($filter)
{
    $flag['tag']    = 'sort_' . preg_replace('/^.*\./', '', $filter['sort_by']);
    $flag['img']    = '<img src=images/' . ($filter['sort_order'] == "DESC" ? 'sort_desc.gif' : 'sort_asc.gif') . '>';
    return $flag;
}

/**
 * 分页的信息加入条件的数组
 *
 * @access  public
 * @return  array
 */
function page_and_size($filter)
{
    if (isset($_REQUEST['page_size']) && intval($_REQUEST['page_size']) > 0)
    {
        $filter['page_size'] = intval($_REQUEST['page_size']);
    }
    elseif (isset($_COOKIE['hsys']['page_size']) && intval($_COOKIE['hsys']['page_size']) > 0)
    {
        $filter['page_size'] = intval($_COOKIE['hsys']['page_size']);
    }
    else
    {
        $filter['page_size'] = 15;
    }

    /* 每页显示 */
    $filter['page'] = (empty($_REQUEST['page']) || intval($_REQUEST['page']) <= 0) ? 1 : intval($_REQUEST['page']);
    /* page 总数 */
    $filter['page_count'] = (!empty($filter['record_count']) && $filter['record_count'] > 0) ? ceil($filter['record_count'] / $filter['page_size']) : 1;
    /* 边界处理 */
    if ($filter['page'] > $filter['page_count'])
    {
        $filter['page'] = $filter['page_count'];
    }
    $filter['start'] = ($filter['page'] - 1) * $filter['page_size'];
    return $filter;
}

/**
 * 保存过滤条件
 * @param   array   $filter     过滤条件
 * @param   string  $sql        查询语句
 * @param   string  $param_str  参数字符串，由list函数的参数组成
 */
function set_filter($filter, $sql, $param_str = '')
{
    $filterfile = basename($_SERVER['PHP_SELF'], '.php');
    if ($param_str)
    {
        $filterfile .= $param_str;
    }
    setcookie('hsys[lastfilterfile]', sprintf('%X', crc32($filterfile)), time() + 600);
    setcookie('hsys[lastfilter]',     urlencode(serialize($filter)), time() + 600);
    setcookie('hsys[lastfiltersql]',  urlencode($sql), time() + 600);
}

/**
 * 取得上次的过滤条件
 * @param   string  $param_str  参数字符串，由list函数的参数组成
 * @return  如果有，返回array('filter' => $filter, 'sql' => $sql)；否则返回false
 */
function get_filter($param_str = '')
{
    $filterfile = basename($_SERVER['PHP_SELF'], '.php');
    if ($param_str)
    {
        $filterfile .= $param_str;
    }
    if (isset($_GET['uselastfilter']) && isset($_COOKIE['hsys']['lastfilterfile'])
        && $_COOKIE['hsys']['lastfilterfile'] == sprintf('%X', crc32($filterfile)))
    {
        return array(
            'filter' => unserialize(urldecode($_COOKIE['hsys']['lastfilter'])),
            'sql'    => urldecode($_COOKIE['hsys']['lastfiltersql'])
        );
    }
    else
    {
        return false;
    }
}


function sql_import($sql_file)
{
    $db_ver  = $GLOBALS['db']->version();
    $sql_str = array_filter(file($sql_file), 'remove_comment');
    $sql_str = str_replace("\r", '', implode('', $sql_str));

    $ret = explode(";\n", $sql_str);
    $ret_count = count($ret);

    if ($db_ver > '4.1')
    {
        for($i = 0; $i < $ret_count; $i++)
        {
            $ret[$i] = trim($ret[$i], " \r\n;"); 
            if (!empty($ret[$i]))
            {
                if ((strpos($ret[$i], 'CREATE TABLE') !== false) && (strpos($ret[$i], 'DEFAULT CHARSET=utf8')=== false))
                {
                    $ret[$i] = $ret[$i] . ' DEFAULT CHARSET=utf8';
                }
                $GLOBALS['db']->query($ret[$i]);
            }
        }
    }
    else
    {
        for($i = 0; $i < $ret_count; $i++)
        {
            $ret[$i] = trim($ret[$i], " \r\n;"); 
            if ((strpos($ret[$i], 'CREATE TABLE') !== false) && (strpos($ret[$i], 'DEFAULT CHARSET=utf8')!== false))
            {
                $ret[$i] = str_replace('DEFAULT CHARSET=utf8', '', $ret[$i]);
            }
            if (!empty($ret[$i]))
            {
                $GLOBALS['db']->query($ret[$i]);
            }
        }
    }

    return true;
}

function remove_comment($var)
{
    return (substr($var, 0, 2) != '--');
}




function dir_size($dir) {
        if (!preg_match('@/$@', $dir)) {
                $dir .= '/';
        }
        $totalsize = 0;
        foreach (get_file_list($dir) as $name) {
                $totalsize += (@is_dir($dir.$name) ? dir_size("$dir$name/") :
                (int)@filesize($dir.$name));
        }
        return $totalsize;
}

function get_file_list($path) {
        $f = $d = array();
        foreach (get_all_files($path) as $name) {
                if (@is_dir($path.$name)) {
                        $d[] = $name;
                } else if (@is_file($path.$name)) {
                        $f[] = $name;
                }
        }
        natcasesort($d);
        natcasesort($f);
        return array_merge($d, $f);
}
 
function get_all_files($path) {
        $list = array();
        if (($hndl = @opendir($path)) === false) {
                return $list;
        }
        while (($file=readdir($hndl)) !== false) {
                if ($file != '.' && $file !='..') {
                        $list[] = $file;
                }
        }
        closedir($hndl);
        return $list;
}

function trimSize($fileSize) {
        $size = sprintf("%u", $fileSize);
        if($size == 0) {
                return("0 Bytes");
        }
        $sizename = array(" Bytes", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB");
        return round($size/pow(1024, ($i = floor(log($size, 1024)))), 2) . $sizename[$i];
}

?>