<?php
defined('at_hopesys') or exit('Access Denied');

// Include the txt-db-api main source
include "txtdbapi/txt-db-api.php";

class cls_txtdb
{
	var $connid;
	
	function connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect = 0) 
	{
		if(!$this->connid = new Database($dbname))
		{
			$this->halt('Can Not Open Php-Txt-Db-Api,Please Checkout.');
		}
		return $this->connid;
	}

	function select_db($dbname) 
	{
		if(!$this->connid = new Database($dbname))
		{
			$this->halt('Can Not Open Php-Txt-Db-Api,Please Checkout.');
		}
		return $this->connid;
	}

	function query($sql) 
	{
		if(!($query = $this->connid->executeQuery($sql)))
		{
			$this->halt('TXT DB Query Error', $sql);
		}
		return $query;
	}

	
	function get_one($sql)
	{
		$query = $this->query($sql);
		$result = $this->fetch_array($query);
		return $result ;
	}

	
	function fetch_array($rs) 
	{
		if($rs->next()){
		return $rs->getCurrentValuesAsHash();
		}else{
		return false;
		}
	}


	function num_rows($query) 
	{
		return $query->getRowCount();
	}

	function fetch_row($rs) 
	{
		if($rs->next()){
		return $rs->getCurrentValues();
		}else{
		return false;
		}
	}

	function free_result($rs)
	{
	    unset($rs);
	}

	function close()
	{
	    unset($this->connid);
	}

	function version() 
	{
		return $this->connid->txtdbapi_version();
	}

	function error()
	{
		return $this->connid->txtdbapi_get_last_error ();
	}


	function halt($message = '', $sql = '')
	{
		exit("Txtdb Query:$sql <br> Txtdb Error:".$this->error()." <br> Message:$message");
	}
}
?>