<?php
class cls_directory
{
	var $_root = '';
	var $_cdir = '';
	var $_updir = '';
	var $_icondir = '';
	var $_icon = array();
	var $_iconext = 'gif';
	var $_dirs = array();
	var $_files = array();
	var $_ext = array();
	
    function cls_directory()
    {
    }
    
///////////////////////////////////////////////////////
// 实例化类
///////////////////////////////////////////////////////

    function &getInstance()
    {
        static $instance;
        if (empty($instance))
        {
            $instance = new cls_directory;
        }
        return $instance;
    }
    

///////////////////////////////////////////////////////
// 设置根目录
///////////////////////////////////////////////////////

    function setRoot($var)
    {
    	$this->_root = $var;
    }
    

///////////////////////////////////////////////////////
// 设置当前目录
///////////////////////////////////////////////////////

    function setCDir($var)
    {
    	$this->_cdir = $var;
    }
    

///////////////////////////////////////////////////////
// 获取当前目录
///////////////////////////////////////////////////////

    function getCDir()
    {
    	return $this->_cdir;
    }
    

///////////////////////////////////////////////////////
// 获取目录列表
///////////////////////////////////////////////////////

    function getDirs()
    {
    	return $this->_dirs;
    }
    

///////////////////////////////////////////////////////
// 获取文件列表
///////////////////////////////////////////////////////

    function getFiles()
    {
    	return $this->_files;
    }
    

///////////////////////////////////////////////////////
// 获取上级目录列表
///////////////////////////////////////////////////////

    function upDir()
    {
		if ($this->_cdir)
		{
			$this->_updir = substr($this->_cdir, 0, strrpos($this->_cdir, '/'));
		}
    }

    
///////////////////////////////////////////////////////
// 获取上级目录连接
///////////////////////////////////////////////////////

	function getUpDir()
    {
		return $this->_updir;
    }
    
    
///////////////////////////////////////////////////////
// 设置文件对应ICON图标
// @param String $iconDir ICON图片目录，以"/"结尾
// @param Array $icon 关联数组：array('html'=>array('html', 'htm', 'tpl'), 'php'=>array('php', 'php3'))
// @param String $ext ICON图片后缀名，如：gif
///////////////////////////////////////////////////////
    function setIcon($iconDir, $icon, $ext)
    {
    	$this->_icondir = $iconDir;
    	$this->_icon = $icon;
    	$this->_iconext = $ext;
    }
    
///////////////////////////////////////////////////////
// 返回文件ICON
///////////////////////////////////////////////////////
    function getIcon($fileext)
    {
    	if ($this->_icon)
    	{
    		foreach ($this->_icon as $key => $value)
    		{
    			foreach ($value as $ext)
    			{
    				if ($fileext == $ext)
    				{
    					$icon = $key.'.'.$this->_iconext;
    					$iconfile = $this->_icondir.$icon;
    					if (file_exists($iconfile))
    					{
    						return $icon;
    					}
    					else
    					{
    						break 2;
    					}
    				}
    			}
    		}
    	}
    	return 'unknow.'.$this->_iconext;
    }
///////////////////////////////////////////////////////
// 设置合法后缀名
// param Array $var 后缀名数组：array('html', 'php', 'tpl')
///////////////////////////////////////////////////////
   
    function setExt($var)
    {
    	$this->_ext = $var;
    }
    
///////////////////////////////////////////////////////
// 穷举目录
///////////////////////////////////////////////////////
    function listDir()
    {
    	require_once(root_path . 'include/class.util.datetime.php');
    	$openDir = str_replace(array('\\\\','\\'), array('\\','/'), $this->_root.$this->_cdir);
    	if (is_dir($openDir))
    	{
    		if ($rs = @opendir($openDir))
    		{
    			while (($file = readdir($rs)) !== FALSE)
    			{
    				if ($file != '.' && $file != '..')
    				{
    					$dfile = $openDir.'/'.$file;
    					if (is_dir($dfile))
    					{
    						//dir
    						$this->_dirs[] = array($file, $this->getIcon('dir'), '&directory='.$this->_cdir.'/'.$file);
    					}
    					else
    					{
    						//file
    						$ext = substr($file, strpos($file, '.') + 1);
    						if (!$this->_ext || in_array($ext, $this->_ext))
    						{
    							$this->_files[] = array($file, $this->getIcon($ext), trimSize(filesize($dfile)), cls_datetime::cdate('Y-m-d G:i:s',filemtime($dfile)), '&directory='.$this->_cdir.'&filename='.urlencode($file));
    						}
    					}
    				}
    			}
    		}
    	}
    }
}
?>