<?php
/*
 *
 * $csql = "SELECT COUNT(id) FROM user";
 * $sql  = "SELECT * FROM user";
 *
 * $page = new page($csql, $sql, "a.php?a=1", "pageid", 10);
 *
 * foreach ($page->getData() as $row) {
 *     var_dump($row);
 * }
 *
 * echo $page->getBar();
 *
 */

class page {
	
    var $countSQL;    // select count sql
    var $querySQL;    // query sql
    var $queryURI;    // URI
    var $pageSize;    // page size, default 15
    var $currPage;    // current page
    var $pageParam;   // page parameter
    var $totalRecord; // record nums
    var $totalPage;   // total page
    var $firstPage = "第一页";
    var $prevPage  = "上一页";
    var $nextPage  = "下一页";
    var $lastPage  = "最尾页";

    function __construct($countSQL, $querySQL, $queryURI="?", $pageParam="pagenum", $pageSize=15) {
        $this->countSQL    = $countSQL;
        $this->querySQL    = $querySQL;
        $this->queryURI    = $queryURI;
        $this->pageParam   = $pageParam;
        $this->currPage    = intval($_GET[$pageParam]);
        $this->pageSize    = $pageSize;
        $records           =  $GLOBALS['db']->getone($countSQL);
        $this->totalRecord = intval($records[0]);
        $this->totalPage   = ceil($this->totalRecord / $this->pageSize);
        if ($this->currPage < 1) {
            $this->currPage = 1;
        }
        if ($this->currPage > $this->totalPage) {
            $this->currPage = $this->totalPage;
        }
    }

    function getData() {
        if ($this->totalRecord == 0)
            return array();
        $this->querySQL = $this->querySQL." LIMIT ".($this->currPage - 1) * $this->pageSize.", {$this->pageSize}";
        return  $GLOBALS['db']->getall($this->querySQL);
    }

    function getBar() {
        if ($this->totalRecord == 0)
            return "";
        $bar = "";
        if ($this->currPage > 1) { // has first and prev
            $this->firstPage = "<a href=\"".$this->queryURI."&{$this->pageParam}=1\">{$this->firstPage}</a>";
            $this->prevPage  = "<a href=\"".$this->queryURI."&{$this->pageParam}=".($this->currPage-1)."\">{$this->prevPage}</a>";
        } else {
            $this->firstPage = "";
            $this->prevPage  = "";
        }
        if ($this->currPage < $this->totalPage && $this->totalPage > 1) { // has next and last
            $this->nextPage  = "<a href=\"".$this->queryURI."&{$this->pageParam}=".($this->currPage+1)."\">{$this->nextPage}</a>";
            $this->lastPage  = "<a href=\"".$this->queryURI."&{$this->pageParam}=".$this->totalPage."\">{$this->lastPage}</a>";
        } else {
            $this->nextPage  = "";
            $this->lastPage  = "";
        }
        $viewNums = 8;
        $viewStr  = "";
        $start = $this->currPage - $viewNums/2;        
        if($start > $this->totalPage-$viewNums){
        	$start = $this->totalPage - $viewNums;
        }
        if ($start < 1) {
            $start = 1;
        }
        $end = $this->currPage + $viewNums/2;
        if($end < $viewNums+1){
        	$end = $viewNums+1;
        }
        if ($end > $this->totalPage) {
            $end = $this->totalPage;
        }
        for ($i = $start; $i <= $end; $i++) {
            if ($i > $this->totalPage)
                break;
            if ($i == $this->currPage) {
                $viewStr .= "$i ";
            } else {
                $viewStr .= "<a class=\"number\" href=\"".$this->queryURI."&{$this->pageParam}=$i\">$i</a> ";
            }
        }
        $bar = "{$this->firstPage} {$this->prevPage} {$viewStr} {$this->nextPage} {$this->lastPage}";
        return $bar;
    }

}
?>