<?php
defined('at_hopesys') or exit('Access Denied');

function class2options($classes, $pid=0, $selectedids=array(), $unselectedids=array(),  $level=0, $symbols=''){
	//判断儿子数
	$selectedids = is_array($selectedids) ? $selectedids : array($selectedids);
	$unselectedids = is_array($unselectedids) ? $unselectedids : array($unselectedids);
	$symbol_first = '├';
	$symbol_pre = '│';
	$symbol_son = "├";
	$symbol_son_lastone = "└";
	$symbol_blank = '　';
	
	//根据当前位置，　算出传递给下一级的符号
	$sons = getsons($classes, $pid);
	$sonsnum = count($sons);
	$s = '';
	if(is_array($sons) && $sonsnum) {
		$i = 0;
		foreach($sons as $classid=>$son) {
			$i++;
			if(in_array($classid, $unselectedids)) {
				continue;
			}
			$symbol = $i == $sonsnum ? $symbol_son_lastone : $symbol_son;		//最后一个
			$symbol = $level==0 && $i==1 ? $symbol_first : $symbol;				//第一个
			$selected = @in_array($classid, $selectedids) ? ' selected' : '';
			@$s .= "<option value=\"{$son['id']}\" $selected>".$symbols.$symbol."{$son['name']}</option>\r\n";
			//判断传递的符号
			//最后一个为空，否则为 |
			$s .= class2options($classes, $son['id'], $selectedids, $unselectedids, $level+1, $symbols.($i==$sonsnum ? $symbol_blank : $symbol_pre));
		}
	}
	return $s;
}

//后台用到生成分类树
function getclasstree($classes, $pid=0, $level = 1){
	$scriptname = basename($_SERVER['PHP_SELF']);
	$s = '<ul style=\"padding:0px\">';
	//判断儿子数
	$sons = getsons($classes, $pid);
	$sonsnum = count($sons);
	if(is_array($sons) && $sonsnum) {
		$i = 0;
		foreach($sons as $id=>$son) {
			$i++;
			@$s .= "<li style=\"padding-left:".(1*$level)."\"\"><b>$son[name]</b>　　
				 <a href=\"$scriptname?act=sort_edit&id=$son[id]\">[".lang("do_edit")."]</a>
				 <a href=\"javascript:if(window.confirm('".lang("alert_dropclassconfirm")."'))window.location='$scriptname?act=sort_del&id=$son[id]'\">[".lang("do_remove")."]</a>
				 <a href=\"$scriptname?act=add&cid=$son[id]\">[".lang("do_addcontent")."]</a>
				 </li>\r\n";
			$s .= "<ul style=\"padding:0px;margin:0px;\">".getclasstree($classes, $son['id'], $level+1)."</ul>";
		}
	}
	$s .= '</ul>';
	return $s;
}

//前台用到生成分类树
function getdownclasstree($classes, $pid=0, $level = 1){
	$scriptname = basename($_SERVER['PHP_SELF']);
	//判断儿子数
	$sons = getsons($classes, $pid);
	$sonsnum = count($sons);
	if(is_array($sons) && $sonsnum) {
		$menuid = '';
		if($pid == 0) $menuid = ' id="suckertree1"';
		$s = '<ul'.$menuid.'>';
		$i = 0;
		foreach($sons as $id=>$son) {
			$i++;
			@$s .= "<li><a href=\"$scriptname?cid=$son[id]\">".$son[name]."</a>";
			$s .= getdownclasstree($classes, $son['id'], $level+1);
			$s .= "</li>\r\n";
		}
		$s .= '</ul>';
	}
	return $s;
}

//前台用到生成分类树
function getnewsclasstree($classes, $pid=0, $level = 1){
	$scriptname = basename($_SERVER['PHP_SELF']);
	//判断儿子数
	$sons = getsons($classes, $pid);
	$sonsnum = count($sons);
	if(is_array($sons) && $sonsnum) {
		$menuid = '';
		if($pid == 0) $menuid = ' id="suckertree1"';
		$s = '<ul'.$menuid.'>';
		$i = 0;
		foreach($sons as $id=>$son) {
			$i++;
			@$s .= "<li><a href=\"$scriptname?cid=$son[id]\">".$son[name]."</a>";
			$s .= getnewsclasstree($classes, $son['id'], $level+1);
			$s .= "</li>\r\n";
		}
		$s .= '</ul>';
	}
	return $s;
}

function getproclasstree($classes, $pid=0, $level = 1){
	$scriptname = basename($_SERVER['PHP_SELF']);
	//判断儿子数
	$sons = getsons($classes, $pid);
	$sonsnum = count($sons);
	if(is_array($sons) && $sonsnum) {
		$i = 0;
		$menuid = '';
		if($pid == 0) $menuid = ' id="suckertree1"';
		$s = '<ul'.$menuid.'>';
		foreach($sons as $id=>$son) {
			$i++;
			@$s .= "<li><a href=#><b>$son[name]</b></a>";
			$s .= "<ul>".makeprolisthtml($son['id'], $level+1)."</ul>";
			$s .= "</li>\r\n";
			//$s .= "<ul>".getproclasstree($classes, $son['id'], $level+1)."</ul>";
		}
		$s .= '</ul>';
	}
	return $s;
}

function makeprolisthtml($cid, $level){
	$scriptname = basename($_SERVER['PHP_SELF']);
	/* 获取产品数据 */
    $sql = ' SELECT * '.
           ' FROM ' .table('pro').
           ' WHERE cid='.$cid.' ORDER by seqs ASC';
	$rs = $GLOBALS['db']->query($sql);
    while ($rows = $GLOBALS['db']->fetch_array($rs))
    {
        $sons[] = $rows;
    }    	
	if(is_array($sons)) {
		foreach($sons as $id=>$son) {
			@$s .= "<li><a href=\"$scriptname?id=$son[id]\">".$son[title]."</a></li>\r\n";
		}
	}
	return $s;
}



function getnewsclassdeletetree($newsclasses, $newsclasspid=0, $level = 1){

	$s = '<ul style=\"padding:0px\">';
	//判断儿子数
	$sons = getsons($newsclasses, $newsclasspid);
	$sonsnum = count($sons);
	if(is_array($sons) && $sonsnum) {
		$i = 0;
		foreach($sons as $newsclassid=>$son) {
			$i++;
			$s .= "<li style=\"padding-left:".(1*$level)."\"\">
			 	<input type=\"checkbox\" value=\"$son[newsclassid]\" name=\"delete[$son[newsclassid]]\">
				<a href=\"news.php?newsclassid=$son[newsclassid]\" target=\"_blank\"><b>$son[name]</b></a></li>\r\n";
			$s .= "<ul style=\"padding:0px;margin:0px;\">".getnewsclassdeletetree($newsclasses, $son['newsclassid'], $level+1)."</ul>";
		}
	}
	$s .= '</ul>';
	return $s;
}


//取一级儿子
function getsons($classes, $pid=0){
	$arr = array();
	foreach($classes as $classid=>$class) {
		if($class['pid'] == $pid && $class['id'] != $pid) {
			$arr[$classid] = $class;
		}
	}
	return $arr;
}



//限制级数，　取儿子，　默认取两级
function getallson($newsclasses, $newsclasspid=0, $deep=2){
	$arr = array();
	if($deep>0){
		if(is_array($newsclasses)){
			foreach($newsclasses as $newsclass){
				if($newsclass['newsclasspid'] == $newsclasspid){
					$arr[$newsclass['newsclassid']] =  $newsclass;
					$arr = $arr + getallson($newsclasses, $newsclass['newsclassid'], $deep-1, $i);
				}
			}
		}
	}
	return $arr;
}


//无限分类导航
function getnewsclasslastlevels($newsclasses, $newsclassid, $includeroot = false) {
	$i = 0;
	$navnewsclasslist = array();
	while(1) {
		$newsclasspid = $newsclasses[$newsclassid]['newsclasspid'];
		if($i++ > 20 || $newsclasspid == 0) {
			break;
		}
		$newspclass =  $newsclasses[$newsclasspid];
		$navnewsclasslist[] = $newspclass;
		$newsclassid = $newspclass['newsclassid'];
	}
	if(!$includeroot && $navnewsclasslist) {
		array_pop($navnewsclasslist);
	}
	return $navnewsclasslist;
}


?>