<?php
defined('at_hopesys') or exit('Access Denied');

function template($template = 'index')
{
global $_conf;
	$compiledtpl = root_path.'/data/cache/'.$template.'.tpl.php';
	$tplfile = root_path.'/templates/'.$_conf['templatename'].'/'.$template.'.htm';
	if(!file_exists($compiledtpl) || @filemtime($tplfile) > @filemtime($compiledtpl))
	{
		require_once root_path.'/include/func.template.php';
		template_refresh($tplfile, $compiledtpl);
	}
	return $compiledtpl;
}


if(!function_exists('file_put_contents'))
{
	define('FILE_APPEND', 8);
	function file_put_contents($file, $string, $append = '')
	{
		$mode = $append == '' ? 'wb' : 'ab';
		$fp = @fopen($file, $mode) or exit("Can not open file $file !");
		flock($fp, LOCK_EX);
		$stringlen = @fwrite($fp, $string);
		flock($fp, LOCK_UN);
		@fclose($fp);
		return $stringlen;
	}
}


function hsys_addslashes($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = hsys_addslashes($val);
		}
	} else {
		$string = addslashes($string);
	}
	return $string;
}


function hsys_stripslashes($string)
{
if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = hsys_stripslashes($val);
		}
	} else {
		$string = stripslashes($string);
	}
return $string;
}

function hsys_auth($str, $operation = 'ENCODE', $key = 'this_is_a_very_strong_key')
{
	$key = $key ? $key : 'this_is_a_very_strong_key2';
    return $operation=='ENCODE' ? hsys_encode($str, $key) : hsys_decode($str, $key);
}

function hsys_encode($str, $key)
{
	srand((double)microtime() * 1000000);
	$encrypt_key = md5(rand(0, 36000));
	$ctr = 0;
	$tmp = '';
	for($i = 0;$i < strlen($str); $i++) 
	{
		$ctr = $ctr == strlen($encrypt_key) ? 0 : $ctr;
		$tmp .= $encrypt_key[$ctr].($str[$i] ^ $encrypt_key[$ctr++]);
	}
	return base64_encode(hsys_key($tmp, $key));
}

function hsys_decode($str, $key) 
{
	$str = hsys_key(base64_decode($str), $key);
	$tmp = '';
	for ($i = 0;$i < strlen($str); $i++)
	{
		$md5 = $str[$i];
		$tmp .= $str[++$i] ^ $md5;
	}
	return $tmp;
}

function hsys_key($str, $key)
{
	$key = md5($key);
	$ctr = 0;
	$tmp = '';
	for($i = 0; $i < strlen($str); $i++)
	{
		$ctr = $ctr == strlen($key) ? 0 : $ctr;
		$tmp .= $str[$i] ^ $key[$ctr++];
	}
	return $tmp;
}


function sub_str($str, $length = 0, $append = true)
{
    $str = trim($str);
    $strlength = strlen($str);

    if ($length == 0 || $length >= $strlength)
    {
        return $str;
    }
    elseif ($length < 0)
    {
        $length = $strlength + $length;
        if ($length < 0)
        {
            $length = $strlength;
        }
    }

    if (function_exists('mb_substr'))
    {
        $newstr = mb_substr($str, 0, $length, 'UTF-8');
    }
    elseif (function_exists('iconv_substr'))
    {
        $newstr = iconv_substr($str, 0, $length, 'UTF-8');
    }
    else
    {
        $newstr = trim_right(substr($str, 0, $length));
    }

    if ($append && $str != $newstr)
    {
        $newstr .= '...';
    }

    return $newstr;
}


function trim_right($str)
{
    $length = strlen(preg_replace('/[\x00-\x7F]+/', '', $str)) % 3;

    if ($length > 0)
    {
        $str = substr($str, 0, 0 - $length);
    }

    return $str;
}


function str_len($str)
{
    $length = strlen(preg_replace('/[\x00-\x7F]/', '', $str));

    if ($length)
    {
        return strlen($str) - $length + intval($length / 3) * 2;
    }
    else
    {
        return strlen($str);
    }
}


function get_crlf()
{
/* LF (Line Feed, 0x0A, \N) 和 CR(Carriage Return, 0x0D, \R) */
    if (stristr($_SERVER['HTTP_USER_AGENT'], 'Win'))
    {
        $the_crlf = '\r\n';
    }
    elseif (stristr($_SERVER['HTTP_USER_AGENT'], 'Mac'))
    {
        $the_crlf = '\r'; // for old MAC OS
    }
    else
    {
        $the_crlf = '\n';
    }

    return $the_crlf;
}



function real_ip()
{
    static $realip = NULL;

    if ($realip !== NULL)
    {
        return $realip;
    }

    if (isset($_SERVER))
    {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);

            /* 取X-Forwarded-For中第一个非unknown的有效IP字符串 */
            foreach ($arr AS $ip)
            {
                $ip = trim($ip);

                if ($ip != 'unknown')
                {
                    $realip = $ip;

                    break;
                }
            }
        }
        elseif (isset($_SERVER['HTTP_CLIENT_IP']))
        {
            $realip = $_SERVER['HTTP_CLIENT_IP'];
        }
        else
        {
            if (isset($_SERVER['REMOTE_ADDR']))
            {
                $realip = $_SERVER['REMOTE_ADDR'];
            }
            else
            {
                $realip = '0.0.0.0';
            }
        }
    }
    else
    {
        if (getenv('HTTP_X_FORWARDED_FOR'))
        {
            $realip = getenv('HTTP_X_FORWARDED_FOR');
        }
        elseif (getenv('HTTP_CLIENT_IP'))
        {
            $realip = getenv('HTTP_CLIENT_IP');
        }
        else
        {
            $realip = getenv('REMOTE_ADDR');
        }
    }

    preg_match("/[\d\.]{7,15}/", $realip, $onlineip);
    $realip = !empty($onlineip[0]) ? $onlineip[0] : '0.0.0.0';

    return $realip;
}


function is_email($user_email)
{
        $chars = "/^([a-z0-9+_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,6}\$/i";
        if (strpos($user_email, '@') !== false && strpos($user_email, '.') !== false)
     {
        if (preg_match($chars, $user_email))
        {
            return true;
        } else
        {
            return false;
        }
    } else
        {
            return false;
        }
}


function is_time($time)
{
    $pattern = '/[\d]{4}-[\d]{1,2}-[\d]{1,2}\s[\d]{1,2}:[\d]{1,2}:[\d]{1,2}/';

    return preg_match($pattern, $time);
}


function randomstr($length) {
	mt_srand((double)microtime() * 1000000);
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

function randomabc($length) {
	mt_srand((double)microtime() * 1000000);
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

function randomnum($length) {
	mt_srand((double)microtime() * 1000000);
	$hash = '';
	$chars = '01234567890123456789';
	$max = strlen($chars) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

function getnetmenu(){
	global $_conf;
	$cachefile = root_path.'/data/cache/hsysnetmenu.php';
	if(!file_exists($cachefile) || @filemtime($cachefile) < (time()-86400))
	{
		file_put_contents($cachefile,base64_decode(file_get_contents("http://hopesys.net/api/netmenu.php?l=".$_conf['admin_lang'])));
	}
	return file_get_contents($cachefile);
}

function gethsysnews(){
	$str = "<script src='http://hopesys.net/api/hsysnews.php?l=".$_conf['admin_lang']."&id=".base64_encode($_SERVER["SERVER_NAME"].'|'.$_SERVER['SERVER_ADDR'].'|'.$_SERVER['SERVER_PORT'])."'></script>";
	return $str;
}


function getAttrib($file_path)
{
    if (!file_exists($file_path))
    {
        return false;
    }

    $attrib_flag = 0;

    if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN')
    {
        $test_file = $file_path . '/hopesys_test_file.txt';

        if (is_dir($file_path))
        {
            $dir = @opendir($file_path);
            if ($dir === false)
            {
                return $attrib_flag; 
            }
            if (@readdir($dir) !== false)
            {
                $attrib_flag ^= 1; 
            }
            @closedir($dir);

            $fp = @fopen($test_file, 'wb');
            if ($fp === false)
            {
                return $attrib_flag;
            }
            if (@fwrite($fp, 'directory access testing.') !== false)
            {
                $attrib_flag ^= 2;
            }
            @fclose($fp);
            @unlink($test_file);
            
            $fp = @fopen($test_file, 'ab+');
            if ($fp === false)
            {
                return $attrib_flag;
            }
            if (@fwrite($fp, "modify test.\r\n") !== false)
            {
                $attrib_flag ^= 4;
            }
            @fclose($fp);


            if (@rename($test_file, $test_file) !== false)
            {
                $attrib_flag ^= 8;
            }
            @unlink($test_file);
        }

        elseif (is_file($file_path))
        {
            $fp = @fopen($file_path, 'rb');
            if ($fp)
            {
                $attrib_flag ^= 1; 
            }
            @fclose($fp);

            $fp = @fopen($file_path, 'ab+');
            if ($fp && @fwrite($fp, '') !== false)
            {
                $attrib_flag ^= 6;
            }
            @fclose($fp);

            if (@rename($test_file, $test_file) !== false)
            {
                $attrib_flag ^= 8;
            }
        }
    }
    else
    {
        if (@is_readable($file_path))
        {
            $attrib_flag ^= 1;
        }

        if (@is_writable($file_path))
        {
            $attrib_flag ^= 14;
        }
    }

    return $attrib_flag;
}




function mysql_like_quote($str)
{
    return strtr($str, array("\\\\" => "\\\\\\\\", '_' => '\_', '%' => '\%'));
}


?>