<?php
defined('at_hopesys') or exit('Access Denied');

/**
 * 写入文件
 * @param String $filename 文件名（包括路径）
 * @param String $content 写入内容
 * @param String $mode 写入模式，默认为'ab'
 * 
 * @return Boolean 写入成功返回TRUE，失败返回FALSE
 */
function writefile($filename, $content, $mode = 'ab')
{
	if (strpos($filename, '..') !== FALSE)
	{
		return FALSE;
	}
	$path = dirname($filename);
	if (!is_dir($path))
	{
		if (!mkdir($path, 0777))
		{
			return FALSE;
		}
	}
	$fp = @fopen($filename, $mode);
	if ($fp)
	{
		flock($fp, LOCK_EX);
		fwrite($fp, $content);
		fclose($fp);
		@chmod($filename, 0777);
		return TRUE;
	}
	return FALSE;
}

/**
 * 读取文件
 * @param String $filename 文件名
 * @param String $mode 文件读取模式
 */
function readfile($filename, $mode = 'rb')
{
	if (strpos($filename, '..') !== FALSE)
	{
		return FALSE;
	}
	return file_get_contents($filename);
}

/**
 * 删除文件
 */
function deletefile($var)
{
	if (strpos($var, '..') !== FALSE)
	{
		return FALSE;
	}
	return @unlink($var);
}

?>