<?php
ob_start();
defined('at_hopesys') or exit('Access Denied');
defined('root_path') or define('root_path', str_replace('include/system.init.php', '', str_replace('\\', '/', __FILE__)));

//判断安装
if (!file_exists(root_path . 'data/install.lock')&& !defined('DONOT_CHECK_INSTALL'))
{
    header("Location: ./install/index.php\n");
    exit;
}
//设置输出编码
header('content-type: text/html; charset=utf-8');
//设置环境
set_magic_quotes_runtime(0);
$_g = $_conf = $_admin = $_cache = array();
unset($_ENV, $HTTP_SERVER_VARS, $HTTP_POST_VARS, $HTTP_POST_FILES, $HTTP_GET_VARS, $HTTP_ENV_VARS, $HTTP_COOKIE_VARS);

//设置常量
define('hVersion','1.0.0.0');
define('hAuthor','Hopesys Team');
define('hRelease','20071215');
define('hContact','ding@hopesys.in');

//程序开始时间
$mt = explode(' ', microtime());
$_g['starttime'] = $mt[1] + $mt[0];
unset($mt);

//包含配置文件
require(root_path . 'data/config.php');
require(root_path . 'include/system.env.php');
require(root_path . 'include/func.common.php');
require(root_path . 'include/func.cache.php');


if (PHP_VERSION >= '5.1' && !empty($_conf['timezone']))
{
    date_default_timezone_set($_conf['timezone']);
}

//处理用户传入变量
if(!get_magic_quotes_gpc()) {
	$_GET    = hsys_addslashes($_GET);
	$_POST   = hsys_addslashes($_POST);
	$_COOKIE = hsys_addslashes($_COOKIE);
	$_REQUEST = hsys_addslashes($_REQUEST);
}

//初始化站点信息
@$_g['domain']	=	get_domain();
@$_g['domainname']	=	get_domain_name();
@$_g['license']	=	$_conf['license'];


//初始化访问者信息
@$_g['onlineip']  = $_SERVER['HTTP_X_FORWARDED_FOR'] ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR'];


//初始化数据库实例
if($_conf['dbtype']=='mysql'){
require(root_path . 'include/class.db.MySQL.php');
$db= new cls_mysql();
}

if($_conf['dbtype']=='access'){
require(root_path . 'include/class.db.Access.php');
$db= new cls_access();
}

if($_conf['dbtype']=='mssql'){
require(root_path . 'include/class.db.MSSQL.php');
$db= new cls_mssql();
}

if($_conf['dbtype']=='txtdb'){
require(root_path . 'include/class.db.Txtdb.php');
$db= new cls_txtdb();
}

$db->connect($_conf['dbhost'],$_conf['dbuser'],$_conf['dbpass'],$_conf['dbname']);

//获取网站全局cache及操作函数文件
if(!file_exists(root_path . 'data/cache/sites.php')){
	//更新新闻分类缓存
	updatecache("newsclasses");
	//更新产品分类缓存
	updatecache("proclasses");
	//更新下载分类缓存
	updatecache("downclasses");
	//更新站点信息缓存
	updatecache("sites");
}
require_once(root_path . 'data/cache/sites.php');
$_g['site'] = $_cache[sites][1];
require(root_path . 'include/hopesys_company.php');
//统计文件，不需要统计可以屏蔽
require(root_path . 'include/system.stat.php');
?>