<?php
// +---------------------------------------------+
// |     Copyright  2008 - 2018 weenCompany      |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

define('IN_ADMIN', true);
define('IN_WEENCOMPANY', true);

$rootpath = "./../";

include($rootpath . 'includes/core.php');

PrintHeader('用戶管理');

// get the value of $action
$action = isset($_POST['action']) ? $_POST['action'] : (isset($_GET['action']) ? $_GET['action'] : 'displayusers');

if($usersystem['name'] != 'weenCompany')
{
	$usersystemerror[] = '網站系統正在使用論壇接口並使用論壇用戶系統及數據庫. 此管理頁僅用於管理weenCompany網站系統的用戶, 當使用論壇接口後, 在此添加或設置用戶將無法登陸或體現新設置的內容, 直至取消論壇接口使用網站用戶系統.';
	PrintErrors($usersystemerror, '正在使用論壇接口');
}

// ################################ INSERT USER ################################

if($action == 'insertuser')
{
  $usergroupid     = $_POST['usergroupid'];
  $username        = trim($_POST['nameofuser']);
  $password        = trim($_POST['password']);
  $passwordconfirm = trim($_POST['passwordconfirm']);
  $email           = trim($_POST['email']);
  $userfullname        = trim($_POST['userfullname']);
  $usercompany        = trim($_POST['usercompany']);
  $useradd        = trim($_POST['useradd']);
  $userpostcode        = trim($_POST['userpostcode']);
  $usertel        = trim($_POST['usertel']);
  $userfax        = trim($_POST['userfax']);
  $useronline        = trim($_POST['useronline']);
  $userwebsite        = trim($_POST['userwebsite']);
  // error checking

  if(strlen($username) == 0)
		$errors[] = '請輸入用戶名!';
  elseif(!isName($username))
		$errors[] = '用戶名存在非法字符!';

  if(strlen($password) == 0)
		$errors[] = '請輸入密碼!';
  elseif(!isPass($password))
		$errors[] = '密碼存在非法字符!';

  elseif($password != $passwordconfirm)
		$errors[] = '確認密碼與原密碼不相同!';

  if(strlen($email) == 0)
		$errors[] = '請輸入Email地址!';
  elseif(!isEmail($email))
		$errors[] = 'Email地址不規範!';

  $registered = $DB->query_first("SELECT userid FROM " . TABLE_PREFIX . "users WHERE username = '$username'");
  if(isset($registered))
  {
    Errmsg('用戶名已存在, 請重新輸入!');
  }
  
if($DB->query_first("SELECT email FROM " . TABLE_PREFIX . "users WHERE email = '$email' "))
{
	Errmsg('Email地址已被使用, 請重新輸入!');
}
  
  
  if(!isset($errors))
  {
    $DB->query("INSERT INTO " . TABLE_PREFIX . "users (usergroupid, username, password, email, activated, joindate, userfullname, usercompany, useradd, userpostcode, usertel, userfax, useronline, userwebsite)
                VALUES ('$usergroupid', '$username', '".md5($password)."', '$email', 1, '".time()."', '$userfullname', '$usercompany', '$useradd', '$userpostcode', '$usertel', '$userfax', '$useronline', '$userwebsite')");

    PrintRedirect('users.php?action=displayusers', 1);
  }
  else
  {
    PrintErrors($errors, '添加用戶錯誤');
    $action = 'displayuserform';
  }
}



// ################################ UPDATE USER ################################

if($action == 'updateuser')
{
  $userid          = $_POST['userid'];
  $usergroupid     = $_POST['usergroupid'];
  $username        = trim($_POST['nameofuser']);
  $password        = trim($_POST['password']);
  $passwordconfirm = trim($_POST['passwordconfirm']);
  $email           = trim($_POST['email']);
  $banned          = iif($_POST['banned'] == 'on', 1, 0);
  $activated       = iif($_POST['activated'] == 'on', 1, 0);
  $userfullname        = trim($_POST['userfullname']);
  $usercompany        = trim($_POST['usercompany']);
  $useradd        = trim($_POST['useradd']);
  $userpostcode        = trim($_POST['userpostcode']);
  $usertel        = trim($_POST['usertel']);
  $userfax        = trim($_POST['userfax']);
  $useronline        = trim($_POST['useronline']);
  $userwebsite        = trim($_POST['userwebsite']);
  
  // error checking

  if(strlen($username) == 0)
		$errors[] = '請輸入用戶名!';
  elseif(!isName($username))
		$errors[] = '用戶名存在非法字符!';

  if(strlen($password) OR strlen($passwordconfirm))
  {
	if(!isPass($password))
		$errors[] = '密碼存在非法字符!';

    elseif(strcmp($password, $passwordconfirm))  // return 0 if it's a match
    {
      $errors[] = '確認密碼與原密碼不相同!';
    }
  }
  
  if(strlen($email) == 0)
		$errors[] = '請輸入Email地址!';
  elseif(!isEmail($email))
		$errors[] = 'Email地址不規範!';

  if($_POST['oldname'] != $username)
  {
	  $registered = $DB->query_first("SELECT userid FROM " . TABLE_PREFIX . "users WHERE username = '$username'");
	  if(isset($registered))
	  {
		Errmsg('用戶名已存在, 請重新輸入!');
	  }
  }
  
  if($DB->query_first("SELECT email FROM " . TABLE_PREFIX . "users WHERE email = '$email' and  userid != '$userid'"))
    {
		Errmsg('Email地址已被使用, 請重新輸入!');
    }
  
  if(!isset($errors))
  {
    if($_POST['oldname'] == $userinfo['username'])
	{ 
	$DB->query("UPDATE " . TABLE_PREFIX . "users SET username    = '$username',
                                                     email       = '$email',
                                                     userfullname       = '$userfullname',
                                                     usercompany       = '$usercompany',
                                                     useradd       = '$useradd',
                                                     userpostcode       = '$userpostcode',
                                                     usertel       = '$usertel',
                                                     userfax       = '$userfax',
                                                     useronline       = '$useronline',
                                                     userwebsite       = '$userwebsite'												 
                                               WHERE userid      = '$userid'");
	}
    else
	{ 
	$DB->query("UPDATE " . TABLE_PREFIX . "users SET usergroupid = '$usergroupid',
                                                     username    = '$username',
                                                     email       = '$email',
                                                     banned      = '$banned',
													 activated   = '$activated',
                                                     userfullname       = '$userfullname',
                                                     usercompany       = '$usercompany',
                                                     useradd       = '$useradd',
                                                     userpostcode       = '$userpostcode',
                                                     usertel       = '$usertel',
                                                     userfax       = '$userfax',
                                                     useronline       = '$useronline',
                                                     userwebsite       = '$userwebsite'												 
                                               WHERE userid      = '$userid'");
	}							   

    // change password?
    if(strlen($password) > 0)
    {
      $DB->query("UPDATE " . TABLE_PREFIX . "users SET password = '" . md5($password) . "' WHERE userid = '$userid'");
    }
	
    if($_POST['selfactivated'] == 0 and $activated ==1)
    {
      $DB->query("UPDATE " . TABLE_PREFIX . "users SET validationkey = '' WHERE userid = '$userid'");
    }

   PrintRedirect('users.php?action=displayusers', 1);
  }
  else
  {
    PrintErrors($errors, '編輯用戶錯誤');
    $action = 'displayuserform';
  }
}



// ############################### DELETE USERS ################################

if($action == 'deleteusers')
{
  $deleteuserids = $_POST['deleteuserids'];
  $errors        = array();

    for($i = 0; $i < count($deleteuserids); $i++)
    {
      // Can't delete your own user account
      if($deleteuserids[$i] != $userinfo['userid'])
      {
      	$DB->query("DELETE FROM " . TABLE_PREFIX . "users WHERE userid = '" . $deleteuserids[$i] . "'");
      }
      else 
      {
      	$errors[] = "呵呵, 您無法刪除自己!";
      }
    }
    
    if(count($errors) > 0)
    {
    	PrintErrors($errors, '刪除用戶錯誤');
    	PrintRedirect('users.php?action=displayusers', 5);
    }
    else 
    {
      // redirect
      PrintRedirect('users.php?action=displayusers', 1);
    }

}



// ############################ DISPLAY USER FORUM #############################

if($action == 'displayuserform')
{
  $userid = isset($_GET['userid']) ? $_GET['userid'] : (isset($_POST['userid']) ? $_POST['userid'] : 0);
  
  $getsettings = $DB->query("SELECT title, value FROM " . TABLE_PREFIX . "modulesettings WHERE moduleid = '12'");
  while($setting = $DB->fetch_array($getsettings))
  {
			$settings[$setting['title']] = $setting['value'];
  }
	
  if(isset($errors))
  {
    // new user with errors, redisplaying the form
    $user = array('userid'       => $_POST['userid'],
                  'usergroupid'  => $_POST['usergroupid'],
                  'username'     => $_POST['nameofuser'],
                  'email'        => $_POST['email'],
                  'banned'       => $_POST['banned'],
                  'activated'    => $_POST['activated'],
                  'userfullname'    => $_POST['userfullname'],
                  'usercompany'    => $_POST['usercompany'],
                  'useradd'    => $_POST['useradd'],
                  'userpostcode'    => $_POST['userpostcode'],
                  'usertel'    => $_POST['usertel'],
                  'userfax'    => $_POST['userfax'],
                  'useronline'    => $_POST['useronline'],
                  'userwebsite'    => $_POST['userwebsite'] );
  }
  else if($userid)
  {
    // edit user
    $user = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "users WHERE userid = '$userid'");
  }
  else
  {
    // new user
    $user = array('userid'       => 0,
                  'usergroupid'  => 3,  // Registered Users (lets leave it as the default)
                  'username'     => '',
                  'email'        => '',
                  'banned'       => '0',
                  'activated'       => '1');
  }

  if($userid)
  {
    PrintSection('編輯用戶: ' . $user['username']);
  }
  else
  {
    PrintSection('添加用戶');
	$message_info = ' <font class=oh_red>*</font> ';
  }

  // get usergroups
  $getusergroups = $DB->query("SELECT usergroupid, name FROM " . TABLE_PREFIX . "usergroups ORDER BY usergroupid");

  // a few variable names here are a bit strange such as nameofuser
  // this is so that browsers won't store saved information when viewing user details!
  echo '<form method="post" action="./users.php">
        <input type="hidden" name="action" value="' . iif($userid, 'updateuser', 'insertuser') . '" />
        <input type="hidden" name="userid" value="' . $user['userid'] . '" />
        <input type="hidden" name="selfactivated" value="' . $user['activated'] . '" />
        <input type="hidden" name="oldname" value="' . $user['username'] . '" />
		

        <table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow2" width="40%">所屬用戶群組:</td>
          <td class="tdrow3"><select name="usergroupid" ' . iif($user['username'] == $userinfo['username'] AND $userid, 'disabled') .'>';

  while($usergroup = $DB->fetch_array($getusergroups))
  {
    echo '<option value="' . $usergroup['usergroupid'] . '" ' . iif($user['usergroupid'] == $usergroup['usergroupid'], 'SELECTED', '') . '>' . $usergroup['name'] . '</option>';
  }

  echo '  </select>
          </td>
        </tr>
        <tr>
          <td class="tdrow2" width="40%">用戶名'.$message_info.':</td>
          <td class="tdrow3"><input type="text" name="nameofuser" value="'.CleanFormValue($user['username']).'" size="40" /></td>
        </tr>
        <tr>
          <td class="tdrow2">密碼'.$message_info.':</td>
          <td class="tdrow3"><input type="password" name="password" size="40" /></td>
        </tr>
        <tr>
          <td class="tdrow2">確認密碼'.$message_info.':</td>
          <td class="tdrow3"><input type="password" name="passwordconfirm" size="40" /></td>
        </tr>
        <tr>
          <td class="tdrow2">Email地址'.$message_info.':</td>
          <td class="tdrow3"><input type="text" name="email" value="'.CleanFormValue($user['email']).'" size="40" /></td>
        </tr>';
	if($settings['顯示姓名']){
	echo '
        <tr>
          <td class="tdrow2">姓名:</td>
          <td class="tdrow3"><input type="text" name="userfullname" value="'.CleanFormValue($user['userfullname']).'" size="40" /></td>
        </tr>';
	}
		
	if($settings['顯示單位']){
	echo '
        <tr>
          <td class="tdrow2">所屬單位:</td>
          <td class="tdrow3"><input type="text" name="usercompany" value="'.CleanFormValue($user['usercompany']).'" size="40" /></td>
        </tr>';
	}

	if($settings['顯示地址']){
	echo '
        <tr>
          <td class="tdrow2">通訊地址:</td>
          <td class="tdrow3"><input type="text" name="useradd" value="'.CleanFormValue($user['useradd']).'" size="40" /></td>
        </tr>';
	}

	if($settings['顯示郵編']){
	echo '
        <tr>
          <td class="tdrow2">郵編:</td>
          <td class="tdrow3"><input type="text" name="userpostcode" value="'.CleanFormValue($user['userpostcode']).'" size="40" /></td>
        </tr>';
	}
	if($settings['顯示電話']){
	echo '
        <tr>
          <td class="tdrow2">電話:</td>
          <td class="tdrow3"><input type="text" name="usertel" value="'.CleanFormValue($user['usertel']).'" size="40" /></td>
        </tr>';
	}
	if($settings['顯示傳真']){
	echo '
        <tr>
          <td class="tdrow2">傳真:</td>
          <td class="tdrow3"><input type="text" name="userfax" value="'.CleanFormValue($user['userfax']).'" size="40" /></td>
        </tr>';
	}
	if($settings['顯示在線聯繫']){
	echo '
        <tr>
          <td class="tdrow2">在線聯繫:</td>
          <td class="tdrow3"><input type="text" name="useronline" value="'.CleanFormValue($user['useronline']).'" size="40" /></td>
        </tr>';
	}
	if($settings['顯示網址']){
	echo '
        <tr>
          <td class="tdrow2">網址:</td>
          <td class="tdrow3"><input type="text" name="userwebsite" value="'.CleanFormValue($user['userwebsite']).'" size="40" /></td>
        </tr>';
	}


	if($userid){
	echo '
        <tr>
          <td class="tdrow2">是否激活?</td>
          <td class="tdrow3"><input type="checkbox" ' . iif($user['username'] == $userinfo['username'], 'disabled') .' name="activated" ' . iif($user['activated'] == 1, 'checked="checked"', '') .' /></td>
        </tr>
        <tr>
          <td class="tdrow2">是否鎖定?</td>
          <td class="tdrow3"><input type="checkbox" ' . iif($user['username'] == $userinfo['username'], 'disabled') .' name="banned" ' . iif($user['banned'] == 1, 'checked="checked"', '') .' /></td>
        </tr>';}
		
	echo '
        <tr>
          <td class="tdrow1" bgcolor="#FCFCFC" colspan="2" align="center">
           <input type="submit" value="' . iif($userid, '保存更新', '提交保存') . '" />
          </td>
        </tr>
        </table>

        </form>';

  EndSection();
}



// ############################### DISPLAY USERS ###############################

if($action == 'displayusers')
{
	if(isset($_GET['start']))
	  $start = $_GET['start'];
	else
	  $start = 0;

	$searchname = isset($_POST['searchname']) ? $_POST['searchname'] : (isset($_GET['searchname']) ? urldecode($_GET['searchname']) : '');
	$searchemail = isset($_POST['searchemail']) ? $_POST['searchemail'] : (isset($_GET['searchemail']) ? urldecode($_GET['searchemail']) : '');

  $letter = isset($_GET['letter']) ? $_GET['letter'] : NULL;

  PrintSection('快速查找用戶');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1" align="center">
            <a href="users.php?action=displayusers">全部用戶</a>&nbsp;';

  for($alphabet = 'a'; $alphabet != 'aa'; $alphabet++)
  {
    echo '<a href="users.php?action=displayusers&letter=' . $alphabet . '">' . strtoupper($alphabet) . '</a> &nbsp;';
  }

  echo '  <a href="users.php?action=displayusers&letter=Banned">被鎖定</a>&nbsp;
          <a href="users.php?action=displayusers&letter=Validating">未激活</a>&nbsp;
		  <a href="users.php?action=displayusers&letter=Neverlogin">未登陸</a>&nbsp;
		  <a href="users.php?action=displayusers&letter=Other">中文名</a></td>
        </tr>
        </table>';
  EndSection();

  PrintSection('搜索用戶');
  echo '<form method="post" action="./users.php?action=displayusers&letter=Search" name="searchusers">
  <table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1" align="center">用戶名:&nbsp;
		    <input type="text" name="searchname" size="18">&nbsp;&nbsp;Email地址:&nbsp;<input type="text" name="searchemail" size="18">&nbsp;&nbsp;<input type="submit" value=" 搜索用戶 " /></td>
        </tr>
        </table></form>';
  EndSection();

  if(isset($letter) AND trim($letter) != '')
  {

    if($letter == 'Other')
    {
      $getusers = $DB->query("SELECT userid, usergroupid, username, email, banned, activated, joindate, lastactivity FROM " . TABLE_PREFIX . "users WHERE username NOT REGEXP(\"^[a-zA-Z]\") ORDER BY userid DESC LIMIT $start,10");
	  $title = '使用中文用戶名的用戶';
 	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "users WHERE username NOT REGEXP(\"^[a-zA-Z]\")");
   }
    else if($letter == 'Banned')
    {
      $getusers = $DB->query("SELECT userid, usergroupid, username, email, banned, activated, joindate, lastactivity FROM " . TABLE_PREFIX . "users WHERE banned = 1 ORDER BY userid DESC LIMIT $start,10");
	  $title = '被鎖定的用戶';
 	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "users WHERE banned = 1");
    }
    else if($letter == 'Validating')
    {
      $getusers = $DB->query("SELECT userid, usergroupid, username, email, banned, activated, joindate, lastactivity FROM " . TABLE_PREFIX . "users WHERE activated = 0 ORDER BY userid DESC LIMIT $start,10");
	  $title = '尚未激活的用戶';
  	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "users WHERE activated = 0");
   }
    else if($letter == 'Search')
    {
	  $getusers = $DB->query("SELECT userid, usergroupid, username, email, banned, activated, joindate, lastactivity FROM " . TABLE_PREFIX . "users WHERE LOWER(username) LIKE '%".trim($searchname)."%' AND LOWER(email) LIKE '%".trim($searchemail)."%' ORDER BY userid DESC LIMIT $start,10");
	  $title = '搜索到的用戶';
  	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "users WHERE LOWER(username) LIKE '%".trim($searchname)."%' AND LOWER(email) LIKE '%".trim($searchemail)."%'");
    }
    else if(trim($letter) == 'Neverlogin')
    {
      $getusers = $DB->query("SELECT userid, usergroupid, username, email, banned, activated, joindate, lastactivity FROM " . TABLE_PREFIX . "users WHERE lastactivity = 0 ORDER BY userid DESC LIMIT $start,10");
	  $title = '從未登陸的用戶';
  	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "users WHERE lastactivity = 0");
    }
	
    else
    {
      $getusers = $DB->query("SELECT userid, usergroupid, username, email, banned, activated, joindate, lastactivity FROM " . TABLE_PREFIX . "users WHERE LOWER(username) LIKE '".$letter."%' ORDER BY userid DESC LIMIT $start,10");
      $title = strtoupper($letter) . ' 字母開頭的用戶';
  	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "users WHERE LOWER(username) LIKE '".$letter."%'");
    }
    
  }
  else
  {
	$title = '全部用戶列表';
    $getusers = $DB->query("SELECT userid, usergroupid, username, email, banned, activated, joindate, lastactivity FROM " . TABLE_PREFIX . "users ORDER BY userid DESC LIMIT $start,10");
  	$maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "users");
  }

  
  echo '&nbsp;&nbsp;&nbsp;&nbsp;<a href="users.php?action=displayuserform"><img src="'.$stylepath.'images/open.gif" align="absmiddle"> <font class=ohblue><u>添加用戶</u></font></a>';

  PrintSection($title);

  echo '<form method="post" action="./users.php" name="deleteusers">
        <input type="hidden" name="action" value="deleteusers" />';

  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1">用戶名</td>
          <td class="tdrow1">群組ID</td>
          <td class="tdrow1">Email地址</td>
          <td class="tdrow1">狀態</td>
          <td class="tdrow1">註冊日期</td>
          <td class="tdrow1">最後登陸</td>
          <td class="tdrow1" width="75"><input type="checkbox" checkall="group" onclick="javascript: return select_deselectAll (\'deleteusers\', this, \'group\');"> 刪除</td>
        </tr>';

  while($user = $DB->fetch_array($getusers))
  {
    echo '<tr>
            <td class="tdrow2"><a href="users.php?action=displayuserform&userid='.$user['userid'].'">' . $user['username']. '</a></td>
            <td class="tdrow3">' . $user['usergroupid'] . '</td>
			<td class="tdrow2">' . $user['email'] . '</td>
            <td class="tdrow2">';
    
    if($user['banned'] == "1")
    {
    	echo "<div style=\"color:red\"><b>被鎖定</b></div>";
    }
    else if($user['activated'] == "0")
    {
    	echo "<div style=\"color:#ff9900\"><b>未激活</b></div>";
    }
    else 
    {
    	echo "<div style=\"color:green\">已激活</div>";
    }

    echo '  </td>
            <td class="tdrow3">' . @gmdate("Y-m-d", $user['joindate']) . '</td>
			<td class="tdrow3">';
			
    if($user['lastactivity'] == 0)
    {
    	echo "<div style=\"color:#FF9900\">從未登陸</div>";
    }
    else 
    {
    	echo @gmdate("Y-m-d", $user['lastactivity']);
    }
        
		echo '</td>
		  <td class="tdrow2"><input type="checkbox" name="deleteuserids[]" value="' . $user['userid'] . '" checkme="group" /></td>
          </tr>';
  }

	$limit = 10;
	$sectionimagesnum = $maxrows['value'];
	$rows = $maxrows['value'] - $start;
	$page_num = ceil($sectionimagesnum / $limit);
	$page_group = floor($start/$limit/8)*8+1;
	$now_page_num = $start/$limit+1;

    $searchname = urlencode ($searchname);
    $searchemail = urlencode ($searchemail);

  if(($start > 0) || ($rows > $limit))
  {

		echo '<tr><td class="tdrow3" colspan="7" align="center" height="48" valign="middle"><table width="100%" cellpadding="0" cellspacing="0" border="0">
		  <tr>';

		if($start > 0)
		{
		  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><a href="users.php?action=displayusers&searchname='.$searchname.'&searchemail='.$searchemail.'&letter=' . $letter.'&start='.($start - $limit).'">&lsaquo;&lsaquo; 上一頁</a></td>';
		}else{
		  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
		}

		if($page_num - $now_page_num < 10){
			$start_page = $page_num - 9;
			if($start_page<1){
				$start_page = 1;
			}
			$end_page = $page_num + 1;
		}else{
			$start_page = $page_group;
			$end_page = $start_page + 8;
		}

		if($start_page > 1){
			$direct_bar = '<a href="users.php?action=displayusers&searchname='.$searchname.'&searchemail='.$searchemail.'&letter=' . $letter.'&start=0">1</a><a href="users.php?action=displayusers&searchname='.$searchname.'&searchemail='.$searchemail.'&letter=' . $letter.'&start='.($start_page-2)*$limit.'">&lsaquo;&lsaquo;...</a>';
		}

		for ($p=$start_page; $p < $end_page; $p++ ) 
		{	
			if (($start/$limit+1) == $p){
				$direct_bar .= '<STRONG>'.$p.'</STRONG>';
			}else{
				$direct_bar .= '<a href="users.php?action=displayusers&searchname='.$searchname.'&searchemail='.$searchemail.'&letter=' . $letter.'&start='.($p-1)*$limit.'">'.$p.'</a>';
			}
			if($p >= $page_num){
				break;
			}
		}

		if($page_num - $now_page_num >= 10){
			$direct_bar .= '<a href="users.php?action=displayusers&searchname='.$searchname.'&searchemail='.$searchemail.'&letter=' . $letter.'&start='.($page_group + 7)*$limit.'">...&rsaquo;&rsaquo;</a><a href="users.php?action=displayusers&searchname='.$searchname.'&searchemail='.$searchemail.'&letter=' . $letter.'&start='.($page_num-1)*$limit.'">'.$page_num.'</a>';
		}

		echo '<td width="80%" style="text-align:center; vertical-align:middle;" class="pages_nav">'.$direct_bar.'</td>';

		if($rows > $limit)
		{
		  $start += $limit;
		  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><div align="right"><a href="users.php?action=displayusers&searchname='.$searchname.'&searchemail='.$searchemail.'&letter=' . $letter.'&start='.$start.'">下一頁 &rsaquo;&rsaquo;</a></div></td>';
		}else{
		  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
		}

		echo '</tr></table>';

   }


	echo '<tr><td class="tdrow1" colspan="7" align="center"><input type="submit" onclick="return confirm(\'確定刪除所選用戶嗎?\');" value=" 刪除用戶 " /></td></tr></table></form>';

	EndSection();
}


// ############################### PRINT FOOTER ################################

PrintFooter();

?>

