<?php
// +---------------------------------------------+
// |     Copyright  2008 - 2018 weenCompany      |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

if(!defined('IN_WEENCOMPANY'))
die('File not found!');


// ################################ SEND EMAIL #################################

function m6_SendEmail()
{
  global $DB, $userinfo, $sdlanguage, $mainsettings, $rootpath, $m6_language;

  // Strip \r\n to prevent injection attacks
  $_POST['m6_useremail'] = preg_replace("/\r/", "", $_POST['m6_useremail']);
  $_POST['m6_useremail'] = preg_replace("/\n/", "", $_POST['m6_useremail']);

  $_POST['m6_fullname'] = preg_replace("/\r/", "", $_POST['m6_fullname']);
  $_POST['m6_fullname'] = preg_replace("/\n/", "", $_POST['m6_fullname']);

  if(empty($_POST['m6_fullname']) OR empty($_POST['m6_useremail']) OR empty($_POST['m6_subject']) OR empty($_POST['m6_message']))
  {
    $errors[] = $m6_language['empty_fields'];
  }

  if(!isEmail($_POST['m6_useremail']))
  {
    $errors[] = $m6_language['invalid_email'];
  }

  // Check Visual Verify Code if set
  $vvc = $DB->query_first("SELECT value FROM " . TABLE_PREFIX . "modulesettings WHERE moduleid = 6 AND title = '֤'");

  if($vvc[0] == 1)
  {
    $vvcid   = $_POST['m6_vvcid'];
    $code  = $_POST['m6_verifycode'];

    if(!ValidVisualVerifyCode($vvcid, $code))
    {
      $errors[] = $sdlanguage['incorrect_vvc_code'];
    }else{
		DeleteVisualVerifyCode($vvcid);
	}
  }


  if(!isset($errors))
  {
    // get emails
    $settings = $DB->query_first("SELECT value FROM " . TABLE_PREFIX . "modulesettings WHERE moduleid = 6 AND title = 'ռ'");
    $email = $settings['value'];

    $getemails = str_replace(',', ' ', $email);      // get rid of commas
    $getemails = preg_replace("/[[:space:]]+/", " ", $getemails);   // get rid of extra spaces
    $getemails = trim($getemails);         // then trim
    $emails  = explode(" ", $getemails);

    $fullname  = unhtmlspecialchars($_POST['m6_fullname']);
    $useremail = unhtmlspecialchars($_POST['m6_useremail']);

	require_once($rootpath . 'includes/mail/class.phpmailer.php');
	$mail = new PHPMailer();

	if($mainsettings['email_use_smtp'] == '1')
		$mail->IsSMTP();
	else
		$mail->IsMail();

	$mail->Host = $mainsettings['email_smtp_host'];
	$mail->Port = $mainsettings['email_smtp_port'];

	if( $mainsettings['email_smtp_require_auth'] == "1" ) {
		$mail->SMTPAuth = true;
		$mail->Username = $mainsettings['email_smtp_user'];
		$mail->Password = $mainsettings['email_smtp_pass'];
	}

	$mail->From      =  $fullname;
	$mail->FromName      =  $useremail;
	$mail->AddReplyTo($useremail,$fullname);   
	$mail->Sender      =  $mainsettings['email_smtp_from'];

	for($i = 0; $i < count($emails); $i++)
	{
		$mail->AddAddress($emails[$i]);
	}

	$mail->Subject   = unhtmlspecialchars($_POST['m6_subject']);
	$mail->Body      = nl2br(unhtmlspecialchars($_POST['m6_message']));

	if($mail->Send())
	{
		echo $m6_language['email_sent'];
	}
	else
	{
		echo $m6_language['email_not_sent'];
	}

  }
  else
  {
    foreach($errors as $key=>$value)
    {
      echo $value . '<br /><br />';
    }

    m6_DisplayEmailForm(1);  // 1 = errors exist
  }

}



// ############################ DISPLAY EMAIL FORM #############################

function m6_DisplayEmailForm($errors = 0)
{
  global $DB, $categoryid, $userinfo, $inputsize, $sdlanguage, $m6_language;

  $vvc = $DB->query_first("SELECT value FROM " . TABLE_PREFIX . "modulesettings WHERE moduleid = 6 AND title = '֤'");

  if($errors)
  {
    $email = array('fullname'  => $_POST['m6_fullname'],
    'useremail' => $_POST['m6_useremail'],
    'subject'   => $_POST['m6_subject'],
    'message'   => $_POST['m6_message']);
  }
  else
  {
    $email = array('fullname'  => iif($userinfo['loggedin'], $userinfo['username'], ''),
    'useremail' => iif($userinfo['loggedin'], $userinfo['email'], ''),
    'subject'   => '',
    'message'   => '');
  }

  echo '<form action="' . RewriteLink('index.php?categoryid=' . $categoryid) . '" method="post">

  <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
  <tr>
    <td style="padding-bottom: 5px;" valign="top" width="100">' . $m6_language['full_name'] . ' <font color=red>*</font></td>
    <td style="padding-bottom: 5px;"><input ' . CheckForEmptyField($email['fullname'], $errors) . ' type="text" name="m6_fullname" value="' . $email['fullname'] . '" size="' . $inputsize . '" /></td>
  </tr>
  <tr>
    <td style="padding-bottom: 5px;" valign="top" width="100">' . $m6_language['your_email'] . ' <font color=red>*</font></td>
    <td style="padding-bottom: 5px;"><input  ' . CheckForEmptyField($email['useremail'], $errors) . ' type="text" name="m6_useremail" value="' . $email['useremail'] . '" size="' . $inputsize . '" /></td>
  </tr>
  <tr>
    <td style="padding-bottom: 5px;" valign="top" width="100">' . $m6_language['subject'] . ' <font color=red>*</font></td>
    <td style="padding-bottom: 5px;"><input ' . CheckForEmptyField($email['subject'], $errors) . ' type="text" name="m6_subject" value="' . $email['subject'] . '" size="' . $inputsize . '" /></td>
  </tr>
  <tr>
    <td style="padding-bottom: 5px;" valign="top" width="100">' . $m6_language['message'] . ' <font color=red>*</font></td>
    <td style="padding-bottom: 5px;"><textarea ' . CheckForEmptyField($email['message'], $errors) . ' name="m6_message" rows="10" cols="' . $inputsize . '">' . $email['message'] . '</textarea></td>
  </tr>';

  if($vvc[0])
  {
    $vvcid = CreateVisualVerifyCode();

    echo '<tr>
    <td style="padding-bottom: 5px;" valign="top" width="100"></td>
    <td style="padding-bottom: 5px;"><input type="hidden" name="m6_vvcid" value="' . $vvcid . '"/>
        <img src="includes/vvc.php?vvcid=' . $vvcid . '"/></td>
    </tr>
    <tr>
    <td style="padding-bottom: 5px;" valign="top" colspan="2">' . $sdlanguage['enter_verify_code'] . ' <font color=red>*</font></td>
    </tr>
    <tr>
    <td style="padding-bottom: 5px;" valign="top" width="100"></td>
        <td style="padding-bottom: 5px;"><input type="text" size="'.$inputsize.'" name="m6_verifycode"/></td>
    </tr>';
  }

  echo '<tr>
    <td>&nbsp;</td>
    <td><input type="hidden" name="m6_action" value="sendemail"/><input type="submit" name="m6_Submit" value="' . strip_tags($m6_language['send_message']) . '" /> <input type="reset" value="' . strip_tags($m6_language['reset']) . '" /></td>
  </tr>
  </table>

  </form>';
}


$m6_language = GetLanguage(6);

$m6_action = isset($_POST['m6_action']) ? $_POST['m6_action'] : 'displayemailform';

if(@in_array(6, $userinfo['modulesubmitids']))
{
  if($m6_action == 'sendemail')
  {
    m6_SendEmail();
  }
  else
  {
    m6_DisplayEmailForm();
  }
}
else
{
  echo $m6_language['no_post_access'];
}

unset($m6_language, $m6_action);
?>