<?php
define('MOD_ACCESS', true);
define('IN_ADMIN', true);
define('IN_WEENCOMPANY', true);

$rootpath = "./../";

include($rootpath . 'includes/core.php');

PrintHeader('评论管理');

function UpdateComment()
{
  global $DB;

  $commentid  = $_POST['commentid'];
  $comments   = $_POST['comment'];
  $username   = $_POST['username'];

  if($_POST['deletecomment'] == 1)
  {
    $DB->query("DELETE FROM " . TABLE_PREFIX . "comments WHERE commentid = '$commentid'");
  }
  else
  {
    $DB->query("UPDATE " . TABLE_PREFIX . "comments SET comment  = '$comments',
                                                        username = '$username'
                                                                                                    WHERE commentid = '$commentid'");
  }

  PrintRedirect('comments.php', 1);
}

function DeleteComments()
{
  global $DB;

  // get post vars
  $commentids = $_POST['commentids'];

  for($i = 0; $i < count($commentids); $i++)
  {
    $DB->query("DELETE FROM " . TABLE_PREFIX . "comments WHERE commentid = '".$commentids[$i]."'");
  }

  PrintRedirect('comments.php', 1);
}

function TranslateObjectID($moduleid, $objectid)
{
  global $DB;
  $modulepath = $DB->query_first("SELECT modulepath FROM " . TABLE_PREFIX . "modules WHERE moduleid = $moduleid");
  $modulename = substr($modulepath['modulepath'], strpos($modulepath['modulepath'], '_') + 1, strpos($modulepath['modulepath'], '/') - strpos($modulepath['modulepath'], '_') - 1);
  
  if ($modulename == "news")
  {
          $title = $DB->query_first("SELECT title FROM " . TABLE_PREFIX . "m". $moduleid."_news WHERE articleid = $objectid");
          $title = $title[0];
  }
  elseif ($modulename == "downloadmanager")
  {
          $title = $DB->query_first("SELECT title FROM " . TABLE_PREFIX . "m". $moduleid."_files WHERE fileid = $objectid");
          $title = $title[0];
  }
  elseif ($modulename == "products")
  {
          $title = $DB->query_first("SELECT title FROM " . TABLE_PREFIX . "m". $moduleid."_products WHERE imageid = $objectid");
          $title = $title[0];
  }
  elseif ($modulename == "advert")
  {
          $title = $DB->query_first("SELECT title FROM " . TABLE_PREFIX . "m". $moduleid."_advert WHERE ad_id = $objectid");
          $title = $title[0];
  }
  else{
          $title = '未知 (ID ' . $objectid . ')';
  }
  
  
  return $title;
}

function DisplayComment($commentid)
{
  global $DB, $rootpath, $userinfo;

  $comment = $DB->query_first("SELECT *, m.name as modulename FROM " . TABLE_PREFIX . "comments c
                                                           LEFT JOIN " . TABLE_PREFIX . "modules m
                                                           ON m.moduleid = c.moduleid
                               WHERE commentid = '$commentid'");

  PrintSection('编辑评论');


  echo '<form method="post" action="comments.php">
        <input type="hidden" name="commentid"  value="'.$commentid.'" />
                <input type="hidden" name="action" value="updatecomment" />

        <table width="100%" border="0" cellpadding="5" cellspacing="0">
                <tr>
            <td class="tdrow2" width="15%"><b>删除评论:</b></td>
            <td class="tdrow3" width="75%" valign="top">
              <input type="checkbox" name="deletecomment"  value="1"> 是否删除此条评论?
            </td>
        </tr>
                <tr>
          <td class="tdrow2" width="15%"><b>所属模块:</b></td>
          <td class="tdrow3" width="75%" valign="top">'.$comment['modulename'].'
          </td>
        </tr>
                <tr>
          <td class="tdrow2" width="15%"><b>所属主题:</b></td>
          <td class="tdrow3" width="75%" valign="top">'.TranslateObjectID($comment['moduleid'], $comment['objectid']).'
          </td>
        </tr>
                <tr>
          <td class="tdrow2" width="15%"><b>发表人:</b></td>
          <td class="tdrow3" width="75%" valign="top">
            <input type="text" name="username" value="'.CleanFormValue($comment['username']).'" />
          </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%" valign="top"><b>评论内容:</b></td>
          <td class="tdrow3" width="75%" valign="top">
            <textarea name="comment" cols="54" rows="5">'.$comment['comment'].'</textarea>
          </td>
        </tr>
        <tr>
          <td colspan="2" align="center" class="tdrow1">
            <input type="submit" value=" 保存更新 " />
                  </td>
        </tr>
        </table>
        </form>';
  EndSection();

}

function DisplayModuleCounts()
{
  global $DB;

  $getcomments = $DB->query("SELECT m.moduleid, m.name AS modulename, COUNT(*) As count FROM " . TABLE_PREFIX . "comments c
                                   LEFT JOIN " . TABLE_PREFIX . "modules m
                                                           ON m.moduleid = c.moduleid
                                                           GROUP BY m.moduleid
                                                           ORDER BY count DESC");

  PrintSection('模块评论统计');

  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1">模块名称</td>
          <td class="tdrow1">评论数量</td>
        </tr>';

  while($comment = $DB->fetch_array($getcomments))
  {
    echo '<tr>
            <td class="tdrow2"><a href="comments.php?action=displaycomments&moduleid=' . $comment['moduleid']. '">' .$comment['modulename'].'</a></td>
            <td class="tdrow3">'.$comment['count'].'</td>
          </tr>';
  }

  echo '</table>';

  EndSection();

}


// ######################### Instructions ##########################

function PrintInstructions()
{
  PrintSection('关于评论管理');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow2">
          weenCompany闻名企业网站系统有些模块(包括其复制模块)允许用户发表评论, 此"评论管理"工具可对这些评论进行集中管理.
          </td>
        </tr>
        </table>';
  EndSection();
}

function DisplayComments($moduleid, $start)
{
  global $DB;

  if($moduleid == -1)
  {
    // Latest Comments
        $title = '全部评论列表';
        $getcomments = $DB->query("SELECT c.*, m.name AS modulename FROM " . TABLE_PREFIX . "comments c
                                     LEFT JOIN " . TABLE_PREFIX . "modules m ON m.moduleid = c.moduleid  ORDER BY date DESC LIMIT $start, 10");
        $maxrows = $DB->query_first("SELECT  COUNT(*) AS value FROM " . TABLE_PREFIX . "comments");
  }
  else
  {
		$title = $DB->query_first("SELECT name FROM " . TABLE_PREFIX . "modules WHERE moduleid = $moduleid");

		$title = $title[0] . '_评论列表';

		$getcomments = $DB->query("SELECT * FROM " . TABLE_PREFIX . "comments WHERE moduleid = '$moduleid' ORDER BY date DESC LIMIT $start, 10");
         $maxrows = $DB->query_first("SELECT  COUNT(*) AS value FROM " . TABLE_PREFIX . "comments WHERE moduleid = '$moduleid'");
		 $addquery = 'action=displaycomments&moduleid='.$moduleid.'&';
 }

  PrintSection($title);

  echo '<form action="comments.php" method="POST"  name="deletecommentsform">
        <input type="hidden" name="action" value="deletecomments">

        <table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1">评论内容</td>';
  if($moduleid == -1)
    echo '<td class="tdrow1">所属模块</td>';

  echo   '<td class="tdrow1">所属主题</td>
          <td class="tdrow1">发表人</td>
          <td class="tdrow1">日期</td>
          <td class="tdrow1" width="150"><input type="checkbox" checkall="group" onclick="javascript: return select_deselectAll(\'deletecommentsform\', this, \'group\');">删除</td></tr>';

  while($comment = $DB->fetch_array($getcomments))
  {
    $comment['comment'] = ShortTitle($comment['comment'], 40);
	
    echo '<tr>
            <td class="tdrow2"><a href="comments.php?action=displaycomment&commentid=' . $comment['commentid']. '">' . $comment['comment'] . '</a></td>';

        if($moduleid == -1)
          echo '<td class="tdrow3">'.$comment['modulename'].'</td>';

        echo   '<td class="tdrow2">'.ShortTitle(TranslateObjectID($comment['moduleid'], $comment['objectid']), 40).'</td>
            <td class="tdrow3">'.$comment['username'].'</td>
                        <td class="tdrow2">'.DisplayDate($comment['date']).'</td>
            <td class="tdrow3"><input type="checkbox" name="commentids[]" value="'.$comment['commentid'].'" checkme="group"></td>
          </tr>';
  }


		$limit = 10;
		$sectionimagesnum = $maxrows['value'];
		$rows = $maxrows['value'] - $start;
		$page_num = ceil($sectionimagesnum / $limit);
		$page_group = floor($start/$limit/8)*8+1;
		$now_page_num = $start/$limit+1;

      if(($start > 0) || ($rows > $limit))
      {

			echo '<tr><td class="tdrow3" colspan="7" align="center" height="48" valign="middle"><table width="100%" cellpadding="0" cellspacing="0" border="0">
              <tr>';

			if($start > 0)
			{
			  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><a href="comments.php?'.$addquery.'start='.($start - $limit).'">&lsaquo;&lsaquo; 上一页</a></td>';
			}else{
			  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
			}


			if($page_num - $now_page_num < 10){
				$start_page = $page_num - 9;
				if($start_page<1){
					$start_page = 1;
				}
				$end_page = $page_num + 1;
			}else{
				$start_page = $page_group;
				$end_page = $start_page + 8;
			}

			if($start_page > 1){
				$direct_bar = '<a href="comments.php?'.$addquery.'start=0">1</a><a href="comments.php?'.$addquery.'start='.($start_page-2)*$limit.'">&lsaquo;&lsaquo;...</a>';
			}

			for ($p=$start_page; $p < $end_page; $p++ ) 
			{	
				if (($start/$limit+1) == $p){
					$direct_bar .= '<STRONG>'.$p.'</STRONG>';
				}else{
					$direct_bar .= '<a href="comments.php?'.$addquery.'start='.($p-1)*$limit.'">'.$p.'</a>';
				}
				if($p >= $page_num){
					break;
				}
			}

			if($page_num - $now_page_num >= 10){
				$direct_bar .= '<a href="comments.php?'.$addquery.'start='.($page_group + 7)*$limit.'">...&rsaquo;&rsaquo;</a><a href="comments.php?'.$addquery.'start='.($page_num-1)*$limit.'">'.$page_num.'</a>';
			}

			echo '<td width="80%" style="text-align:center; vertical-align:middle;" class="pages_nav">'.$direct_bar.'</td>';

			if($rows > $limit)
			{
			  $start += $limit;
			  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><div align="right"><a href="comments.php?'.$addquery.'start='.$start.'">下一页 &rsaquo;&rsaquo;</a></div></td>';
			}else{
			  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
			}

			echo '</tr></table>';

	   }


        echo '<tr><td class="tdrow1" colspan="7" align="center"><input type="submit" onclick="return confirm(\'确定删除所选评论吗?\');" value=" 删除评论 " /></td></tr></table></form>';

  EndSection();
}

// display the default page
function DisplayDefault($start)
{
  global $DB;
  global $moduleid;

  PrintInstructions();

  DisplayModuleCounts($start);

  DisplayComments(-1, $start);
}


$action    = isset($_POST['action'])        ? $_POST['action']   : (isset($_GET['action']) ? $_GET['action'] : '');
$commentid = is_numeric($_GET['commentid']) ? $_GET['commentid'] : 0;
$moduleid  = is_numeric($_GET['moduleid'])  ? $_GET['moduleid']  : 0;

// ############################# Select Function ############################
if(isset($_GET['start']))
  $start = $_GET['start'];
else
  $start = 0;

switch($action)
{
  case 'displaycomment':
    DisplayComment($commentid);
  break;

  case 'displaycomments':
    DisplayComments($moduleid, $start);
  break;

  case 'deletecomments':
    DeleteComments();
  break;

  case 'updatecomment':
    UpdateComment();
  break;

  default:
    DisplayDefault($start);
}

// ############################### PRINT FOOTER ################################

PrintFooter();
?>