<?php
// +---------------------------------------------+
// |     Copyright  2003 - 2005 weenCompany      |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

if(!defined('IN_WEENCOMPANY'))
  die('File not found!');



// ################################ TEMPLATE FORUM #################################

function TemplateForum($weenheader, $weenfooter)
{
  global $DB, $usersystem;

  $forumprefix = $usersystem['tblprefix'];
  $forumpath   = $usersystem['folderpath'];

  $weenheader = "</head><!--StartWeenCWSHeader-->\n" . $weenheader . "\n<!--EndWeenCWSHeader-->";
  $weenfooter = "<!--StartWeenCWSFooter-->\n" . $weenfooter . "\n<!--EndWeenCWSFooter--></body>";

  // get default style for phpBB2
  $getstyleid = $DB->query_first("SELECT config_value FROM ".$forumprefix."config WHERE config_name = 'default_style'");
  $styleid    = $getstyleid['config_value'];

  // get folder name for phpBB2 default styles
  $getstylefolder = $DB->query_first("SELECT template_name FROM ".$forumprefix."themes WHERE themes_id = '$styleid'");
  $stylefolder    = $getstylefolder['template_name'];

  // check if files are writable
  if( (!is_writable('../' . $forumpath . 'templates/' . $stylefolder . '/overall_header.tpl')) OR (!is_writable('../' . $forumpath . 'templates/' . $stylefolder . '/overall_footer.tpl')) )
  {
    return '<b>在對phpBB2論壇模板實行接口前, 需要將以下文件屬性設置為"766":</b>
          <br /><br />' . $forumpath . 'templates/' . $stylefolder . '/overall_header.tpl
          <br />' . $forumpath . 'templates/' . $stylefolder . '/overall_footer.tpl';
  }

  // open up overall_header.tpl and get contents
  $filename = '../' . $forumpath . 'templates/' . $stylefolder . '/overall_header.tpl';
  $fp = fopen($filename, "r");
  $forumheader = fread($fp, filesize($filename));
  fclose($fp);

  // check and erase previous weencompany header
  $forumheader = preg_replace("'<!--StartWeenCWSHeader-->(.*)<!--EndWeenCWSHeader-->'ms", "", $forumheader);

  // add weencompany header
  $newheader = preg_replace("'</head>'", $weenheader, $forumheader);
  $fp = fopen($filename, 'w');
  fwrite($fp, $newheader);
  fclose($fp);

  // open up overall_footer.tpl
  $filename = '../' . $forumpath . 'templates/' . $stylefolder . '/overall_footer.tpl';
  $fp = fopen($filename, "r");
  $forumfooter = fread($fp, filesize($filename));
  fclose($fp);

  // check and erase previous weencompany footer
  $forumfooter = preg_replace("'<!--StartWeenCWSFooter-->(.*)<!--EndWeenCWSFooter-->'ms", "", $forumfooter);

  // add weencompany template footer
  $newfooter = preg_replace("'</body>'", $weenfooter, $forumfooter);
  $fp = fopen($filename, 'w');
  fwrite($fp, $newfooter);
  fclose($fp);

  // override user stle
  $DB->query("UPDATE ".$forumprefix."config SET config_value = '1' WHERE config_name = 'override_user_style'");

}



// ############################ RESTORE FORUM TEMPLATE #############################

function RestoreForumTemplate()
{
  global $DB, $usersystem;

  $forumprefix = $usersystem['tblprefix'];
  $forumpath   = $usersystem['folderpath'];

  // get default style for phpBB2
  $getstyleid = $DB->query_first("SELECT config_value FROM ".$forumprefix."config WHERE config_name = 'default_style'");
  $styleid    = $getstyleid['config_value'];

  // get folder name for phpBB2 default styles
  $getstylefolder = $DB->query_first("SELECT template_name FROM ".$forumprefix."themes WHERE themes_id = '$styleid'");
  $stylefolder    = $getstylefolder['template_name'];

  // open up overall_header.tpl and get contents
  $filename = '../' . $forumpath . 'templates/' . $stylefolder . '/overall_header.tpl';
  $fp = fopen($filename, "r");
  $forumheader = fread($fp, filesize($filename));
  fclose($fp);

  // erase weencompany header
  $forumheader = preg_replace("'<!--StartWeenCWSHeader-->(.*)<!--EndWeenCWSHeader-->'ms", "", $forumheader);

  // restore forum header
  $fp = fopen($filename, 'w');
  fwrite($fp, $forumheader);
  fclose($fp);


  // open up overall_footer.tpl
  $filename = '../' . $forumpath . 'templates/' . $stylefolder . '/overall_footer.tpl';
  $fp = fopen($filename, "r");
  $forumfooter = fread($fp, filesize($filename));
  fclose($fp);

  // erase weencompany footer
  $forumfooter = preg_replace("'<!--StartWeenCWSFooter-->(.*)<!--EndWeenCWSFooter-->'ms", "", $forumfooter);

  // restore forum footer
  $fp = fopen($filename, 'w');
  fwrite($fp, $forumfooter);
  fclose($fp);

}



// ############################# GET FORUM SYSTEM ##############################

function GetForumSystem($forumfolderpath, $sddbname, $cookiedomain, $cookiepath)
{
  global $DB;

  if(is_file('../' . $forumfolderpath . 'config.php'))
  {
    include('../' . $forumfolderpath . 'config.php');

    // connect to forum db for cookie timeout variable, and to update the forums cookiedomain and path
    $DB->select_db($dbname);

    $cookietimeout = $DB->query_first("SELECT config_value FROM " . $table_prefix . "config WHERE config_name = 'session_length'");
    $cookieprefix  = $DB->query_first("SELECT config_value FROM " . $table_prefix . "config WHERE config_name = 'cookie_name'");

    $DB->query("UPDATE " . $table_prefix . "config SET config_value = '$cookiedomain' WHERE config_name = 'cookie_domain'");
    $DB->query("UPDATE " . $table_prefix . "config SET config_value = '$cookiepath'   WHERE config_name = 'cookie_path'");

    // switch back to weencompany db
    $DB->select_db($sddbname);

    $forumsystem = array('name'          => 'phpBB2',
                         'dbname'        => $dbname,
                         'tblprefix'     => $table_prefix,
                         'folderpath'    => $forumfolderpath,
                         'cookietimeout' => $cookietimeout['config_value'],
                         'cookieprefix'  => $cookieprefix['config_value'],
                         'extra'         => '');
  }

  return isset($forumsystem) ? $forumsystem : 0;
}



?>
