<?php
// +---------------------------------------------+
// |     Copyright  2007 - 2009 weenCompany      |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

define('IN_WEENCOMPANY', true);
$rootpath = './';

// ########################### LOAD WEENCOMPANY CORE ############################

include($rootpath . 'includes/core.php');
include($rootpath . 'modules/m18_hitcounter/count.php');

// ############################ LOAD MAIN SETTINGS #############################

$getmainsettings = $DB->query("SELECT varname, value FROM " . TABLE_PREFIX . "mainsettings");
for($i = 0; $setting = $DB->fetch_array($getmainsettings); $i++)
{
  $mainsettings[$setting['varname']] = $setting['value'];
}

// ############################# ENABLE GZIP COMPRESSION  ########################

if ( $mainsettings['gzipcompress'] == '1' &&
     @extension_loaded('zlib') &&
     @ini_get('zlib.output_compression') != '1' &&
     @ini_get('output_handler') != 'ob_gzhandler')
{
  @ob_start('ob_gzhandler');
}


// ################################ MOD REWRITE ################################

if($mainsettings['modrewrite'] AND strlen($_SERVER['REQUEST_URI']) AND !strstr($_SERVER['REQUEST_URI'], '?') AND substr($_SERVER['REQUEST_URI'], -4) != '.php')
{
  $addslashses = get_magic_quotes_gpc() ? false : true;

  $requesturi = substr($_SERVER['REQUEST_URI'], -1) == '/' ? substr($_SERVER['REQUEST_URI'], 0, -1) : $_SERVER['REQUEST_URI'];

  $subfolders = preg_replace("#https?://[^/]+(/?.*)#", "\$1", $weenurl);

  $urlvariables = substr($requesturi, strlen($subfolders));

  $variables = explode('/', $urlvariables);

  if(!count($variables) % 2 != 0)
  {
    header("HTTP/1.0 404 Not Found"); 
    PrintMessage($sdlanguage['url_not_found'] . '<br /><br /><a href="' . $weenurl . '">' . $sdlanguage['redirect_to_homepage'] . '</a>');
    exit;
  }

  if(strlen($variables[0]))
  {
    $urlcategoryname = $variables[0];

    $urlcategoryname = $addslashes ? addslashes(PreClean($urlcategoryname)) : PreClean($urlcategoryname);

    if($category = $DB->query_first("SELECT categoryid FROM " . TABLE_PREFIX . "categories WHERE urlname = '$urlcategoryname'"))
    {
      $_GET['categoryid'] = $category['categoryid'];

      for($i = 1; $i < count($variables); $i = $i+2)
      {
        $variablevalue = $variables[$i + 1];

        $variablevalue = $addslashes ? addslashes(PreClean($variablevalue)) : PreClean($variablevalue);

        $_GET[$variables[$i]] = $variablevalue;
      }
    }
    else
    {
      header("HTTP/1.0 404 Not Found"); 
      PrintMessage($sdlanguage['page_not_found'] . '<br /><br /><a href="' . $weenurl . '">' . $sdlanguage['redirect_to_homepage'] . '</a>');
      exit;
    }
  }
  else
  {
    $_GET['categoryid'] = 1;
  }
}



// ############################## GET CATEGORYID ###############################

$categoryid = (isset($_GET['categoryid']) AND preg_match("/^[0-9]+$/", $_GET['categoryid'])) ? $_GET['categoryid'] : 1;

$moduleid = (isset($_GET['moduleid']) AND preg_match("/^[0-9]+$/", $_GET['moduleid'])) ? $_GET['moduleid'] : 2;


// ####################### ALTER TITLE AND META SETTINGS #######################

if(isset($_GET['m'.$moduleid.'_articleid']) AND preg_match("/^[0-9]+$/", $_GET['m'.$moduleid.'_articleid']))
{
  if($article = $DB->query_first("SELECT title, metakeywords, metadescription FROM " . TABLE_PREFIX . 'm'.$moduleid.'_news'. " WHERE articleid = '" . $_GET['m'.$moduleid.'_articleid'] . "'"))
  {
    $mainsettings['websitetitle']    = $article['title'] . ' - ' . $mainsettings['websitetitle'];
    $mainsettings['metadescription'] .= ', ' . $article['metadescription'];
    $mainsettings['metakeywords']    .= ', ' . $article['metakeywords'];
  }
}

foreach($_GET as $index => $value){ 
	if(strstr($index,'sectionid')){
		   $imagessectionid = $value;
		   $imagessectionname = 'sectionid';
		   $imagesmodulename = str_replace('sectionid', 'products', $index);
	}elseif(strstr($index,'imageid')){
		   $imagesid = $value;
		   $imagesidname = 'imageid';
	}
}

if($imagessectionname == 'sectionid' && $imagesidname == 'imageid' && preg_match("/^[0-9]+$/", $imagesid)){

	if($thisimage = $DB->query_first("SELECT title FROM " . TABLE_PREFIX . $imagesmodulename . " WHERE imageid = '" . $imagesid . "'"))
	{
		$mainsettings['websitetitle']    = $thisimage['title'] . ' - ' . $mainsettings['websitetitle'];
	}

}


// ############################## SET PHP Options ##############################

@ini_set('arg_separator.output','&amp;'); 

@ini_set('session.use_trans_sid','0'); 


// ################### SET LOCALE TIME AND HEADER INFORMATION ##################

$languageinfo = explode('|', $mainsettings['language']);

$charset = $languageinfo[2];

header("Content-Type: text/html; charset=$charset");




// ################################# GET LOGO  #################################

$logo = $mainsettings['currentlogo'];



// ################################# COPYRIGHT #################################
if($mainsettings['websitebeian']){
	$websitebeian = ' <a href="http://www.miibeian.gov.cn/" target="_blank">' . $mainsettings['websitebeian'] . '</a>';
}
$copyright ='Copyright &copy; '.date("Y").' '. $mainsettings['copyrighttext'] . $websitebeian;

if(!$mainsettings['bfo'])
{
  $copyright .= '. Created by <a href="http://www.weentech.com" target="_blank" class="poweredby">weenCompany</a> 推荐您采用 <a href="http://www.needidc.com/store/" target="_blank" class="poweredby">灵动网络</a> <a href="http://www.needidc.com/store/" target="_blank" class="poweredby">虚拟主机</a>';
}



// ############################### USER SYSTEM  ################################

if(isset($_POST['loginusername']) OR isset($_POST['loginpassword']))
{
  if($usersystem['name'] == 'Invision Power Board 2')
  {
    $_POST['loginusername'] = str_replace('&#039;', '&#39;', $_POST['loginusername']);
    $_POST['loginpassword'] = str_replace('&#039;', '&#39;', $_POST['loginpassword']);
  }
  else
  {
    $_POST['loginusername'] = unhtmlspecialchars($_POST['loginusername']);
    $_POST['loginpassword'] = unhtmlspecialchars($_POST['loginpassword']);
  }
}

if($usersystem['dbname'] != $dbname)
{
  $DB->select_db($usersystem['dbname']);
  require($rootpath . 'includes/usersystems/' . $usersystem['queryfile']);
  $DB->select_db($dbname);
}
else
{
  require($rootpath . 'includes/usersystems/' . $usersystem['queryfile']);
}

unset($userinfo);
$userinfo = GetUserInfo($usersettings);
unset($usersettings);


// ############################### WEBSITE OFF? ################################

if($mainsettings['siteactivation'] == 'off')
{
  if($userinfo['offlinecategoryaccess'])
  {
    echo '<table width="100%" border="0" cellpadding="5" cellspacing="0" bgcolor="#FFFFFF">
          <tr>
            <td style="border: 4px solid #FF0000; font-size: 12px; color: #000000;" align="center"><b>Website in Offline Mode</b></td>
          </tr>
          </table>';
  }
  else
  {
    PrintMessage($mainsettings['offmessage']);
    exit();
  }
}



// ############################## CATEGORY ACCESS ##############################

if(!@in_array($categoryid, $userinfo['categoryviewids']))
{
  PrintMessage($sdlanguage['no_view_access'], 0);
  exit();
}


// ############################### IP Banned ? ################################

if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
{
  $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
}
elseif (isset($_SERVER['HTTP_VIA']))
{
  $ip = $_SERVER['HTTP_VIA'];
}
elseif (isset($_SERVER['REMOTE_ADDR']))
{
  $ip = $_SERVER['REMOTE_ADDR'];
}
else
{
  $ip = 'Banned';
}

if(IsIpBanned($ip))
{
  PrintMessage($sdlanguage['ip_banned'], 0);
  exit();
}


// ############################### SELECT DESIGN  ##############################

$design = $DB->query_first("SELECT d.maxmodules, d.designpath, s.name as templatename FROM " . TABLE_PREFIX . "designs d, " . TABLE_PREFIX . "categories c, " . TABLE_PREFIX . "templates s
                            WHERE c.categoryid = '$categoryid' AND d.designid = c.designid AND s.templateid = d.templateid");



// ############################ GET DESIGN'S MODULES  ##########################

$getmodules = $DB->query("SELECT moduleid FROM " . TABLE_PREFIX . "pagesort WHERE categoryid = '$categoryid' ORDER BY displayorder");

// store modules
for($i = 0; $i < $design['maxmodules']; $i++)
{
  $modules = $DB->fetch_array($getmodules);

  if(substr($modules['moduleid'], 0, 1) == 'c')
  {
    $custommoduleid  = substr($modules['moduleid'], 1);

    if(@in_array($custommoduleid, $userinfo['custommoduleviewids']))
    {
      $getcustommodule = $DB->query_first("SELECT displayname, module, includefile FROM " . TABLE_PREFIX . "custommodules WHERE custommoduleid = '$custommoduleid'");

      $custommodule[$i]     = $getcustommodule['module'];
      $custommodulefile[$i] = $getcustommodule['includefile'];

      $modulename[$i] = $getcustommodule['displayname'];
      $modulepath[$i] = 'modules/custommodules.php';
    }
    else
    {
      $modulename[$i] = '';
      $modulepath[$i] = 'modules/m1_empty/empty.php';
    }
  }
  else
  {
    $module = $DB->query_first("SELECT modulepath, displayname, authorname FROM " . TABLE_PREFIX . "modules WHERE moduleid = '".$modules['moduleid']."'");

    if(file_exists('modules/' . $module['modulepath']))
    {
      if(@in_array($modules['moduleid'], $userinfo['moduleviewids']))
      {
        $modulename[$i] = $module['displayname'];
        $modulepath[$i] = 'modules/' . $module['modulepath'];
      }
      else
      {
        $modulename[$i] = '';
        $modulepath[$i] = 'modules/m1_empty/empty.php';
      }
    }
    else
    {
      $modulename[$i] = '';
      $modulepath[$i] = 'modules/error.php';
    }
  }

}



// ############################## GET CATEGORIES  ##############################


if($mainsettings['categorytitle'])
{
	$getcategorytitle = $DB->query_first("SELECT name FROM " . TABLE_PREFIX . "categories WHERE categoryid = '".$categoryid."'");
	$mainsettings['websitetitle'] .= ' - ' . $getcategorytitle['name'];
}


// ############################### LOAD DESIGN  ################################

if($categoryid)
{
	$clickcategoryid = GetTopCategoryID($categoryid);

}else{
	$clickcategoryid =1;
}

$mainsettings['templateheader'] = iif(strlen($weenurl), '<base href="' . $weenurl . '"/>') . '
                                                          <script type="text/javascript">
                              <!--
                                                            var TMenu_path_to_files="'.$weenurl.'includes/javascript/hovermenu/";
                              //-->
                                                          </script>
                              <script type="text/javascript" src="includes/javascript/template_functions.js"></script>
                              <script type="text/javascript" src="includes/javascript/hovermenu/menu.js"></script>
							  <link rel="stylesheet" type="text/css" href="templates/custom_css.css" />
							  <script language="JavaScript" type="text/javascript">
								var clickcategoryID = "topcategoryid_' . $clickcategoryid . '"
							  </script>';

if(empty($design['designpath']))
{
  $errormsg = '<b>錯誤: 指定的模板樣式文件不存在.</b><br />
               此模板樣式文件可能已被刪除.<br /><br />
               <a href="index.php">點擊此處進入網站首頁.</a>';

  PrintMessage($errormsg);
}
else if(is_file('templates/'.$design['designpath']))
{
  if(!include('templates/'.$design['designpath']))
  {
    $errormsg = '<b>錯誤: 無法include包含模板樣式文件:</b><br />
                ' . $design['designpath'] . '<br /><br />
                 <a href="index.php">點擊此處進入網站首頁.</a>';
    PrintMessage($errormsg);
  }
}
else
{
  $errormsg = "<b>錯誤: 無法加載模板 '" . $design['templatename'] . "' 的樣式文件.</b><br />
               樣式文件 '" . 'templates/'.$design['designpath']. "' 不存在.<br /><br />
               <a href='index.php'>點擊此處進入網站首頁.</a>";

  PrintMessage($errormsg);
}



// ############################# CLOSE CONNECTION  #############################

$DB->close();

?>
