<?php
// +---------------------------------------------+
// |     Copyright 2003-2005 weenCompany         |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

if(!defined('IN_WEENCOMPANY'))
  die('File not found!');



// ############################## INSERT MESSAGE ###############################

function m7_InsertMessage($language)
{
  global $DB, $categoryid;

  $username = $_POST['m7_username'];
  $comment  = $_POST['m7_comment'];

  // first check if the user entered a username and comment
  if(!strlen($username))
  {
    $errors[] = $language['no_username'];
  }
  else if(!strlen($comment))
  {
    $errors[] = $language['no_comment'];
  }

  // if a username and message are entered then check if it's a repeat comment
  // this isn't done by default to save a query, pluse we don't want to check
  // the database for a record that doesn't have a username or comment
  if(!isset($errors))
  {
    // we don't want to match everything becuase the same user might have said 'hi' last month
    // so lets just check agains the last comment entered into the database
    $lastentry = $DB->query_first("SELECT username, comment FROM " . TABLE_PREFIX . "m7_chatterbox WHERE categoryid = '$categoryid'
                                   ORDER BY commentid DESC LIMIT 0, 1");

    if( ($lastentry['username'] == $username) AND ($lastentry['comment'] == $comment) )
    {
      $errors[] = $language['repeat_comment'];
    }
  }

  // if there are no errors, then submit the new message to the database
  if(!isset($errors))
  {
    $DB->query("INSERT INTO " . TABLE_PREFIX . "m7_chatterbox (categoryid, username, comment, datecreated)
                VALUES ($categoryid, '$username', '$comment', ".time().")");

    // now display all the messages
    m7_DisplayMessages($language);
  }
  else
  {
    // display the errors along with the chatterbox
    m7_DisplayMessages($language, $errors);
  }
}



// ############################# DISPLAY MESSAGES ##############################

function m7_DisplayMessages($language, $errors = array())
{
  global $DB, $weenurl, $userinfo, $categoryid, $inputsize, $sdlanguage;

  // get settings
  $getsettings = $DB->query("SELECT title, value FROM " . TABLE_PREFIX . "modulesettings WHERE moduleid = 7");
  while($setting = $DB->fetch_array($getsettings))
  {
    $settings[$setting['title']] = $setting['value'];
  }


  // display messages
  $getmessages = $DB->query("SELECT username, comment, datecreated FROM " . TABLE_PREFIX . "m7_chatterbox " . iif($settings['目標菜單'], "WHERE categoryid = '$categoryid'") . "
                             ORDER BY commentid DESC LIMIT 0, " . $settings['顯示條目數'] . "");

  while($message = $DB->fetch_array($getmessages))
  {
    $username = $message['username'];
    $comment  = $message['comment'];

    if($settings['換行字符數'])
    {
      $comment  = cws_wordwrap($comment,  $settings['換行字符數'], "<br />", 1);
    }

    if($settings['允許表情符號'])
    {
      $comment = AddSmilies($comment);
    }

    echo '<b>' . $username . '</b>:<br />';

    if($settings['顯示發表時間'])
    {
      echo DisplayDate($message['datecreated'], $settings['日期時間格式']) . '<br />';
    }

    echo $comment . '<br /><br />';
  }


  // display submit field
  if(@in_array(7, $userinfo['modulesubmitids']))
  {
    echo '<form action="' . RewriteLink('index.php?categoryid=' . $categoryid) . '" method="post" name="m7_chatterbox">
          <input type="hidden" name="m7_submit" value="1" />';

    if($userinfo['loggedin'])
    {
      echo '<input type="hidden" name="m7_username" value="' . $userinfo['username'] . '" />';
    }
    else
    {
      echo $language['name'] . '<br /><input type="text" name="m7_username" value="" size="' . $inputsize . '" maxlength="' . $settings['用戶名長度'] . '" /><br />';
    }

    echo $language['comment'] . '<br /><input type="text" name="m7_comment"  size="' . $inputsize . '" maxlength="' . $settings['內容長度'] . '" /><br />
          <input type="submit" value="' . strip_tags($language['say']) . '" />
          </form>';
  }
  else
  {
    echo $sdlanguage['no_post_access'] . '<br /><br />';
  }

  foreach($errors as $key => $value)
  {
    echo $value . '<br /><br />';
  }

  if($settings['顯示全部內容'])
  {
    echo '<script type="text/javascript">
          function m7_ViewHistory()
          {
            window.open("' . $weenurl . 'modules/m7_chatterbox/viewhistory.php?categoryid='.$categoryid.'", "", "width=600, height=auto, resizable=yes,scrollbars=yes")
          }
          </script>

          <a href="javascript: m7_ViewHistory();">' . $language['view_history'] . '</a><br/>';
  }
}



// ############################## SELECT FUNCTION ##############################

$m7_language = GetLanguage(7);

if(isset($_POST['m7_submit']) AND in_array(7, $userinfo['modulesubmitids']))
{
  m7_InsertMessage($m7_language);
}
else
{
  m7_DisplayMessages($m7_language);
}

unset($m7_language);

?>
