<?php

define('IN_ADMIN', true);
define('IN_WEENCOMPANY', true);

$rootpath = "./../";

include($rootpath . 'includes/core.php');

PrintHeader('前台语言');


// ############################## UPDATE LANGUGAE ##############################

function TranslateLanguage()
{
  global $DB;

  $languagefile = $_POST['languagefile'];

  include('./languages/' . $languagefile);

  if($languagefile == 'default.php')
  {
    $DB->query("UPDATE " . TABLE_PREFIX . "phrases SET customphrase = ''");
  }
  else
  {
    foreach($sdphrases as $i => $x)
    {
      foreach($sdphrases[$i] as $k => $v)
      {
        $DB->query("UPDATE " . TABLE_PREFIX . "phrases SET customphrase = '" . addslashes($v) . "' WHERE varname = '$k' AND moduleid = '$i'");
      }
    }
  }

  $languagearray = array($languagefile, $version, $charset);
  $languageinfo  = implode('|', $languagearray);

  $DB->query("UPDATE " . TABLE_PREFIX . "mainsettings SET value = '$languageinfo' WHERE varname = 'language'");

  PrintRedirect('./languages.php', 1);

}


// ############################## UPDATE LANGUGAE ##############################

function UpdateLanguage()
{
  global $DB;

  $moduleid     = $_POST['moduleid'];
  $phraseid     = $_POST['phraseid'];
  $customphrase = $_POST['customphrase'];
  $font         = $_POST['font'];
  $color        = $_POST['color'];
  $size         = $_POST['size'];
  $bold         = $_POST['bold'];
  $italic       = $_POST['italic'];
  $underline    = $_POST['underline'];

  for($i = 0; $i < count($phraseid); $i++)
  {
    $DB->query("UPDATE " . TABLE_PREFIX . "phrases SET customphrase = '$customphrase[$i]',
                                                       font         = '$font[$i]',
                                                       color        = '$color[$i]',
                                                       size         = '$size[$i]'
                                                 WHERE phraseid     = '$phraseid[$i]'");
  }

  // checkboxes don't return unchecked values, thus we need to do this:

  // first we need to empty bold, italic, underline
  $DB->query("UPDATE " . TABLE_PREFIX . "phrases SET bold      = '0',
                                                     italic    = '0',
                                                     underline = '0'
                                               WHERE moduleid  = '$moduleid'");

  if($bold)
    foreach($bold as $key=>$value)
      $DB->query("UPDATE " . TABLE_PREFIX . "phrases SET bold = '$value' WHERE phraseid = '$key'");

  if($italic)
    foreach($italic as $key=>$value)
      $DB->query("UPDATE " . TABLE_PREFIX . "phrases SET italic = '$value' WHERE phraseid = '$key'");

  if($underline)
    foreach($underline as $key=>$value)
      $DB->query("UPDATE " . TABLE_PREFIX . "phrases SET underline = '$value' WHERE phraseid = '$key'");


  PrintRedirect('./languages.php', 1);

}


// ########################### PRINT INSTRUCTIONS ##############################

function PrintInstructions()
{
  PrintSection('关于前台语言');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow2">
          weenCompany闻名企业网站系统允许您自定义网站前台语言, 包括: 编辑, 删除, 导入导出, 也可以调整前台语言的字体, 颜色, 大小等. 颜色参考: <a href="./colors.php" target="_blank"><b>web颜色列表</b></a>.
		  <br>1. "字体"可参考Dreamweaver等网页制作时添加的字体, 如: 仿宋_GB2312, 表示词句显示为仿宋体;
		  <br>2. "颜色"可参考 "web颜色列表", 如: #996600, 也可直接填写red, blue, green等这些代表颜色的单词;
		  <br>3. "大小"需填写代表字体大小的px值, 如: 12, 它表示字体为12px.
          </td>
        </tr>
        </table>';
  EndSection();
}


// ############################## EDIT LANGUAGE ################################

function EditLanguage($moduleid)
{
  global $DB;

  PrintInstructions();

  $module      = $DB->query_first("SELECT name FROM " . TABLE_PREFIX . "modules WHERE moduleid = '$moduleid'");
  $getlanguage = $DB->query("SELECT * FROM " . TABLE_PREFIX . "phrases WHERE moduleid = '$moduleid'");

  // start form
  echo '<form action="./languages.php" method="post">
        <input type="hidden" name="action" value="updatelanguage" />
        <input type="hidden" name="moduleid" value="' . $moduleid . '" />';

  PrintSection(iif($moduleid == 1, '系统程序', $module['name']).'_前台语言');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1">默认词句</td>
          <td class="tdrow1">自定义词句</td>
          <td class="tdrow1">字体</td>
          <td class="tdrow1">颜色</td>
          <td class="tdrow1" width="50">大小</td>
          <td class="tdrow1" width="50">粗体</td>
          <td class="tdrow1" width="50">斜体</td>
          <td class="tdrow1" width="50">下划线</td>
        </tr>';

  while($language = $DB->fetch_array($getlanguage))
  {
    echo '<input type="hidden" name="phraseid[]" value="' . $language['phraseid'] . '" />
          <tr>
            <td class="tdrow2">' . $language['defaultphrase'] . '&nbsp;</td>
            <td class="tdrow3"><input type="text"     name="customphrase[]"    value="' . CleanFormValue($language['customphrase'])    . '" size="25" />&nbsp;</td>
            <td class="tdrow2"><input type="text"     name="font[]"  value="' . CleanFormValue($language['font'])  . '" size="15" />&nbsp;</td>
            <td class="tdrow3"><input type="text"     name="color[]" value="' . CleanFormValue($language['color']) . '" size="8" />&nbsp;</td>
            <td class="tdrow2"><input type="text"     name="size[]"  value="' . CleanFormValue($language['size'])  . '" size="3" />&nbsp;</td>
            <td class="tdrow3"><input type="checkbox" name="bold['      . $language['phraseid'] . ']" value="1" ' . iif($language['bold'], 'checked', '') . ' />&nbsp;</td>
            <td class="tdrow2"><input type="checkbox" name="italic['    . $language['phraseid'] . ']" value="1" ' . iif($language['italic'], 'checked', '') . '/>&nbsp;</td>
            <td class="tdrow3"><input type="checkbox" name="underline[' . $language['phraseid'] . ']" value="1" ' . iif($language['underline'], 'checked', '') . '/>&nbsp;</td>
          </tr>';
  }

  echo '<tr>
          <td class="tdrow1" bgcolor="#FCFCFC" colspan="8" align="center"><input type="submit" value=" 保存更新 " /></td>
        </tr>
        </table>
        </form>';
  EndSection();

}



function DisplayPhraseRow($modules, $modulestype)
{
  global $DB;

  echo '<tr>
          <td class="tdrow1" width="250">' . $modulestype . '</td>
          <td class="tdrow1" width="100">默认词句</td>
          <td class="tdrow1" width="225">自定义词句</td>
          <td class="tdrow1">编辑语言</td>
        </tr>';

  while($module = $DB->fetch_array($modules))
  {
    $phraserows = $DB->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "phrases
                                    WHERE moduleid = " . $module['moduleid']);

    $customrows = $DB->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "phrases
                                    WHERE customphrase != '' AND moduleid = " . $module['moduleid']);

    echo '<tr>
            <td class="tdrow2">' . iif($module['moduleid'] == 1, '系统程序', $module['name']) . '</td>
            <td class="tdrow3">' . $phraserows['total'] . '</td>
            <td class="tdrow2"><span ' . iif($customrows['total'], 'class="ohred"') . '>'. $customrows['total'] . '</span></td>
            <td class="tdrow3">';

    if($phraserows['total'])
    {
      echo '  <form action="./languages.php" method="post">
              <input type="hidden" name="moduleid" value="' . $module['moduleid'] . '" />
              <input type="hidden" name="action"   value="editlanguage" />
              <input type="submit" style="width: 175px;" value="' . iif($module['moduleid'] == 1, '系统程序', $module['name']) . '" />
              </form>';
    }
    else
      echo '&nbsp;';

    echo '  </td>
          </tr>';
  }
}


// ############################## PRINT Default ################################

function PrintDefault()
{
  global $DB, $userinfo;

  $getlanguageinfo = $DB->query_first("SELECT value FROM " . TABLE_PREFIX . "mainsettings WHERE varname = 'language'");
  $languageinfo    = explode('|', $getlanguageinfo['value']);

  PrintInstructions();

  PrintSection('导入前台语言');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1" colspan="2">选择语言文件</td>
        </tr>
        <tr>
          <td class="tdrow2" width="70%">
		    1. 选择导入"default", 即恢复为系统默认的前台语言, 并删除自定义的前台语言.<br/>
            2. 导入语言需先导出语言或将下载编辑后的前台语言文件上传到目录: '.ADMIN_DIR.'/languages/ 下.<br /><br />

            <td class="tdrow3" valign="top">
            <form action="./languages.php" method="post">
              <input type="hidden" name="action" value="translatelanguage" />
              <select name="languagefile">';

  // find language files
  $d = dir('./languages/');

  while($entry = $d->read())
  {
    if($entry != "." && $entry != ".." && filesize('languages/'.$entry))
    {
      echo '<option value="' . $entry . '" ' . iif($entry == $languageinfo[0], "selected", "") . '>' . substr($entry, 0, -4)  . ' ' . iif($entry == $languageinfo[0], $languageinfo[1], "") . '</option>';
    }
  }

  echo '      </select><br/><br/>
              <input type="submit" value=" 导入语言 " />
            </form>
          </td>
        </tr>
        </table>';
  EndSection();

  PrintSection('导出自定义语言');
  echo '<form action="./exportlanguage.php" method="post">
        <table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1" colspan="2">语言名称</td>
        </tr>
        <tr>
          <td class="tdrow2" width="70%">
		  为要导出的自定义前台语言设置一个名称(可选):<br/><br/>
		    1. 用户自定义前台语言后, 可导出语言保存到语言文件, 供重装系统后导入使用.<br/>
			2. 导出语言时, 自定义语言已自动保存到: '.ADMIN_DIR.'/languages/ 目录下的custom_lang.php文件中, 同时提示下载.<br/>
		  </td>
          <td class="tdrow3"><input type="text" name="language" value="' . substr($languageinfo[0], 0, -4) . '" /></td>
        </tr>
        <tr>
          <td class="tdrow1" colspan="2">版本号</td>
        </tr>
        <tr>
          <td class="tdrow2" width="70%">为要导出的自定义前台语言设置一个版本号(可选): </td>
          <td class="tdrow3"><input type="text" name="version" value="' . $languageinfo[1] . '" /></td>
        </tr>
        <tr>
          <td class="tdrow1" colspan="2">作者</td>
        </tr>
        <tr>
          <td class="tdrow2" width="70%">输入自定义前台语言的作者(可选):</td>
          <td class="tdrow3"><input type="text" name="author" value="' . $userinfo['username'] . '" /></td>
        </tr>
        <tr>
          <td class="tdrow1" colspan="2">包含默认语言</td>
        </tr>
        <tr>
          <td class="tdrow2" width="70%">选择包含默认语言, 当导出自定义前台语言时, 没有自定义的地方将用默认语言填充. <br />不选择此项, 则仅导出用户自定义语言.</td></td>
          <td class="tdrow3"><input type="checkbox" name="includedefault" value="1" checked/> 包含默认语言</td>
        </tr>
        <tr>
          <td class="tdrow1" bgcolor="#FCFCFC" colspan="2" align="center"><input type="submit" value="导出自定义语言" /></td>
        </tr>
        </table>
        </form>';
  EndSection();

  PrintSection('自定义前台语言');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">';

  // MAIN MODULE PHRASES
  $modules = $DB->query("SELECT moduleid, name FROM " . TABLE_PREFIX . "modules WHERE authorname = 'weencompany' ORDER BY moduleid");
  DisplayPhraseRow($modules, '系统模块');

  // CLONED MODULE PHRASES
  $modules = $DB->query("SELECT moduleid, name FROM " . TABLE_PREFIX . "modules WHERE moduleid != 1 AND authorname = 'weencompany_cloner' ORDER BY moduleid");
  if($DB->get_num_rows($modules))
  {
    DisplayPhraseRow($modules, '复制的模块');
  }

  // DOWNLOADED MODULE PHRASES
  $modules = $DB->query("SELECT moduleid, name FROM " . TABLE_PREFIX . "modules WHERE moduleid != 1 AND authorname != 'weencompany' AND authorname != 'weencompany_cloner' ORDER BY moduleid");
  if($DB->get_num_rows($modules))
  {
    DisplayPhraseRow($modules, '下载的模块');
  }

  echo '</table>';
  EndSection();
}


// ############################## SELECT FUNCTION ##############################

switch($action)
{
  case 'editlanguage':
    EditLanguage($_POST['moduleid']);
  break;

  case 'updatelanguage':
    UpdateLanguage();
  break;

  case 'translatelanguage':
    TranslateLanguage();
  break;

  default:
    PrintDefault();
}


PrintFooter();

?>