<?php
// +---------------------------------------------+
// |     Copyright  2007 - 2009 weenCompany      |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

class	ConfigurationTest
{
	function		check($tests)
	{
		$res = array();
		foreach ($tests AS $key => $test)
			$res[$key] = $this->run($key, $test);
		return $res;
	}
	
	function		run($ptr, $arg = 0)
	{
		if (call_user_func(array($this, 'test_'.$ptr), $arg))
			return ('ok');
		return ('fail');
	}

	
	// is_writable files	
	function		test_file($file)
	{
		if (!file_exists($file) || !is_writable($file))
			return false;
		return true;
	}

	// is_writable dirs	
	function		test_dir($dir, $recursive = false)
	{
		if (!is_writable($dir) OR !$dh = opendir($dir))
			return false;
		if ($recursive)
		{
			while (($file = readdir($dh)) != false)
				if (@filetype($dir.$file) == 'dir' AND $file != '.' AND $file != '..')
					if (!$this->test_dir($dir.$file, true))
						return false;
		}
		closedir($dh);
		return true;
	}
	
	// Misc functions	
	function		test_phpversion()
	{
	
		return  substr(phpversion(), 0, 3) >= '4.0';
	}
	
	function		test_mysql_support()
	{
		return function_exists('mysql_connect');
	}

	function		test_upload()
	{
		return  ini_get('file_uploads');
	}

	function		test_system($funcs)
	{
		foreach ($funcs AS $func)
			if (!function_exists($func))
				return false;
		return true;
	}

	function		test_gd()
	{
		return function_exists('imagecreatetruecolor');
	}
	

	function		test_backup_dir($dir)
	{
		return $this->test_dir($dir);
	}
	
	function		test_modules_dir($dir)
	{
		return $this->test_dir($dir);
	}

	function		test_procn_dir($dir)
	{
		return $this->test_dir($dir);
	}
	
	function		test_proen_dir($dir)
	{
		return $this->test_dir($dir);
	}
	
	function		test_proupload_dir($dir)
	{
		return $this->test_dir($dir);
	}
	
	function		test_images_dir($dir)
	{
		return $this->test_dir($dir, true);
	}
	
	function		test_templates_dir($dir)
	{
		return $this->test_dir($dir, true);
	}
	
	
	function		test_cnlang_file($file)
	{
		return $this->test_file($file);
	}
	
	function		test_enlang_file($file)
	{
		return $this->test_file($file);
	}
	
	function		test_config_file($file)
	{
		return $this->test_file($file);
	}
	
	function		test_forelang_file($file)
	{
		return $this->test_file($file);
	}
	
	function		test_mplang_file($file)
	{
		return $this->test_file($file);
	}
	
}
?>