<?php
// +---------------------------------------------+
// |     Copyright 2006-2008 weenCompany         |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

if(!defined('IN_WEENCOMPANY'))
{
  die('File not found!');
}


// ############################# Begin Functions ############################

// insert a new link into the database

function InsertLink($sectionid, $activated, $allowsmilies, $showauthor, $author, $title, $url, $description)
{
  global $DB;
  global $refreshpage;

  $activated = empty($activated) ? 0 : $activated;
  $allowsmilies = empty($allowsmilies) ? 0 : $allowsmilies;
  $showauthor = empty($showauthor) ? 0 : $showauthor;

  if(strlen($title) == 0)
  {
    $errors[] = '必须输入链接的标题!';
  }

  if(strlen($url) == 0)
  {
    $errors[] = '必须输入链接的URL!';
  }

  if(!isset($errors))
  {
    $DB->query("INSERT INTO " . TABLE_PREFIX . "m16_links VALUES ('0', '$sectionid', '$activated', '$allowsmilies', '$showauthor', '$author', '$title', '$url', '$description') ");

    PrintRedirect($refreshpage, 1);
  }
  else
  {
    PrintErrors($errors);

    DisplayLinkForm(null);  // 1 = errors exist
  }
}



// update a link

function UpdateLink($deletelink, $linkid, $sectionid, $activated, $allowsmilies, $showauthor, $author, $title, $url, $description)
{
  global $DB, $refreshpage;

  $activated = empty($activated) ? 0 : $activated;
  $allowsmilies = empty($allowsmilies) ? 0 : $allowsmilies;
  $showauthor = empty($showauthor) ? 0 : $showauthor;

  // delete link?
  if($deletelink == 1)
  {
    return DeleteLink($linkid);
  }

  if(strlen($title) == 0)
  {
    $errors[] = '必须输入链接的标题!';
  }

  if(strlen($url) == 0)
  {
    $errors[] = '必须输入链接的URL!';
  }

  if(!isset($errors))
  {
    $DB->query("UPDATE " . TABLE_PREFIX . "m16_links SET sectionid    = '$sectionid',
                                   activated    = '$activated',
                                   allowsmilies = '$allowsmilies',
                                   showauthor   = '$showauthor',
                                   author       = '$author',
                                   title        = '$title',
                                   url          = '$url',
                                   description  = '$description'
                             WHERE linkid       = '$linkid'");

    PrintRedirect($refreshpage, 1);
  }
  else
  {
    PrintErrors($errors);

    DisplayLinkForm($linkid);
  }
}



// delete a link from the database

function DeleteLink($linkid)
{
  global $DB;
  global $refreshpage;

  $DB->query("DELETE FROM " . TABLE_PREFIX . "m16_links WHERE linkid = '$linkid'");

  PrintRedirect($refreshpage, 1);
}



function DeleteLinks()
{
  global $DB;
  global $refreshpage;

  // get post vars
  $linkids = $_POST['linkids'];
  $editlinkids = $_POST['editlinkids'];
  $onlinestatus  = $_POST['onlinestatus'];
  $sectionid  = $_POST['sectionid'];

  for($i = 0; $i < count($editlinkids); $i++)
  {
     $DB->query("UPDATE " . TABLE_PREFIX . "m16_links SET sectionid    = '$sectionid[$i]',
															activated = '$onlinestatus[$i]'
														WHERE linkid = '$editlinkids[$i]'");
  }

  for($i = 0; $i < count($linkids); $i++)
  {
    $DB->query("DELETE FROM " . TABLE_PREFIX . "m16_links WHERE linkid = '".$linkids[$i]."'");
  }

  PrintRedirect($refreshpage, 1);
}



// insert a new section

function InsertSection($parentid, $activated, $name, $description, $sorting)
{
  global $DB;
  global $refreshpage;

  $activated = empty($activated) ? 0 : $activated;
  if(strlen($name) == 0)
  {
    $errors[] = '必须输入类别名称!';
  }

  if(!isset($errors))
  {
    $DB->query("INSERT INTO " . TABLE_PREFIX . "m16_sections VALUES ('0', '$parentid', '$activated', '$name', '$description', '$sorting') ");

    PrintRedirect($refreshpage, 1);
  }
  else
  {
    PrintErrors($errors);

    DisplaySectionForm(null);
  }
}

function UpdateSection($sectionid, $parentid, $activated, $name, $description, $sorting)
{
  global $DB, $refreshpage;

  $parentid  = empty($parentid)  ? 0 : $parentid;
  $activated = empty($activated) ? 0 : $activated;

  // delete section
  if($_POST['deletesection'] == 1)
  {
	   $subsection = $DB->query_first("SELECT parentid FROM " . TABLE_PREFIX . "m16_sections WHERE parentid = '$sectionid'");
	   if (isset($subsection))
	   {
			$errors[] = '无法删除此链接类别! 您必须先删除此类别的子类别.';
			PrintErrors($errors);
			DisplaySectionForm($sectionid);
			exit();
	   }
  }

  // delete section links
  if($_POST['deletesectionlinks'] == 1 && $_POST['deletesection'] == 1)
  {
	  $DB->query("DELETE FROM " . TABLE_PREFIX . "m16_links WHERE sectionid = '$sectionid'");
	  $DB->query("DELETE FROM " . TABLE_PREFIX . "m16_sections WHERE sectionid = '$sectionid'");
	  PrintRedirect($refreshpage, 1);
  }
  
  if($_POST['deletesectionlinks'] == 1 && $_POST['deletesection'] == 0)
  {
	  $DB->query("DELETE FROM " . TABLE_PREFIX . "m16_links WHERE sectionid = '$sectionid'");
  }
  
  if($_POST['deletesectionlinks'] == 0 && $_POST['deletesection'] == 1)
  {
	  $DB->query("DELETE FROM " . TABLE_PREFIX . "m16_sections WHERE sectionid = '$sectionid'");
      $DB->query("UPDATE " . TABLE_PREFIX . "m16_links SET sectionid = '$parentid' WHERE sectionid = '$sectionid'");

        PrintRedirect($refreshpage, 1);
  }


  if(strlen($name) == 0)
  {
    $errors[] = '必须输入类别名称!';
  }

  if(!isset($errors))
  {
    if($sectionid=='1'){$activated=1;}
	
    $DB->query("UPDATE " . TABLE_PREFIX . "m16_sections SET parentid    = '$parentid',
                                      activated   = '$activated',
                                      name        = '$name',
                                      description = '$description',
                                      sorting     = '$sorting'
                                WHERE sectionid   = '$sectionid'");

    PrintRedirect($refreshpage, 1);
  }
  else
  {
    PrintErrors($errors);

    DisplaySectionForm($sectionid);
  }
}


// display options

function DisplaySettings()
{
  global $DB;
  global $moduleid;
  global $refreshpage;

  PrintModuleSettings($moduleid, '模块设置', $refreshpage);
}

// view the section form to insert/edit a section

function DisplaySectionForm($sectionid)
{
  global $DB, $rootpath, $refreshpage;

  if(isset($sectionid))
  {
    // gather section information
    $section = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "m16_sections WHERE sectionid = $sectionid");

    PrintSection('编辑分类: '.$section['name']);
  }
  else
  {
    // create empty array
    $section = array('sectionid'   => 0,
                     'parentid'    => 1,
                     'activated'   => 1,
                     'name'        => '',
                     'description' => '',
                     'sorting'     => '时间(降序)' );

    PrintSection('添加分类');
  }

  echo '<form method="post" action="'.$refreshpage.'">
        <input type="hidden" name="sectionid"  value="'.$sectionid.'" />

        <table width="100%" border="0" cellpadding="5" cellspacing="0">';

  if(isset($sectionid))
  {
    echo '<tr>
            <td class="tdrow2" width="15%"><b>删除类别:</b></td>
            <td class="tdrow3" width="75%" valign="top">';

    if($sectionid == 1)
    {
      echo '默认根类别不能删除.';
    }
    else
    {
      echo '<input type="checkbox" name="deletesection" value="1"> 删除此类别? 注: 如仅删除链接类别, 而不删除所有此类链接, 则所有此类链接自动转入其父类.
';
    }

    echo '  </td>
          </tr>';


    echo '<tr>
            <td class="tdrow2" width="15%" valign="top"><b>删除链接:</b></td>
            <td class="tdrow3" width="75%" valign="top">
              <input type="checkbox" name="deletesectionlinks" value="1"> 删除此类别的所有链接?
            </td>
          </tr>';
  }

  echo '<tr>
          <td class="tdrow2" width="15%"><b>所属类别:</b></td>
          <td class="tdrow3" width="75%" valign="top">';

	if(isset($sectionid))
	{
		if($sectionid == 1)
		{
			echo '根类别是所有类别的父类, 不能设置为子类.';
		}
		else
		{
			PrintSectionSelectionEXX('parentid', $section['parentid'], $section['sectionid']);
		}
    }
	else
	{
		PrintSectionSelection('parentid', $section['parentid'], $section['sectionid']);
	}
  

  echo '  </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%" valign="top"><b>链接排序:</b></td>
          <td class="tdrow3" width="75%" valign="top">
                          <select name="sorting">
              <option '.iif($section[sorting] == "时间(降序)","selected") .'>时间(降序)</option>
              <option '.iif($section[sorting] == "时间(升序)","selected") .'>时间(升序)</option>
              <option '.iif($section[sorting] == "标题(A-Z)","selected") .'>标题(A-Z)</option>
              <option '.iif($section[sorting] == "标题(Z-A)","selected") .'>标题(Z-A)</option>
              <option '.iif($section[sorting] == "作者(A-Z)","selected") .'>作者(A-Z)</option>
			  <option '.iif($section[sorting] == "作者(Z-A)","selected") .'>作者(Z-A)</option>
            </select>
          </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%"><b>类别名称:</b></td>
          <td class="tdrow3" width="75%" valign="top">
            <input type="text" name="name" value="'.CleanFormValue($section['name']).'" />
          </td>
        </tr>';

  if($sectionid != 1)
  {
    echo '<tr>
            <td class="tdrow2" width="15%" valign="top"><b>类别描述:</b></td>
            <td class="tdrow3" width="75%" valign="top">
              <textarea name="description" cols="54" rows="5">'.$section['description'].'</textarea>
            </td>
          </tr>
          <tr>
            <td class="tdrow2" width="15%" valign="top"><b>发布选项:</b></td>
            <td class="tdrow3" width="75%" valign="top">
              <input type="checkbox" name="activated" value="1" '.iif($section['activated']== 1, "CHECKED").'>
<b>发布:</b> 网站显示此类别及其下属链接?
            </td>
          </tr>';
  }

  echo '<tr>
          <td colspan="2" class="tdrow1" align="center">';

  if($sectionid)
  {
    echo '<input type="hidden" name="action" value="updatesection" />
          <input type="submit" value=" 保存更新 " />';  }
  else
  {
    echo '<input type="hidden" name="action" value="insertsection" />
          <input type="submit" value=" 提交保存 " />';
  }

  echo '  </td>
        </tr>
        </table>
        </form>';
  EndSection();
}



// view the link form to insert/edit a link

function DisplayLinkForm($linkid)
{
  global $DB, $rootpath, $refreshpage, $userinfo, $loadwysiwyg, $enablewysiwyg;

  if(isset($linkid))
  {
    // gather link information
    $link = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "m16_links WHERE linkid = '$linkid'");

    PrintSection('编辑链接');
  }
  else
  {
    // get current loggedin username
    $username = $userinfo['username'];

    // create empty array
    $link = array("sectionid"    => '1',
                  "author"       => $username,
                  "title"        => "",
                  "url"          => "http://",
                  "description"  => "",
                  "activated"    => 1,
                  "showauthor"   => 1,
                  "allowsmilies" => 1 );

    PrintSection('添加链接');
  }

  echo '<form method="post" action="'.$refreshpage.'">
        <input type="hidden" name="linkid"  value="'.$linkid.'" />

        <table width="100%" border="0" cellpadding="5" cellspacing="0">';

  if(isset($linkid))
  {
    // delete link option
    echo '<tr>
            <td class="tdrow2" width="15%"><b>删除链接:</b></td>
            <td class="tdrow3" width="75%" valign="top">
              <input type="checkbox" name="deletelink"  value="1"> 删除此链接?
            </td>
          </tr>';
  }

  echo '<tr>
          <td class="tdrow2" width="15%"><b>发布人:</b></td>
          <td class="tdrow3" width="75%" valign="top">
            <input type="text" name="author" value="'.CleanFormValue($link['author']).'" />
          </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%"><b>所属类别:</b></td>
          <td class="tdrow3" width="75%" valign="top">';

  PrintSectionSelection('sectionid', $link['sectionid']);

  echo '  </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%"><b>链接标题:</b></td>
          <td class="tdrow3" width="75%" valign="top">
            <input type="text" name="title" size="64" maxlength="128" value="'.CleanFormValue($link['title']).'">
          </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%" valign="top"><b>链接路径:</b></td>
          <td class="tdrow3" width="75%" valign="top">
            <input type="text" name="url" size="64" value="'.CleanFormValue($link['url']).'"> 需填写完整路径, 如: <i>http://www.weentech.com</i>
          </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%" valign="top"><b>链接描述:</b>';
		  
		  if($loadwysiwyg AND $enablewysiwyg){
			echo '&nbsp&nbsp<a href="javascript:;" onclick="javascript: ween_toggleEditor(\'linkdescription\', \'tinytogglelink\', \'tinytoggleimglink\');return false;" id="tinytogglelink" title="Hide TinyMCE"><img src="styles/advanced/images/disabletiny.gif" border="0" align="absmiddle" id="tinytoggleimglink"></a>';
		  }
	echo '</td>
          <td class="tdrow3" width="75%" valign="top">
            <textarea name="description" rows="22" style="width: 100%;" class="mceEditor" id="linkdescription">'.$link['description'].'</textarea>
          </td>
        </tr>
        <tr>
          <td class="tdrow2" width="15%" valign="top"><b>发布选项:</b></td>
          <td class="tdrow3" width="75%" valign="top">
            <input type="checkbox" name="activated"     value="1" '.iif($link['activated']== 1, "CHECKED").'>
<b>发布:</b> 选择是否发布链接?<br />
            <input type="checkbox" name="showauthor"    value="1" '.iif($link['showauthor']== 1, "CHECKED").'>
<b>发布人:</b> 选择是否显示发布人?<br />
            <input type="checkbox" name="allowsmilies"  value="1" '.iif($link['allowsmilies']== 1, "CHECKED").'> <b>表情符号:</b> 是否允许在链接描述中输入的表情代码字符组合转换成表情符号?<br />
          </td>
        </tr>
        <tr>
          <td colspan="2" align="center" class="tdrow1">';

  if($linkid)
  {
    echo '<input type="hidden" name="action" value="updatelink" />
          <input type="submit" value=" 保存更新 " />';  }
  else
  {
    echo '<input type="hidden" name="action" value="insertlink" />
          <input type="submit" value=" 提交保存 " />';
  }

  echo '  </td>
        </tr>
        </table>
        </form>';
  EndSection();

}



function PrintSectionChildren($parentid, $selected, $exclude, $indent, $displaycounts = 0)
{
  global $DB;

  $getsections = $DB->query("SELECT sectionid, name FROM " . TABLE_PREFIX . "m16_sections WHERE parentid = $parentid ORDER BY name");


  while($sections = $DB->fetch_array($getsections))
  {
        if($exclude != $sections['sectionid'])
    {
                $name = $indent . ' ' . $sections['name'] .iif($sections['sectionid'] == 1,"(默认)","");

                if($displaycounts)
                {
					$getimagecount = $DB->query_first("SELECT COUNT(*) FROM " . TABLE_PREFIX . "m16_links WHERE sectionid = " . $sections['sectionid']);
					$name .= '('.$getimagecount[0].')';
                }

                echo "<option value=\"$sections[sectionid]\" ".iif($selected == $sections['sectionid'],"selected","").">$name</option>";
    }

    PrintSectionChildren($sections['sectionid'], $selected, $exclude, $indent . '-', $displaycounts);
  }
}


function PrintSectionChildrenEXX($parentid, $selected, $exclude, $indent, $displaycounts = 0)
{
  global $DB;

  $getsections = $DB->query("SELECT sectionid, parentid, name FROM " . TABLE_PREFIX . "m16_sections WHERE parentid = $parentid ORDER BY name");

  while($sections = $DB->fetch_array($getsections))
  {
    if($exclude != $sections['sectionid'] && $exclude != $parentid)
    {
		$name = $indent . ' ' . $sections['name'] .iif($sections['sectionid'] == 1,"(默认)","");

		if($displaycounts)
		{
		$getimagecount = $DB->query_first("SELECT COUNT(*) FROM " . TABLE_PREFIX . "m16_links WHERE activated = '1' AND sectionid = " . $sections['sectionid']);
	$name .= '('.$getimagecount[0].')';
		}

		echo "<option value=\"$sections[sectionid]\" ".iif($selected == $sections['sectionid'],"selected","").">$name</option>";
		PrintSectionChildrenEXX($sections['sectionid'], $selected, $exclude, $indent . '-', $displaycounts);
	}
  }
}



// ############################ PRINT SELECTION BOX ############################

// display sections in a selection box
function PrintSectionSelection($name, $selected = null, $exclude = null)
{
        echo '<select name="' . $name . '">';
        PrintSectionChildren(0, $selected, $exclude, '');
        echo '</select>';
}

function PrintSectionSelectionEXX($name, $selected = null, $exclude = null)
{
        echo '<select name="' . $name . '">';
        PrintSectionChildrenEXX(0, $selected, $exclude, '');
        echo '</select>';
}


// ######################## PRINT SECTION SELECTION EX #########################

function PrintSectionSelectionEx()
{
        global $DB;

        echo '<select name="sectionid">';
    PrintSectionChildren(0, null, null, '', 1);

        $getofflineimages = $DB->query_first("SELECT count(*) FROM " . TABLE_PREFIX . "m16_links WHERE activated = '0'");

        echo '<option value="nonline">未发布(' . $getofflineimages[0] . ')</option>
        </select>';
}



// display links

function DisplayLinks($viewtype, $start)  
{
  global $DB;
  global $refreshpage;

  $thisaction ='displaylinks';
  switch($viewtype)
  {
    case 'all':   // 10 most recent submissions
      $getlinks = $DB->query("SELECT * FROM " . TABLE_PREFIX . "m16_links ORDER BY linkid DESC LIMIT $start,10");
	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "m16_links");
	  $viewtypename  = '全部链接列表';   
	  $thisaction ='';
    break;

    case 'nonline':  // offline = (not activated, needs review)
      $getlinks = $DB->query("SELECT * FROM " . TABLE_PREFIX . "m16_links WHERE activated = '0' ORDER BY linkid DESC LIMIT $start,10");
	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "m16_links WHERE activated = '0'");
	  $viewtypename  = '未发布_链接列表';   
    break;

    default:
      $sectionid = $viewtype;
      $getlinks  = $DB->query("SELECT * FROM " . TABLE_PREFIX . "m16_links WHERE sectionid = '$sectionid' ORDER BY linkid DESC LIMIT $start,10");
	  $maxrows = $DB->query_first("SELECT COUNT(*) AS value FROM " . TABLE_PREFIX . "m16_links WHERE sectionid = '$sectionid'");
	  $sectionname  = $DB->query_first("SELECT name FROM " . TABLE_PREFIX . "m16_sections WHERE sectionid = '$sectionid'");
  	  $viewtypename = $sectionname[0] . '_链接列表';
  }

  PrintSection($viewtypename);  

  echo '<form action="'.$refreshpage.'" method="POST" name="deletelinksform">
        <input type="hidden" name="action" value="deletelinks" />

        <table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1">标题</td>
          <td class="tdrow1">状态</td>
          <td class="tdrow1">类别</td>
          <td class="tdrow1">作者</td>
          <td class="tdrow1" width="75"><input type="checkbox" checkall="group" onclick="javascript: return select_deselectAll (\'deletelinksform\', this, \'group\');">删除</td>
        </tr>';

  while($link = $DB->fetch_array($getlinks))
  {
    echo '<tr>
            <td class="tdrow2">&nbsp;<a href="'.$refreshpage.'&action=displaylinkform&linkid='.$link['linkid'].'&loadwysiwyg=1"><u><input type="hidden" name="editlinkids[]" value="'.$link['linkid'].'" /><span style='.iif($link['activated']=="1","\"color:green;\"","\"color:red; font-weight:bold;\"").'>'.$link['title'].'</span></u></a></td>
			<td class="tdrow3"><select name="onlinestatus[]">
				<option value="1">发布</option>
				<option value="0" ' . iif(!$link['activated'], 'SELECTED', '') . '>隐藏</option>
			</select>
            <td class="tdrow3">';
			PrintSectionSelection('sectionid[]', $link['sectionid']);
			echo '</td>
            <td class="tdrow2">&nbsp;'.$link['author'].'</td>
            <td class="tdrow2">&nbsp;<input type="checkbox" name="linkids[]" value="'.$link['linkid'].'" checkme="group" /></td>
          </tr>';
  }


		$limit = 10;
		$sectionimagesnum = $maxrows['value'];
		$rows = $maxrows['value'] - $start;
		$page_num = ceil($sectionimagesnum / $limit);
		$page_group = floor($start/$limit/8)*8+1;
		$now_page_num = $start/$limit+1;

      if(($start > 0) || ($rows > $limit))
      {

			echo '<tr><td class="tdrow3" colspan="7" align="center" height="48" valign="middle"><table width="100%" cellpadding="0" cellspacing="0" border="0">
              <tr>';

			if($start > 0)
			{
			  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><a href="'.$refreshpage.'&start='.($start - $limit).'&sectionid='.$viewtype.'&action='.$thisaction.'">&lsaquo;&lsaquo; 上一页</a></td>';
			}else{
			  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
			}


			if($page_num - $now_page_num < 10){
				$start_page = $page_num - 9;
				if($start_page<1){
					$start_page = 1;
				}
				$end_page = $page_num + 1;
			}else{
				$start_page = $page_group;
				$end_page = $start_page + 8;
			}

			if($start_page > 1){
				$direct_bar = '<a href="'.$refreshpage.'&start=0&sectionid='.$viewtype.'&action='.$thisaction.'">1</a><a href="'.$refreshpage.'&start='.($start_page-2)*$limit.'&sectionid='.$viewtype.'&action='.$thisaction.'">&lsaquo;&lsaquo;...</a>';
			}

			for ($p=$start_page; $p < $end_page; $p++ ) 
			{	
				if (($start/$limit+1) == $p){
					$direct_bar .= '<STRONG>'.$p.'</STRONG>';
				}else{
					$direct_bar .= '<a href="'.$refreshpage.'&start='.($p-1)*$limit.'&sectionid='.$viewtype.'&action='.$thisaction.'">'.$p.'</a>';
				}
				if($p >= $page_num){
					break;
				}
			}

			if($page_num - $now_page_num >= 10){
				$direct_bar .= '<a href="'.$refreshpage.'&start='.($page_group + 7)*$limit.'&sectionid='.$viewtype.'&action='.$thisaction.'">...&rsaquo;&rsaquo;</a><a href="'.$refreshpage.'&start='.($page_num-1)*$limit.'&sectionid='.$viewtype.'&action='.$thisaction.'">'.$page_num.'</a>';
			}

			echo '<td width="80%" style="text-align:center; vertical-align:middle;" class="pages_nav">'.$direct_bar.'</td>';

			if($rows > $limit)
			{
			  $start += $limit;
			  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><div align="right"><a href="'.$refreshpage.'&start='.$start.'&sectionid='.$viewtype.'&action='.$thisaction.'">下一页 &rsaquo;&rsaquo;</a></div></td>';
			}else{
			  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
			}

			echo '</tr></table>';

	   }


        echo '<tr><td class="tdrow1" colspan="7" align="center"><input type="submit" onclick="return confirm(\'确定保存更新, 并删除选中的链接吗?\');" value=" 保存更新 " /></td></tr></table></form>';

        EndSection();

}



// display the default page

function DisplayDefault($start)     
{
  global $DB;
  global $refreshpage;
  global $moduleid;

  // module settings
  PrintSection('模块设置');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr><td class="tdrow1" colspan="2">详细选项</td></tr>
        <tr><td class="tdrow2" width="70%">显示设置模块详细属性:</td>
            <td class="tdrow3" style="padding-left: 40px;">
            <form method="post" action="'.$refreshpage.'">
            <input type="hidden" name="action" value="displaysettings" />
            <input type="submit" value=" 设置模块 " />
            </form>
            </td></tr>
        </table>';
  EndSection();

  // links - add/manage
  PrintSection('链接管理');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr><td class="tdrow1" colspan="2">添加链接</td></tr>
        <tr><td class="tdrow2" width="70%">添加新链接到网站:</td>
            <td class="tdrow3" style="padding-left: 40px;">
            <form method="post" action="'.$refreshpage.'&action=displaylinkform&loadwysiwyg=1">
            <input type="submit" value=" 添加链接 " />
            </form>
            </td></tr>
        <tr><td class="tdrow1" colspan="2">编辑链接</td></tr>
        <tr><td class="tdrow2" width="70%">查看编辑链接信息:</td>
            <td class="tdrow3" style="padding-left: 40px;">
            <form method="post" action="'.$refreshpage.'">';

  PrintSectionSelectionEx();

  echo '    <input type="hidden" name="action" value="displaylinks" />
            <input type="submit" value=" 编辑链接 " />
            </form>
            </td></tr>
        </table>';
  EndSection();

  // sections - add/manage
  PrintSection('类别管理');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr><td class="tdrow1" colspan="2">添加分类</td></tr>
        <tr>
          <td class="tdrow2" width="70%">添加产品分类, 以便对产品进行分类管理和发布:<br />
          默认产品类别为"产品", 且不能删除. 
          </td>
            <td class="tdrow3" style="padding-left: 40px;">
            <form method="post" action="'.$refreshpage.'">
            <input type="hidden" name="action" value="displaysectionform" />
            <input type="submit" value=" 添加分类 " />
            </form>
            </td></tr>
        <tr><td class="tdrow1" colspan="2">编辑分类</td></tr>
        <tr><td class="tdrow2" width="70%">选择一个产品分类, 然后进行编辑:</td>
            <td class="tdrow3" style="padding-left: 40px;">
            <form method="post" action="'.$refreshpage.'">';

  PrintSectionSelection('sectionid', '');

  echo '    <input type="hidden" name="action" value="displaysectionform" />
            <input type="submit" value=" 编辑分类 " />
            </form>
            </td></tr>
        </table>';
  EndSection();

  DisplayLinks('all', $start);    
}



// ############################# Select Function ############################
if(isset($_GET['start']))   
  $start = $_GET['start'];   
else
  $start = 0;


switch($action)
{
  case 'insertlink':
    InsertLink($sectionid, $activated, $allowsmilies, $showauthor, $author, $title, $url, $description);
  break;

  case 'updatelink':
    UpdateLink($deletelink, $linkid, $sectionid, $activated, $allowsmilies, $showauthor, $author, $title, $url, $description);
  break;

  case 'deletelinks':
    DeleteLinks();
  break;

  case 'deletelink':
    DeleteLink($linkid);
  break;

  case 'insertsection':
    InsertSection($parentid, $activated, $name, $description, $sorting);
  break;

  case 'updatesection':
    UpdateSection($sectionid, $parentid, $activated, $name, $description, $sorting);
  break;

  case 'displaylinkform':
    DisplayLinkForm($linkid);
  break;

  case 'displaysectionform':
    DisplaySectionForm($sectionid);
  break;

  case 'displaylinks':
    DisplayLinks($sectionid, $start);  
  break;

  case 'displaysettings':
    DisplaySettings();
  break;

  default:
    DisplayDefault($start);     
}