<?php
// +---------------------------------------------+
// |     Copyright  2003 - 2005 weenCompany      |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+


define('MOD_ACCESS', true);
define('IN_ADMIN', true);
define('IN_WEENCOMPANY', true);

$rootpath = "./../";

include($rootpath . 'includes/core.php');

PrintHeader('ݿά');

// ######################### Test that the backup directory exists and is writable ##########################

$backupDir = getcwd() . '/backup/';
$backupUrl = $weenurl . ADMIN_DIR.'/backup/';

$errors = array();

if (!is_dir($backupDir))
 $errors[] ='ݿⱸļ ('.$backupDir.') !';

if (!is_writable($backupDir))
 $errors[] = 'ݿⱸļ ('.$backupDir.') д! - Ϊ: 0777';

if (!empty($errors))
{
  PrintErrors($errors, 'ʼ');
}
else
{
  $backupEnabled = true;
}

// ####################### FILE READ/WRITE USING GZIP  ######################

function openFileWrite($filename)
{
  if(function_exists('gzopen'))
  {
    $filename .= '.gz';
    $handle = gzopen($filename, "w9");
  }
  else
  {
    $handle = fopen($filename, "w");
  }
  return $handle;
}

function openFileRead($filename)
{
  if(function_exists('gzopen'))
  {
    $handle = gzopen($filename, "r");
  }
  else
  {
    $handle = fopen($filename, "r");
  }
  return $handle;
}

function writeFileData($handle, $data)
{
  if(function_exists('gzwrite'))
  {
    gzwrite($handle, $data);
  }
  else
  {
    fwrite($handle, $data);
  }
}

function readFileData($handle, $size)
{
  if(function_exists('gzread'))
  {
    $data = gzread($handle, $size);
  }
  else
  {
    $data = fread($handle, $size);
  }
  return $data;
}

function eof($handle)
{
  if(function_exists('gzeof'))
  {
    return gzeof($handle);
  }
  else
  {
    return feof($handle);
  }
}

function closeFile($handle)
{
  if(function_exists('gzclose'))
  {
    gzclose($handle);
  }
  else
  {
    fclose($handle);
  }
}

// ####################### END FILE READ FUNCTIONS ######################

function BackupTable($tablename, $fp)
{
  global $DB;

  if(isset($fp))
  {
    // Get the SQL to create the table
    $createTable = $DB->query_first("SHOW CREATE TABLE `$tablename`");

    // Drop if it exists
    $tableDump = "DROP TABLE IF EXISTS `$tablename`;\n" . $createTable['Create Table'] . ";\n\n";

        writeFileData($fp, $tableDump);

        // get data
        $getRows = $DB->query("SELECT * FROM `$tablename`");
        $fieldCount = $DB->get_num_fields();
        $rowCount = 0;

        while ($row = $DB->fetch_array($getRows))
        {
                $tableDump = "INSERT INTO `$tablename` VALUES(";

                $fieldcounter = -1;
                $firstfield = 1;

                // get each field's data
                while (++$fieldcounter < $fieldCount)
                {
                        if (!$firstfield)
                        {
                                $tableDump .= ', ';
                        }
                        else
                        {
                                $firstfield = 0;
                        }

                        if (!isset($row["$fieldcounter"]))
                        {
                                $tableDump .= 'NULL';
                        }
            elseif ($row["$fieldcounter"] != '')
                        {
                                $tableDump .= '\'' . addslashes($row["$fieldcounter"]) . '\'';
                        }
                        else
                        {
                                $tableDump .= '\'\'';
                        }
                }

                $tableDump .= ");\n";

                writeFileData($fp, $tableDump);
                $rowCount++;
        }

        writeFileData($fp, "\n\n\n");

        $msg = "ӱ '$tablename' б $rowCount .<br/>";
  }
  else
  {
    $msg = "ݿ '$tablename' ʧ!<br/>";
  }

  return $msg;
}

function BackupSingleTable($tablename)
{
  global $backupDir;

  $theverifycode = substr(md5(rand(0,9999)), 6, 12);

  $path = $backupDir . $tablename . '_' . $theverifycode .'_' . date("ymd") . '.sql';

  $fp = openFileWrite($path);

  if($fp)
  {
    $msg = BackupTable($tablename, $fp);
    closeFile($fp);
  }

  $msg .= '<br/>ݿѱݵļ ' . $path . '.gz<br/>';

  return $msg;
}

function EmptyTable($tablename)
{
  global $DB;
  $DB->query("DELETE FROM `$tablename`");
  $msg .= '<br/>ݿ: ' . $tablename . '<br/>';

  return $msg;
}


function BatchBackupTable($tablenames)
{
 global $DB, $backupDir;

  $theverifycode = substr(md5(rand(0,9999)), 6, 12);

  $path = $backupDir . TABLE_PREFIX . $theverifycode . '_' . date("ymd") . '.sql';

  $fp = openFileWrite($path);

  if($fp)
  {
    for($i = 0; $i < count($tablenames); $i++)
    {
      $msg = $msg . BackupTable($tablenames[$i], $fp);
    }
        closeFile($fp);
  }

  $msg .= '<br/>ݿѱݵļ ' . $path . '.gz<br/>';

  return $msg;
}

function ParseQueries($sql, $delimiter)
{
    $matches = array();
        $output = array();

    $queries = explode($delimiter, $sql);
        $sql = "";

        $query_count = count($queries);
        for ($i = 0; $i < $query_count; $i++)
        {
                if (($i != ($query_count - 1)) || (strlen($queries[$i] > 0)))
                {
                        $total_quotes = preg_match_all("/'/", $queries[$i], $matches);
                        $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $queries[$i], $matches);
                        $unescaped_quotes = $total_quotes - $escaped_quotes;

                        if (($unescaped_quotes % 2) == 0)
                        {
                                $output[] = $queries[$i];
                                $queries[$i] = "";
                        }
                        else
                        {
                                $temp = $queries[$i] . $delimiter;
                                $queries[$i] = "";

                                $complete_stmt = false;

                                for ($j = $i + 1; (!$complete_stmt && ($j < $query_count)); $j++)
                                {
                                        $total_quotes = preg_match_all("/'/", $queries[$j], $matches);
                                        $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $queries[$j], $matches);
                                        $unescaped_quotes = $total_quotes - $escaped_quotes;

                                        if (($unescaped_quotes % 2) == 1)
                                        {
                                                $output[] = $temp . $queries[$j];

                                                $queries[$j] = "";
                                                $temp = "";

                                                $complete_stmt = true;
                                                $i = $j;
                                        }
                                        else
                                        {
                                                $temp .= $queries[$j] . $delimiter;
                                                $queries[$j] = "";
                                        }
                                }
                        }
                }
        }

        return $output;
}

function RestoreBackup($filename)
{
  global $DB, $backupDir;

  // Read the file into memory and then execute it
  $fp = openFileRead($backupDir . $filename);

  while (!eof($fp))
  {
    $query .= readFileData($fp, 10000);
  }

  closeFile($fp);

  // Split into discrete statements
  $queries = ParseQueries($query, ';');

  for($i = 0; $i < count($queries); $i++)
  {
          $sql = trim($queries[$i]);

          if(!empty($sql))
          {
      //echo $sql . '<br/>';
      $DB->query($sql);
          }
  }

  PrintRedirect('database.php', 1);
}

function DeleteBackup($filename)
{
  global $DB, $backupDir;

  @unlink($backupDir . $filename);

  PrintRedirect('database.php', 1);
}

// ####################### Display Action Results ######################

function PrintResults($title, $message)
{
  PrintSection($title);
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow2" align="left">
            <font class="ohblue">'.$title .':</font><br/><br/>'. $message . '
          <br/></td>
        </tr>
        </table>';
  EndSection();
}

// ####################### Perform OP on Table ######################

function TableOperation($tablename, $OP)
{
  global $DB;

  $result = $DB->query_first("$OP TABLE `$tablename`");

  return " '" . $tablename . "' : <strong>" . $result['Msg_text'] . "</strong><br/>";
}


function BatchTableOperation($tablenames, $OP)
{
  global $DB;

  $msg = '';

  for($i = 0; $i < count($tablenames); $i++)
  {
    $msg = $msg . TableOperation($tablenames[$i], $OP);
  }

  return $msg;
}

// ######################### Instructions ##########################

function PrintInstructions()
{
  PrintSection('ݿά˵');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow2">
          ͨ˹άweenCompanyϵͳݿ, ˵:<br />
          <strong></strong> - ݿǷڴ.<br />
          <strong>Ż</strong> - ˷ѵĿռ, Żݿ.<br />
          <strong>޸</strong> - ޸ݿеĴ.<br />
          <strong></strong> - '.TABLE_PREFIX.'sessionsڼ¼֤û½, '.TABLE_PREFIX.'vvcڼ¼"֤".<br /><br />
          ʾ:<br/> 
		  1. ڽάʱ, ʱرվ!<br/>
		  2. ڱݿ, ϵͳݷʧʱɽлָ.
          </td>
        </tr>
        </table>';
  EndSection();
}

// ####################### List Backup Files #########################

function DisplayBackups()
{
  global $DB, $backupDir, $backupUrl, $backupEnabled;

  PrintSection('ݿⱸļ');

  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1">ļ</td>
          <td class="tdrow1">С</td>
          <td class="tdrow1"></td>
          <td class="tdrow1" colspan="3" align="center"></td></tr>';
  
  if (is_dir($backupDir))
  {
	  $dir = opendir($backupDir);
	
	  while (false !== ($file = readdir($dir)))
	  {
			  if(strpos(strtolower($file),'.sql') > 0)
			  {
				$stats = stat($backupDir . $file);
	
		  echo '<tr>
				<td class="tdrow3">' . $backupDir . $file . '</td>
				<td class="tdrow3">' . DisplayReadableFilesize($stats['size']) . '</td>
				<td class="tdrow3">' . DisplayDate($stats['mtime']) . '</td>
				<td class="tdrow3"><a href="database.php?dbaction=restorebackup&filename=' . $file . '" onclick="return confirm(\'ȷָļݿ?\n\nע: ݿжӦԭݽɾ.\');">ָ</a></td>';
		  echo '<td class="tdrow3"><a href="' . $backupUrl . $file . '"></a></td>
				<td class="tdrow3"><a href="database.php?dbaction=deletebackup&filename=' . $file . '" onclick="return confirm(\'ȷɾѡıļ?\');">ɾ</a></td>
			  </tr>';
			  }
	  }
	
   }
  echo '</table>';

  EndSection();
}

// ####################### List Database Tables ######################

function DisplayTables()
{
        global $DB, $backupEnabled;

    PrintInstructions();

        echo '<form method="post" action="database.php" name="tables">
      <input type="hidden" name="dbaction" value=""/>';

        PrintSection('ݿб');

        echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
      <tr>
        <td class="tdrow1">ѡ</td>
                <td class="tdrow1"></td>
                <td class="tdrow1">¼</td>
                <td class="tdrow1">ݴС</td>
                <td class="tdrow1">С</td>
                <td class="tdrow1"></td>
                <td class="tdrow1" colspan="5" align="center"></td>
      </tr>';

        $gettables = $DB->query("SHOW TABLES FROM `" . $DB->database . "` LIKE '" . substr(TABLE_PREFIX, 0, -1) ."\_%'");

        while($table = $DB->fetch_array($gettables))
        {
                $tableinfo = $DB->query_first("SHOW TABLE STATUS LIKE '" . $table[0] . "'");

                echo '<tr>
        <td class="tdrow3"><input type="checkbox" name="tablenames[]" value="' . $tableinfo['Name'] . '" checkme="group" /></td>
        <td class="tdrow3">' . $tableinfo['Name'] . '</td>
                <td class="tdrow3">' . $tableinfo['Rows'] . '</td>
                <td class="tdrow3">' . DisplayReadableFilesize($tableinfo['Data_length']) . '</td>
                <td class="tdrow3">' . DisplayReadableFilesize($tableinfo['Index_length']) . '</td>
                <td class="tdrow3">' . iif($tableinfo['Data_free'] > 0, '<b>', '') . DisplayReadableFilesize($tableinfo['Data_free']) . iif($tableinfo['Data_free'] > 0, '</b>', '') .  '</td>
                <td class="tdrow3"><a href="database.php?dbaction=checktable&tablename=' . $tableinfo['Name'] . '"></a></td>
                <td class="tdrow3"><a href="database.php?dbaction=optimizetable&tablename=' . $tableinfo['Name'] . '">Ż</a></td>
                <td class="tdrow3"><a href="database.php?dbaction=repairtable&tablename=' . $tableinfo['Name'] . '">޸</a></td>
                <td class="tdrow3">' . iif($backupEnabled, '<a href="database.php?dbaction=backuptable&tablename=' . $tableinfo['Name'] . '"></a>', '') . '</td>';
				
				if($tableinfo['Name'] == TABLE_PREFIX . 'sessions')
				{
				   echo '<td class="tdrow3"><a href="database.php?dbaction=emptytable&tablename=' . $tableinfo['Name'] . '" onclick="return confirm(\'ȷմݿ?\');"></a></td>';
				}
				else if($tableinfo['Name'] == TABLE_PREFIX . 'vvc')
				{
				   echo '<td class="tdrow3"><a href="database.php?dbaction=emptytable&tablename=' . $tableinfo['Name'] . '" onclick="return confirm(\'ȷմݿ?\');"></a></td>';
				}
				else
				{
				   echo '<td class="tdrow3">-</td>';
				}
				
      echo '</tr>';
        }

        echo '<tr>
        <td class="tdrow1" colspan="6"><input type="checkbox" checkall="group" onclick="javascript: return select_deselectAll (\'tables\', this, \'group\');">&nbsp;ȫѡ</td>
                <td class="tdrow1"><input type="submit" value="" onclick="document.forms[\'tables\'].dbaction.value = \'checkall\';"/></td>
                <td class="tdrow1"><input type="submit" value="Ż" onclick="document.forms[\'tables\'].dbaction.value = \'optimizeall\';"/></td>
                <td class="tdrow1"><input type="submit" value="޸" onclick="document.forms[\'tables\'].dbaction.value = \'repairall\';"/></td>
                <td class="tdrow1"><input type="submit" value="" onclick="document.forms[\'tables\'].dbaction.value = \'backupall\';" ' . iif($backupEnabled, '', 'disabled') . '/></td>
				<td class="tdrow1">-&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
      </tr>
    </table>
    </form>';

        EndSection();
		
        DisplayBackups();

        PrintFooter();
}

// get the value of $action
$action = isset($_POST['dbaction']) ? $_POST['dbaction'] : (isset($_GET['dbaction']) ? $_GET['dbaction'] : '');
$tablename = isset($_POST['tablename']) ? $_POST['tablename'] : (isset($_GET['tablename']) ? $_GET['tablename'] : '');
$filename = isset($_POST['filename']) ? $_POST['filename'] : (isset($_GET['filename']) ? $_GET['filename'] : '');

switch ($action)
{
case 'checktable':
  PrintResults('ݿ', TableOperation($tablename, 'CHECK'));
  break;
case 'checkall':
  PrintResults('ݿ', BatchTableOperation($_POST['tablenames'], 'CHECK'));
  break;
case 'optimizetable':
  PrintResults('Żݿ', TableOperation($tablename, 'OPTIMIZE'));
  break;
case 'optimizeall':
  PrintResults('Żݿ',BatchTableOperation($_POST['tablenames'], 'OPTIMIZE'));
  break;
case 'repairtable':
  PrintResults('޸ݿ',TableOperation($tablename, 'REPAIR'));
  break;
case 'repairall':
  PrintResults('޸ݿ',BatchTableOperation($_POST['tablenames'], 'REPAIR'));
  break;
case 'backuptable':
  PrintResults('ݿ',BackupSingleTable($tablename));
  break;
case 'backupall':
  PrintResults('ݿ', BatchBackupTable($_POST['tablenames']));
  break;
case 'emptytable':
  PrintResults('ݿ', EmptyTable($tablename));
  break;
case 'restorebackup':
  RestoreBackup($filename);
  break;
case 'deletebackup':
  DeleteBackup($filename);
  break;
}

DisplayTables();

?>