
(function() {
	tinymce.PluginManager.requireLangPack('imagemanager');

	tinymce.create('tinymce.plugins.ImagemanagerPlugin', {
		init : function(ed, url) {
			ed.addCommand('mceImagemanager', function() {
				ed.windowManager.open({
					file : url + '/imagemanager.php',
					width : 800 + parseInt(ed.getLang('imagemanager.delta_width', 0)),
					height : 600 + parseInt(ed.getLang('imagemanager.delta_height', 0)),
					scrollbars:"yes",
					inline : 1
				}, {
					plugin_url : url, 
					some_custom_arg : 'custom arg' 
				});
			});

			ed.addButton('imagemanager', {
				title : 'imagemanager.desc',
				cmd : 'mceImagemanager',
				image : url + '/img/imagemanager.gif'
			});

			ed.onNodeChange.add(function(ed, cm, n) {
				cm.setActive('imagemanager', n.nodeName == 'IMG');
			});
		},

		createControl : function(n, cm) {
			return null;
		},

		getInfo : function() {
			return {
				longname : 'Imagemanager plugin',
				author : 'weenCompany',
				authorurl : 'http://www.weentech.com',
				infourl : 'http://www.weentech.com',
				version : "3.1.0.1"
			};
		}
	});

	tinymce.PluginManager.add('imagemanager', tinymce.plugins.ImagemanagerPlugin);
})();