<?php
// +---------------------------------------------+
// |     Copyright 2008-2018 weenCompany         |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

if(!defined('IN_WEENCOMPANY'))
  die('Ƿ!');

// get the value of $m2_action
$m2_action = isset($_POST['m2_action']) ? $_POST['m2_action'] : (isset($_GET['m2_action']) ? $_GET['m2_action'] : 'displaynews');

// get module language
$m2_language = GetLanguage(2);

// article bitfield settings
$m2_articlebitfield = array('useglobalsettings'       => 1,
                                                        'displayonline'           => 2,
                                                        'displaytitle'            => 4,
                                                        'displayauthor'           => 8,
                                                        'displaycreateddate'      => 16,
                                                        'displayupdateddate'      => 32,
                                                        'displayprintarticlelink' => 64,
                                                        'displayemailarticlelink' => 128,
                                                        'displaydescription'      => 256,
                                                        'displaysmilies'          => 512,
                                                        'displaycomments'         => 1024);

// get global article settings
$getsettings = $DB->query("SELECT title, description, value FROM " . TABLE_PREFIX . "modulesettings WHERE moduleid = 2");
while($setting = $DB->fetch_array($getsettings))
{
        // Some settings have titles, some have descriptions. Go figure
        $title = strlen($setting['title']) > 0 ? $setting['title'] : $setting['description'];
        $m2_settings[$title] = $setting['value'];
}


// ############################### SEND ARTICLE ################################

function m2_SendEmail($articleid)
{
        global $DB, $categoryid, $weenurl, $m2_language, $m2_settings, $sdlanguage, $mainsettings, $rootpath;

        if($m2_settings['ƹ'] == 1)
        {
                if($m2_settings['ʼ֤'] == 1)
                {
                        $vvcid         = $_POST['m2_vvcid'];
                        $code        = $_POST['m2_verifycode'];

                        if(!ValidVisualVerifyCode($vvcid, $code))
                        {
                                $errors[] = $sdlanguage['incorrect_vvc_code'];
                        }else{
								DeleteVisualVerifyCode($vvcid);
						}
                }

                $useremail    = $_POST['m2_emailfrom'];
                $emailto      = $_POST['m2_emailto'];
                $emailcomment = $_POST['m2_emailcomment'];

                // Strip \r\n to prevent injection attacks
                $useremail = preg_replace("/\r/", "", $useremail);
                $useremail = preg_replace("/\n/", "", $useremail);

                $emailto = preg_replace("/\r/", "", $emailto);
                $emailto = preg_replace("/\n/", "", $emailto);

                // obtain emails
                $getemails = str_replace(',', ' ', $emailto);                  // get rid of commas
                $getemails = preg_replace("/[[:space:]]+/", " ", $getemails);   // get rid of extra spaces
                $getemails = trim($getemails);                                 // then trim
                $emails    = explode(" ", $getemails);

                // setup some vars
                $invalidemails = 0;

                // check if emails are real
                for($i = 0; $i < count($emails); $i++)
                {
                        if(!isEmail($emails[$i])){$invalidemails = 1;}
                }

                if($invalidemails == 1)
                {
                        $errors[] = $m2_language['invalid_email'];
                }
                else
                {
						if(!isEmail($useremail)){$errors[] = $m2_language['invalid_email'];}
                }

                // check if article exists/online
                if(!$article = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "m2_news WHERE articleid = '$articleid'
                                   AND categoryid = '$categoryid' AND (settings & 2) AND (datestart = 0 OR datestart < '" . time() . "')
                                   AND (dateend   = 0 OR dateend   > '" . time() . "')") )

                {
                        echo $m2_language['article_offline'];
                        return;
                }


                // send email if no errors
                if(!isset($errors))
                {
						require_once($rootpath . 'includes/mail/class.phpmailer.php');
						$mail = new PHPMailer();

						if($mainsettings['email_use_smtp'] == '1')
							$mail->IsSMTP();
						else
							$mail->IsMail();

						$mail->Host = $mainsettings['email_smtp_host'];
						$mail->Port = $mainsettings['email_smtp_port'];

						if( $mainsettings['email_smtp_require_auth'] == "1" ) {
							$mail->SMTPAuth = true;
							$mail->Username = $mainsettings['email_smtp_user'];
							$mail->Password = $mainsettings['email_smtp_pass'];
						}

						$mail->From      =  $useremail;
						$mail->FromName      =  $useremail;
						$mail->AddReplyTo($useremail,$useremail);   
						$mail->Sender      =  $mainsettings['email_smtp_from'];

						for($i = 0; $i < count($emails); $i++)
						{
							$mail->AddAddress($emails[$i]);
						}

						$thisarticleurl =$weenurl . "index.php?lang=$sitedefaultlang&categoryid=$categoryid&m2_articleid=$articleid&moduleid=".substr('m2_',1,-1);

                        $message = '<a href="' . $thisarticleurl . '" target="_blank">' . $thisarticleurl. "</a>"  . EMAIL_CRLF  . EMAIL_CRLF . $emailcomment;

						$mail->Subject   = $article['title'];
						$mail->Body      = nl2br($message);

                        if($mail->Send())
                        {
                                echo $m2_language['email_sent'] . '<br />' . $article['title'] . '<br /><br /><a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_articleid=' . $articleid . '&moduleid='.substr('m2_',1,-1)) . '">' . $m2_language['go_back'] . '<a>';
                        }
                        else
                        {
                                echo $m2_language['email_not_sent'];
                        }

                }
                else
                {
                        foreach($errors as $key=>$value)
                        {
                                echo $value . '<br /><br />';
                        }

                        m2_EmailArticle($articleid);
                }
        }

}


// ############################ EMAIL ARTICLE FORM #############################

function m2_EmailArticle($articleid)
{
        global $DB, $categoryid, $inputsize, $m2_language, $m2_settings, $sdlanguage;

        if($m2_settings['ƹ'] == 1)
        {
                // check if article exists/online
                if(!$article = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "m2_news WHERE articleid = '$articleid'
                                   AND categoryid = '$categoryid' AND (settings & 2) AND (datestart = 0 OR datestart < '" . time() . "')
                                   AND (dateend   = 0 OR dateend   > '" . time() . "')") )

                {
                        echo $m2_language['article_offline'];
                        return;
                }

                echo '<b>' . $article['title'] . '</b><br /><br /><form method="post" action="' . RewriteLink('index.php?categoryid=' . $categoryid. '&m2_articleid=' . $articleid . '&m2_action=sendemail&moduleid='.substr('m2_',1,-1)) . '">

        ' . $m2_language['enter_recipient_email'] . '<br />
        <input type="text" name="m2_emailto" value="' . $_POST['m2_emailto'] . '" size="'.$inputsize.'" /><br />
        ' . $m2_language['separate_with_commas'] . '<br /><br />

        ' . $m2_language['enter_your_email'] . '<br />
        <input type="text" name="m2_emailfrom" size="'.$inputsize.'" value="' . $_POST['m2_emailfrom'] . '" /><br /><br />

        ' . $m2_language['enter_comment'] . '<br />
        <textarea name="m2_emailcomment" cols="'.$inputsize.'" rows="5">' . $_POST['m2_emailcomment'] . '</textarea><br /><br />';

                if($m2_settings['ʼ֤'])
                {
                        $vvcid = CreateVisualVerifyCode();
                        echo '<input type="hidden" name="m2_vvcid" value="' . $vvcid . '"/>';
                        echo '<img src="includes/vvc.php?vvcid=' . $vvcid . '"/><br/><br/>
                                 ' . $sdlanguage['enter_verify_code'] . '<br />
                              <input type="text" size="'.$inputsize.'" name="m2_verifycode"/><br/><br/>';
                }

        echo '<input type="submit" value="' . strip_tags($m2_language['send_email']) . '" />
              </form>';
        }
}



// ######################### INSERT ARTICLE INTO DB  ###########################

function m2_InsertArticle()
{
        global $DB, $categoryid, $m2_language, $m2_settings, $mainsettings, $rootpath;
		if($m2_settings['֤'] == 1)
		{
				$vvcid     = $_POST['m2_vvcid'];
				$code      = $_POST['m2_verifycode'];

				if(!ValidVisualVerifyCode($vvcid, $code))
				{
                        $errors .= $sdlanguage['incorrect_vvc_code'] . '<br />';
				}
		}
        $author      = $_POST['m2_author'];
        $title       = $_POST['m2_title'];
        $description = nl2br($_POST['m2_description']);
        $article     = nl2br($_POST['m2_article']);

        if(strlen($author) == 0)
        {
                $errors .= $m2_language['enter_name'] . '<br />';
        }

        if(strlen($title) == 0)
        {
                $errors .= $m2_language['enter_title'] . '<br />';
        }

        if(strlen($article) == 0)
        {
                $errors .= $m2_language['enter_article'] . '<br />';
        }

        if($samearticle = $DB->query_first("SELECT articleid FROM " . TABLE_PREFIX . "m2_news WHERE author = '$author'
						   AND title = '$title' AND description = '$description' AND article = '$article'") )

		{
                $errors .= '<font color=red><b>Sorry! this is a same article.</b></font>' . '<br />';
		}

       // if no errors insert news, else print error and show submit form
        if(!isset($errors))
        {
                $articlesettings = iif($m2_settings['Զ'] == 1, 3, 1);

                $DB->query("INSERT INTO " . TABLE_PREFIX . "m2_news (categoryid, settings, datecreated, author, title, metadescription, metakeywords, description, article)
                VALUES ($categoryid, $articlesettings, '" . time() . "', '$author', '$title', '', '', '$description', '$article')");

                echo $m2_language['article_submitted'];

                $email = $m2_settings['ʼ֪ͨ'];

                if(strlen($email) > 0)
                {
                        // obtain emails
                        $getemails = str_replace(',', ' ', $email);                    // get rid of commas
                        $getemails = preg_replace("/[[:space:]]+/", " ", $getemails);   // get rid of extra spaces
                        $getemails = trim($getemails);                                 // then trim
                        $emails    = explode(" ", $getemails);

                        $message  = $m2_language['notify_email_message'] . EMAIL_CRLF . EMAIL_CRLF;
                        $message .= $m2_language['notify_email_author'] . ' - ' . $author . EMAIL_CRLF;
                        $message .= $m2_language['notify_email_title'] . ' - ' . $title . EMAIL_CRLF;

						require_once($rootpath . 'includes/mail/class.phpmailer.php');

						$mail = new PHPMailer();

						if($mainsettings['email_use_smtp'] == '1')
							$mail->IsSMTP();
						else
							$mail->IsMail();


						$mail->Host = $mainsettings['email_smtp_host'];
						$mail->Port = $mainsettings['email_smtp_port'];

						if( $mainsettings['email_smtp_require_auth'] == "1" ) {
							$mail->SMTPAuth = true;
							$mail->Username = $mainsettings['email_smtp_user'];
							$mail->Password = $mainsettings['email_smtp_pass'];
						}

						$mail->From      =  $mainsettings['technicalemail'];
						$mail->FromName      =  $mainsettings['copyrighttext'];
						$mail->AddReplyTo($mainsettings['technicalemail'], $mainsettings['copyrighttext']);   
						$mail->Sender      =  $mainsettings['email_smtp_from'];

						for($i = 0; $i < count($emails); $i++)
						{
							$mail->AddAddress($emails[$i]);
						}
						
						$mail->Subject   = $m2_language['notify_email_subject'];
						$mail->Body      = nl2br($message);

						$mail->Send();

                }
        }
        else
        {
                echo '<b>' . $errors . '</b><br /><br />';
                m2_SubmitArticle($author, $title, $description, $article);
        }

}



// ########################### SUBMIT ARTICLE FORM  ############################

function m2_SubmitArticle($author, $title, $description, $article)
{
        global $categoryid, $userinfo, $inputsize, $m2_language, $m2_settings, $sdlanguage;

        echo '<form method="post" action="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_action=insertarticle') . '">';

        if($userinfo['loggedin'])
        {
                echo '<input type="hidden" name="m2_author" value="' . $userinfo['username'] . '" />
          <table width="100%" border="0" cellpadding="0" cellspacing="0">';
        }
        else
        {
                echo '<table width="100%" border="0" cellpadding="0" cellspacing="0">
           <tr>
            <td width="25%" valign="top">' . $m2_language['author'] . '</td>
            <td width="75%" valign="top" style="padding-left: 8px; padding-bottom: 6px;">
              <input type="text" name="m2_author" value="'.$author.'" size="'.$inputsize.'" maxlength="64" />
            </td>
          </tr>';
        }

        echo '<tr>
          <td width="25%" valign="top">' . $m2_language['title'] . '</td>
          <td width="75%" valign="top" style="padding-left: 8px; padding-bottom: 6px;">
            <input type="text" name="m2_title" value="'.$title.'" size="'.$inputsize.'" maxlength="128" />
          </td>
        </tr>
        <tr>
          <td width="25%" valign="top">' . $m2_language['description'] . '</td>
          <td width="75%" valign="top" style="padding-left: 8px; padding-bottom: 6px;">
            <textarea name="m2_description" cols="'.$inputsize.'" rows="5">'.$description.'</textarea>
          </td>
        </tr>
        <tr>
          <td width="25%" valign="top">' . $m2_language['article'] . '</td>
          <td width="75%" valign="top" style="padding-left: 8px; padding-bottom: 6px;">
            <textarea name="m2_article" cols="'.$inputsize.'" rows="25">'.$article.'</textarea>
          </td>
        </tr>';

  if($m2_settings['֤'])
  {
    $vvcid = CreateVisualVerifyCode();

    echo '<tr>
    <td width="25%" valign="top"></td>
    <td width="75%" valign="top" style="padding-left: 8px; padding-bottom: 6px;"><input type="hidden" name="m2_vvcid" value="' . $vvcid . '"/>
        <img src="includes/vvc.php?vvcid=' . $vvcid . '"/></td>
    </tr>
    <tr>
    <td width="100%" valign="top" colspan="2" style="padding-left: 8px; padding-bottom: 6px;">' . $sdlanguage['enter_verify_code'] . '</td>
    </tr>
    <tr>
    <td width="25%" valign="top"></td>
    <td width="75%" valign="top" style="padding-left: 8px; padding-bottom: 6px;"><input type="text" size="'.$inputsize.'" name="m2_verifycode"/></td>
    </tr>';
  }

  echo '<tr>
          <td width="25%" valign="top"></td>
          <td width="75%" valign="top" style="padding-left: 8px; padding-bottom: 6px;">
            <input type="hidden" name="m2_action" value="insertarticle" />
            <input type="submit" value="' . strip_tags($m2_language['submit_article']) . '" />
          </td>
        </tr>
        </table>
        </form>';
}



// ############################## DISPLAY ARTICLE ##############################

function m2_DisplayArticle($article)
{
        global $DB, $weenurl, $categoryid, $userinfo, $m2_articlebitfield, $m2_language, $m2_settings;

        // check which page of the article we are on
        // this variable needs to be created before displaying the article becuase it's used
        // in the description printing area
        $currentpage = (isset($_GET['m2_page']) AND preg_match("/^[0-9]+$/", $_GET['m2_page'])) ? $_GET['m2_page'] : 1;

        // to prevent blank lines from showing, create a variable that will determine if weed need to break
        $displaylinebreaks = false;

        // ʾ?
        if($article['settings'] & $m2_articlebitfield['displaytitle'])
        {
			if(!strlen($article['description']) OR isset($_GET['m2_articleid']))
			{
                echo '<b>' . $article['title'] . '</b><br />';
                $displaylinebreaks = true;
			}
			else
			{
                echo '<b><a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_articleid=' . $article['articleid'].'&moduleid='.substr('m2_',1,-1)) . '">' . $article['title'] . '</a></b><br />';
                $displaylinebreaks = true;
			}
        }

        // display author?
        if($article['settings'] & $m2_articlebitfield['displayauthor'])
        {
                echo $m2_language['by'] . ' ' . $article['author'] . '<br />';
                $displaylinebreaks = true;
        }

        // display published date?
        if($article['settings'] & $m2_articlebitfield['displaycreateddate'])
        {
                echo $m2_language['published'] . ' ' . iif($article['datestart'] != 0, DisplayDate($article['datestart']), DisplayDate($article['datecreated'])) . '<br />';
                $displaylinebreaks = true;
        }

        // ʾ?
        if( ($article['settings'] & $m2_articlebitfield['displayupdateddate']) AND ($article['dateupdated'] != 0) )
        {
                echo $m2_language['updated'] . ' ' . DisplayDate($article['dateupdated']) . '<br />';
                $displaylinebreaks = true;
        }

        // ʾӡ?
        if($article['settings'] & $m2_articlebitfield['displayprintarticlelink'])
        {
                echo '<img alt="" src="' . $weenurl . 'modules/m2_news/print.gif" /> <a href="' . $weenurl . 'modules/m2_news/printarticle.php?m2_articleid=' . $article['articleid'] . '" target="_blank">' . $m2_language['print'] . '</a>&nbsp;&nbsp;&nbsp;' . iif(!($article['settings'] & $m2_articlebitfield['displayemailarticlelink']), '<br />');
                $displaylinebreaks = true;
        }

        // ʾʼ?
        if(($article['settings'] & $m2_articlebitfield['displayemailarticlelink']) && $m2_settings['ƹ'] == 1)
        {
                echo '<img alt="" src="' . $weenurl . 'modules/m2_news/email.gif" /> <a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_articleid=' . $article['articleid'] . '&m2_action=emailarticle&moduleid='.substr('m2_',1,-1)) . '">' . $m2_language['email'] . '</a><br />';
                $displaylinebreaks = true;
        }

        if($displaylinebreaks)
        {
                echo '<br />';
        }

        // display description?
        if(strlen($article['description']))
        {
                if(!isset($_GET['m2_articleid']))
                {
                        echo iif($article['settings'] & $m2_articlebitfield['displaysmilies'], AddSmilies($article['description']), $article['description']);
                }
                else if( ($article['settings'] & $m2_articlebitfield['displaydescription']) AND $currentpage == 1)
                {
                        echo iif($article['settings'] & $m2_articlebitfield['displaysmilies'], AddSmilies($article['description']), $article['description']);
                }
        }

        // display article?
        if(!strlen($article['description']) OR isset($_GET['m2_articleid']))
        {
                if(strlen($article['article']))
                {
                        // find out how many pages are in this article
                        $articlepages = preg_split('/{(pagebreak)\s*(.*?)}/i', $article['article']);

                        // a few more checks...
                        if($currentpage == 0 OR $currentpage > count($articlepages))
                        {
                                $currentpage = 1;
                        }

                        // add smilies to article?
                        if($article['settings'] & $m2_articlebitfield['displaysmilies'])
                        {
                                $articlepages[$currentpage - 1] = AddSmilies($articlepages[$currentpage - 1]);
                        }

                        echo preg_replace('#(\A[\s]*<br[^>]*>[\s]*|'                                      // remove <br/> at beginning of the string
                        .'<br[^>]*>\s*(?=(?:\{pagebreak\}))|'                           // remove <br/> before {pagebreak}
                        .'(?<=(?:\{pagebreak\}))\s*<br[^>]*>|'                          // remove <br/> after {pagebreak}
                        .'<br[^>]*>[\s]*\Z)#is', '', $articlepages[$currentpage - 1]);  // remove <br/> at end of string

                        if(count($articlepages) > 1)
                        {
                                echo '<br /><br />
              <center>';

                                // display previous page link?
                                if($currentpage > 1)
                                {
                                        echo '<a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_articleid=' . $article['articleid'].'&moduleid='.substr('m2_',1,-1). '&m2_page=' . ($currentpage - 1)) . '">' . $m2_language['previous_page'] . '</a> | ';
                                }

                                echo $m2_language['page'] . ' ' . $currentpage . ' ' . $m2_language['of'] . ' ' . count($articlepages);

                                if(count($articlepages) > $currentpage)
                                {
                                        echo ' | <a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_articleid=' . $article['articleid'].'&moduleid='.substr('m2_',1,-1). '&m2_page=' . ($currentpage + 1)) . '">' . $m2_language['next_page'] . '</a>';
                                }

                                echo '</center>';
                        }

                        // update the views but only on the first page
                        if($currentpage == 1)
                        {
                                $DB->query("UPDATE " . TABLE_PREFIX . "m2_news SET views=views+1 WHERE articleid = '" . $article['articleid'] . "'");
                        }
                }
        }
        else
        {
                // display link to article
                echo ' <a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_articleid=' . $article['articleid'].'&moduleid='.substr('m2_',1,-1)) . '">' . $m2_language['read_more'] . '</a>';
        }

        // display submit news link?
        if(in_array(2, $userinfo['modulesubmitids']))
        {
                echo '<br /><br /><a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_action=submitarticle') . '">' . $m2_language['submit_article'] . '</a>';
        }

        // ʾû?
        if($article['settings'] & $m2_articlebitfield['displaycomments'])
        {
                echo iif(in_array(2, $userinfo['modulesubmitids']), ' - ', '<br /><br />');

                // if m2_start is set, then it has already been confirmed to be an int (checked below)
                Comments(2, $article['articleid'], 'index.php?categoryid=' . $categoryid . iif(isset($_GET['m2_start']), '&m2_start=' . $_GET['m2_start']) . iif(isset($_GET['m2_articleid']), '&m2_articleid=' . $_GET['m2_articleid']) . iif(isset($_GET['moduleid']), '&moduleid=' . $_GET['moduleid']));
        }
}



// ############################## DISPLAY ARTICLES TABLE ##############################

function m2_DisplayArticleTable($article, $number)
{
        global $m2_articlebitfield, $categoryid;

		echo $number . '. <a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_articleid=' . $article['articleid'].'&moduleid='.substr('m2_',1,-1)) . '">' . $article['title'] . '</a>';

        if($article['settings'] & $m2_articlebitfield['displaycreateddate'])
        {
			echo ' <span style="color:#A0A0A0; font-size:10px;">('. iif($article['datestart'] != 0, DisplayDate($article['datestart']), DisplayDate($article['datecreated'])) . ')</span>';
        }


        if(strlen($article['description']))
        {
			echo '<br>'.$article['description'];
        }

}


// ############################### DISPLAY NEWS  ###############################

function m2_DisplayNews()
{
        global $DB, $categoryid, $m2_articlebitfield, $m2_language, $m2_settings;

        // create global settings
        $globalsettings = 0;
        $globalsettings += $m2_settings['ʾ']                      == 1 ? 4    : 0;
        $globalsettings += $m2_settings['ʾ']                     == 1 ? 8    : 0;
        $globalsettings += $m2_settings['ʾ']              == 1 ? 16   : 0;
        $globalsettings += $m2_settings['ʾ']               == 1 ? 32   : 0;
        $globalsettings += $m2_settings['ʾӡ']         == 1 ? 64   : 0;
        $globalsettings += $m2_settings['ʾʼ']         == 1 ? 128  : 0;
        $globalsettings += $m2_settings['Ҫʾϸ'] == 1 ? 256  : 0;
        $globalsettings += $m2_settings['ʾ']              == 1 ? 512  : 0;
        $globalsettings += $m2_settings['ʾû']              == 1 ? 1024 : 0;

        // display specific article?
        if(isset($_GET['m2_articleid']))
        {
                if($article = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "m2_news WHERE articleid = '" . $_GET['m2_articleid'] . "'
                                    AND categoryid = '$categoryid' AND (settings & 2) AND (datestart = 0 OR datestart < '" . time() . "')
                                    AND (dateend   = 0 OR dateend   > '" . time() . "')") )
                {
                        // use global settings for this article?
                        if($article['settings'] & $m2_articlebitfield['useglobalsettings'])
                        {
                                $article['settings'] = $globalsettings;
                        }

                        // display the article
                        m2_DisplayArticle($article);
                }
                else
                {
                        echo $m2_language['article_offline'];
                        return;
                }
        }
        else
        {
                // display all articles

                // find the limit start
                $start = (isset($_GET['m2_start']) AND preg_match("/^[0-9]+$/", $_GET['m2_start'])) ? $_GET['m2_start'] : 0;

                // get category settings, if none then resort to default
                if($categorysettings = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "m2_settings WHERE categoryid = '$categoryid'"))
                {
                        $limit         = $categorysettings['maxarticles'];
                        $order         = $categorysettings['sorting'];
                        $multiplepages = $categorysettings['multiplepages'];
                }
                else
                {
                        $limit         = 10;
                        $order         = 'IF ( dateupdated = 0, datecreated, dateupdated ) DESC';
                        $multiplepages = 1;
                }

                $getarticles = $DB->query("SELECT * FROM " . TABLE_PREFIX . "m2_news WHERE categoryid = '$categoryid' AND (settings & 2)
                               AND (datestart = 0 OR datestart < '" . time() . "')
                               AND (dateend   = 0 OR dateend   > '" . time() . "')
                               ORDER BY " . $order . " LIMIT $start, " . ($limit + 1) . "");

                $rows = $DB->get_num_rows($getarticles);

                for($i = 0; $i < $rows AND $i < $limit; $i++)
                {
                        $article = $DB->fetch_array($getarticles);

                        // use global settings for this article?
                        if($article['settings'] & $m2_articlebitfield['useglobalsettings'])
                        {
                                $article['settings'] = $globalsettings;
                        }

                        // display article
						if($m2_settings['бʾ']){
							m2_DisplayArticleTable($article, $start + $i + 1);
						}else{
							m2_DisplayArticle($article);
						}

                        // display break
                        if( (($i + 1) < $rows) AND (($i + 1) < $limit) )
                        {
							if($m2_settings['бʾ']){
                                echo '<br /><hr size="1" noshade="noshade" color="#C5C5C5" />';
							}else{
                                echo '<br /><br /><hr size="1" noshade="noshade" /><br />';
							}
                        }
                }

                // display multiple pages?
                if($multiplepages)
                {
                     
						 // get all section articles number
						$getsectionarticles = $DB->query("SELECT articleid FROM " . TABLE_PREFIX . "m2_news WHERE categoryid = '$categoryid' AND (settings & 2)
									   AND (datestart = 0 OR datestart < '" . time() . "')
									   AND (dateend   = 0 OR dateend   > '" . time() . "')");
					
						$sectionarticlesnum = $DB->get_num_rows($getsectionarticles);
							 
					 
					    if($start > 0 OR $rows > $limit)
                        {
                                echo '<br /><br /><hr size="1" noshade="noshade" />
										<style type="text/css">
										<!--
										.pages_nav a {BACKGROUND: #cad9ea; PADDING-TOP: 5px; PADDING-BOTTOM: 5px; PADDING-RIGHT: 7px; PADDING-LEFT: 7px;  LINE-HEIGHT: 24px;}
										.pages_nav STRONG{FONT-WEIGHT: bold; BACKGROUND: #BBBBBB; COLOR: #CC0000;PADDING-TOP: 5px; PADDING-BOTTOM: 5px; PADDING-RIGHT: 7px; PADDING-LEFT: 7px;LINE-HEIGHT: 24px;}
										-->
										</style>
									  <table width="100%" cellpadding="0" cellspacing="0" border="0">
									  <tr>';

								if($start > 0)
								{
								  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_start=' . ($start - $limit)) . '">' . $m2_language['previous'] . '</a></td>';
								}else{
								  echo '<td style="padding-left: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
								}
								
								
								$page_num = ceil($sectionarticlesnum / $limit);
								$page_group = floor($start/$limit/8)*8+1;
								$now_page_num = $start/$limit+1;

								if($page_num - $now_page_num < 10){
									$start_page = $page_num - 9;
									if($start_page<1){
										$start_page = 1;
									}
									$end_page = $page_num + 1;
								}else{
									$start_page = $page_group;
									$end_page = $start_page + 8;
								}

								if($start_page > 1){
									$direct_bar = '<a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_start=0') . '">1</a><a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_start=' . ($start_page-2)*$limit) . '">&lsaquo;&lsaquo;...</a>';
								}

								for ($p=$start_page; $p < $end_page; $p++ ) 
								{	
									if (($start/$limit+1) == $p){
										$direct_bar .= '<STRONG>'.$p.'</STRONG>';
									}else{
										$direct_bar .= '<a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_start=' . ($p-1)*$limit) . '">'.$p.'</a>';
									}


									if($p >= $page_num){
										break;
									}

								}
								
								if($page_num - $now_page_num >= 10){
									$direct_bar .= '<a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_start=' . (($page_group + 7)*$limit)) . '">...&rsaquo;&rsaquo;</a><a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_start=' .($page_num-1)*$limit) . '">'.$page_num.'</a>';
								}

								echo '<td width="80%" style="text-align:center; vertical-align:middle;" class="pages_nav">'.$direct_bar.'</td>';

 
								if($rows > $limit)
								{
								  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap"><div align="right"><a href="' . RewriteLink('index.php?categoryid=' . $categoryid . '&m2_start=' . ($start + $limit)) . '">' . $m2_language['next'] . '</a></div></td>';
								}else{
								  echo '<td style="padding-right: 3px; vertical-align:middle;" width="10%" nowrap="nowrap">&nbsp;</td>';
								}
 
                                echo '</tr></table>';
                        }
                }
        }

}



// ######################### START CALLING FUNCTIONS  ##########################

// $m2_action is created at the top of this page

// first do a security check on articleid:
if(isset($_GET['m2_articleid']) AND !preg_match("/^[0-9]+$/", $_GET['m2_articleid']))
{
        unset($_GET['m2_articleid']);
}
if(isset($_GET['moduleid']) AND !preg_match("/^[0-9]+$/", $_GET['moduleid']))
{
        unset($_GET['moduleid']);
}

if($m2_action == 'insertarticle' AND in_array(2, $userinfo['modulesubmitids']))
{
        m2_InsertArticle();
}
else if($m2_action == 'submitarticle' AND in_array(2, $userinfo['modulesubmitids']))
{
        m2_SubmitArticle(NULL, NULL, NULL, NULL);
}
else if(isset($_GET['m2_articleid']) AND $m2_action == 'emailarticle')
{
        m2_EmailArticle($_GET['m2_articleid']);
}
else if(isset($_GET['m2_articleid']) AND $m2_action == 'sendemail')
{
        m2_SendEmail($_GET['m2_articleid']);
}
else
{
        m2_DisplayNews();
}



// ############################## UNSET VARIABLES ##############################

unset($m2_action, $m2_language, $m2_articlebitfield, $m2_settings);

?>