<?php
// +---------------------------------------------+
// |     Copyright 2003-2005 weenCompany         |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+
error_reporting(E_ALL & ~E_NOTICE);
define('IN_WEENCOMPANY', true);

$rootpath = "../../";



// ########################### LOAD WEENCOMPANY CORE ############################

include($rootpath . 'includes/core.php');



// ############################ LOAD MAIN SETTINGS #############################

$getmainsettings = $DB->query("SELECT varname, value FROM " . TABLE_PREFIX . "mainsettings");
for($i = 0; $setting = $DB->fetch_array($getmainsettings); $i++)
{
  $mainsettings[$setting['varname']] = $setting['value'];
}



// ######################## ARTICLE BITFIELD SETTINGS ##########################

$m2_articlebitfield = array('useglobalsettings'       => 1,
                            'displayonline'           => 2,
                            'displaytitle'            => 4,
                            'displayauthor'           => 8,
                            'displaycreateddate'      => 16,
                            'displayupdateddate'      => 32,
                            'displayprintarticlelink' => 64,
                            'displayemailarticlelink' => 128,
                            'displaydescription'      => 256,
                            'displaysmilies'          => 512,
                            'displaycomments'         => 1024);
                            
// ################### SET LOCALE TIME AND HEADER INFORMATION ##################

$languageinfo = explode('|', $mainsettings['language']);

$charset = $languageinfo[2];

header("Content-type: text/html; charset=$charset");


// ############################## DISPLAY ARTICLE ##############################

function m2_PrintArticle($article)
{
  global $DB, $m2_articlebitfield, $weenurl;

  // get news language
  $m2_language = GetLanguage(2);

  echo '<html>
        <head>
          <title>' . $article['title'] . '</title>
          <script language=javascript>
          <!--
            function PrintPage()
            {
              window.print();
            }
          //-->
          </script>
          <base href="' . $weenurl . '">
        </head>
        <body onload=PrintPage()>';

  // ʾ?
  if($article['settings'] & $m2_articlebitfield['displaytitle'])
  {
    echo '<b>' . $article['title'] . '</b>';
  }

  // display author?
  if($article['settings'] & $m2_articlebitfield['displayauthor'])
  {
    echo '<br />' . $m2_language['by'] . ' ' . $article['author'];
  }

  // display published date?
  if($article['settings'] & $m2_articlebitfield['displaycreateddate'])
  {
    echo '<br />' . $m2_language['published'] . ' ' . iif($article['datestart'] != 0, DisplayDate($article['datestart']), DisplayDate($article['datecreated']));
  }

  // ʾ?
  if( ($article['settings'] & $m2_articlebitfield['displayupdateddate']) AND ($article['dateupdated'] != 0) )
  {
    echo '<br />' . $m2_language['updated'] . ' ' . DisplayDate($article['dateupdated']);
  }

  // display description?
  if($article['settings'] & $m2_articlebitfield['displaydescription'])
  {
    if(strlen($article['description']))
    {
      echo '<br /><br />' . iif($article['settings'] & $m2_articlebitfield['displaysmilies'], AddSmilies($article['description']), $article['description']);
    }
  }

  // print article
  echo '<br /><br />' . str_replace('{pagebreak}', '', $article['article']);
  echo '</body></html>';
}



// ############################ START PRINT ARTICLE ############################

if( (isset($_GET['m2_articleid'])) AND (preg_match("/^[0-9]+$/", $_GET['m2_articleid'])) AND ($article = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "m2_news WHERE articleid = '" . $_GET['m2_articleid'] . "' AND (settings & 2)")) )
{
  // get global article settings
  $getsettings = $DB->query("SELECT description, value FROM " . TABLE_PREFIX . "modulesettings WHERE moduleid = 2");
  for($i = 0; $setting = $DB->fetch_array($getsettings); $i++)
  {
    $settings[$setting['description']] = $setting['value'];
  }

  // create global settings
  $globalsettings = 0;
  $globalsettings += $settings['ʾ']                      == 1 ? 4    : 0;
  $globalsettings += $settings['ʾ']                     == 1 ? 8    : 0;
  $globalsettings += $settings['ʾ']              == 1 ? 16   : 0;
  $globalsettings += $settings['ʾ']               == 1 ? 32   : 0;
  $globalsettings += $settings['ʾӡ']         == 1 ? 64   : 0;
  $globalsettings += $settings['ʾʼ']         == 1 ? 128  : 0;
  $globalsettings += $settings['Ҫʾϸ'] == 1 ? 256  : 0;
  $globalsettings += $settings['ʾ']              == 1 ? 512  : 0;
  $globalsettings += $settings['ʾû']              == 1 ? 1024 : 0;

  // use global settings for this article?
  if($article['settings'] & $m2_articlebitfield['useglobalsettings'])
  {
    $article['settings'] = $globalsettings;
  }

  m2_PrintArticle($article);
}

?>