<?php

	class InstallFrom {
		private $method;
		private $action;
		private $class;

		function __construct($method="POST", $action="index.php", $class="white-box") {
			$this->method=$method;
			$this->action=$action;
			$this->class=$class;
		}

		function getAgreement(){
			$fc ='';
			$fc.='<div class="body-box tip-msg">';
			$fc.='欢迎您使用ELINCMS企业建站系统V1.7，请认真阅读以下安装条款后进行安装.';
			$fc.='</div>';
			$fc.='<form method="'.$this->method.'" action="'.$this->action.'" class="'.$this->class.'">';
			$fc.='<div class="body-box">';
			$fc.='<div class="center red-font">ELINCMS 许可协议</div>';
			$fc.='<div class="license">';
			$fc.='<ol>';
			$fc.='<li>ELINCMS企业建站系统的所有权归<a href="http://www.elincms.com"><span class="red-font">ELINCM</span></a>所有,未经允许不得用于任何商业用途.</li>';
			$fc.='<li>任何自愿使用软件的用户,都可以到<a href="http://bbs.elincms.com" target=_bank><span class="red-font">亿凌论坛提出问题及建议！</span></a>，但不承担任何因使用本软件而产生问题的相关责任。</li>';
			$fc.='<ol>';
			$fc.='</div></div>';
			$fc.='<div class="center body-box">';
			$fc.='<input type="hidden" name="step" value="2">';
			$fc.='<input type="submit" class="button" value="我同意">';
			$fc.='<input type="button" class="button" value="我不同意" onclick="window.close()">';
			$fc.='</div>';
			$fc.='</form>';
			return $fc;
		}

		function getDbFrom($info, $inputs, $error="tip-msg"){
			$fc='';
			$fc.='<div class="body-box '.$error.'">'.$info.'</div>';
			$fc.='<form method="'.$this->method.'" action="'.$this->action.'" class="'.$this->class.'">';
			$fc.='<ul>';

			$fc.='<li class="light-row">';
			$fc.='<span class="col_width">数据库主机名称</span>';
			$fc.='<input type="text" class="text-box" name="DB_HOST" value="'.$inputs["DB_HOST"].'">';
			$fc.='数据库服务器地址, 一般为 localhost';
			$fc.='</li>';

			$fc.='<li class="dark-row">';
			$fc.='<span class="col_width">数据库用户名</span>';
			$fc.='<input type="text" class="text-box" name="DB_USER" value="'.$inputs["DB_USER"].'">';
			$fc.='数据库账号用户名';
			$fc.='</li>';

			$fc.='<li class="light-row">';
			$fc.='<span class="col_width">数据库密码</span>';
			$fc.='<input type="password" class="text-box" name="DB_PWD" value="'.$inputs["DB_PWD"].'">';
			$fc.='数据库账号密码';
			$fc.='</li>';

			$fc.='<li class="dark-row">';
			$fc.='<span class="col_width">数据库名称</span>';
			$fc.='<input type="text" class="text-box" name="DB_NAME" value="'.$inputs["DB_NAME"].'">';
			$fc.='数据库名称,数据库必须存在';
			$fc.='</li>';


			$fc.='<li class="light-row">';
			$fc.='<span class="col_width">表名前缀</span>';
			$fc.='<input type="text" class="text-box" name="TAB_PREFIX" value="'.$inputs["TAB_PREFIX"].'">';
			$fc.='同一数据库安装多CMS时可改变默认';
			$fc.='</li>';

			$fc.='<li class="dark-row">';
			$fc.='<span class="col_width">网站名称</span>';
			$fc.='<input type="text" class="text-box" name="APP_NAME" value="'.$inputs["APP_NAME"].'">';
			$fc.='用于在标题栏上显示';
			$fc.='</li>';

			$fc.='</ul>';
			$fc.='<div class="center body-box">';
			$fc.='<input type="hidden" name="step" value="3">';
			$fc.='<input type="button" class="button" value="上一步" onclick="history.back()">';
			$fc.='<input type="submit" class="button" value="下一步" >';
			$fc.='</div>';
			$fc.='</form>';
			return $fc;
		}

		function getAdminFrom($info, $inputs, $error="tip-msg"){
			$fc='';
			$fc.='<div class="body-box '.$error.'">'.$info.'</div>';
			$fc.='<form method="'.$this->method.'" action="'.$this->action.'" class="'.$this->class.'">';
			$fc.='<ul>';

			$fc.='<li class="light-row liimg">';
			$fc.='<span class="col_width">管理员帐号</span>';
			$fc.='<input type="text" class="text-box" name="ADMIN_USER" value="'.$inputs["ADMIN_USER"].'">';
			$fc.='</li>';

			$fc.='<li class="dark-row liimg">';
			$fc.='<span class="col_width">管理员密码</span>';
			$fc.='<input type="password" class="text-box" name="ADMIN_PWD" value="'.$inputs["ADMIN_PWD"].'">';
			$fc.='</li>';
			$fc.='<li class="light-row liimg">';
			$fc.='<span class="col_width">重复密码</span>';
			$fc.='<input type="password" class="text-box" name="ADMIN_REPWD" value="'.$inputs["ADMIN_REPWD"].'">';
			$fc.='</li>';
			$fc.='<li class="dark-row liimg">';
			$fc.='<span class="col_width">管理员邮箱</span>';
			$fc.='<input type="text" class="text-box" name="ADMIN_MAIL" value="'.$inputs["ADMIN_MAIL"].'">';
			$fc.='</li>';

			$fc.='</ul>';
			$fc.='<div class="center body-box">';
			$fc.='<input type="hidden" name="step" value="4">';
			$fc.='<input type="button" class="button" value="上一步" onclick="history.back()">';
			$fc.='<input type="submit" class="button" value="下一步" >';
			$fc.='</div>';
			$fc.='</form>';
			return $fc;
		}

		function getInstallMessage($message, $installStats){
			$fc="";
			$fc.='<div class="body-box tip-msg">';
			$fc.='安装信息显示！！';
			$fc.='</div>';
			$fc.='<div class="body-box">';
			$fc.='<div class="license">';
			$fc.=$message;
			$fc.='</div></div>';
			$fc.='<div class="center body-box">';
			$fc.='<form method="'.$this->method.'" action="'.$this->action.'">';
			if($installStats){
				$fc.='<input type="hidden" name="step" value="5">';
				$fc.='<input type="submit" class="button" value="恭喜您安装成功，点击进入首页" >';

			}else{
				$fc.='<input type="button" class="button" value="安装失败，请返回" onclick="history.back()">';
			}
			$fc.='</form>';
			$fc.='</div>';
			return $fc;
		}

	}
?>

