<?php

	class  Process {
		private $configFile;
		private $sqlFile;
		private $info;

		function __construct($configFile="../config.inc.php", $sqlFile="elincms.sql"){
			$this->configFile=$configFile;
			$this->sqlFile=$sqlFile;
			$this->info="";
		}

		function configSYS($configArray) {
			$configText = file_get_contents($this->configFile);
			$configArray["CMS_ROOT"]=$this->getRoot();
			$configArray["APP_PATH"]=$this->getAppPath();
			foreach($configArray as $key => $val) {
				$pattern[]='/define\(\"'.$key.'\",\s*.+\);/';
				$repContent[]='define("'.$key.'", "'.$val.'");';
			}
			$configText = preg_replace($pattern, $repContent, $configText);
			return file_put_contents($this->configFile, $configText);
		}

		private function getRoot(){
			$rootPath=dirname(dirname($_SERVER["SCRIPT_FILENAME"]));
			return $rootPath."/";

		}

		private function getAppPath(){
			return "/".ltrim($this->getRoot(), $_SERVER["DOCUMENT_ROOT"]);
		}

		function createDb($user){
			$mysqli=new mysqli(DB_HOST, DB_USER, DB_PWD);
			if(mysqli_connect_errno()) {
				$this->info.='<font color="red">连接失败，原因为：'.mysqli_connect_error().'</font>';
				$mysqli=false;
				return false;
			}
/*
			if($mysqli->query('create database if not exists '.DB_NAME)){
				$this->info.='创建数据库<b>'.DB_NAME.'</b>成功！<br>';
			}else{
				$this->info.='<font color="red">创建数据库<b>'.DB_NAME.'</b>失败！<font>';
				$mysqli->close();
				return false;
			}
 */
			if($mysqli->select_db(DB_NAME)){
				$this->info.='数据库<b>'.DB_NAME.'</b>选择成功<br>';
			}else{
				$this->info.='<font color="red">选择数据库<b>'.DB_NAME.'</b>失败！<font>';
				$mysqli->close();
				return false;
			}

			$sql=file_get_contents($this->sqlFile);
			$sql=str_replace("\r", "\n", str_replace('elin_', TAB_PREFIX, $sql));
			$ret=array();

			foreach(explode(";\n", trim($sql)) as $key => $query) {
				$queries = explode("\n", trim($query));
				$ret[$key]='';
				foreach($queries as $query) {
					$ret[$key] .= substr($query,0,1) == '#' || substr($query,0,1).substr($query,1,1) == '--' ? '' : $query;
				}

			}
			unset($sql);
			foreach($ret as $query) {
				$query = trim($query);
				if($query) {
					if(substr($query, 0, 12) == 'CREATE TABLE') {
						$name = preg_replace("/CREATE TABLE ([a-z0-9_]+) .*/is", "\\1", $query);
						if($mysqli->query($query)){
							$this->info.='建立数据表'.' <b>'.$name.'</b> ... '.'成功！！<br>';
						}else{
							$this->info.='<font color="red">建立数据表'.' '.$name.' ... '.'失败！</font>';
						       	$mysqli->close();
							return false;
						}
					} else {
						if(!$mysqli->query($query)){
							$this->info.='<font color="red">查询语句'.$query.'执行失败！</font>';
							$mysqli->close();
							return false;
						}
					}
				}

			}

			$insert="INSERT INTO ".TAB_PREFIX."user(userName, userPwd, email,disable,allow_dlht,allow_fbpl) VALUES('".$user["ADMIN_USER"]."', '".md5($user["ADMIN_PWD"])."','".$user["ADMIN_MAIL"]."',0,1,1)";

			if($mysqli->query($insert)){
				$this->info.='添加管理员用户<b>'.$user["ADMIN_USER"].'</b>成功！<br>';
			}else{
				$this->info.='<font color="red">添加管理员用户<b>'.$user["ADMIN_USER"].'</b>失败！<font>';
				$mysqli->close();
				return false;
			}

			$mysqli->close();
			return true;
		}

		function getInstallInfo(){
			return $this->info;
		}



	}

?>

