<?php

class modelModel extends Model{
	function __construct(){
			parent:: __construct();
			$this->tabName = TAB_PREFIX."models_reg";
			$this->fieldList=$this->get_fields($this->tabName,'list');
		}


	function fields($tabname){
		return$fields = $this->get_fields(TAB_PREFIX.$tabname);
	}

	function validate(){
			$result = true;
			if(!validate::required($_POST['itemname'])){
					$this->messList[] = "ʾֲΪ.";
					$result=false;
			}
			if(!validate::required($_POST['fieldname'])){
					$this->messList[] = "ֶƲΪ.";
					$result=false;
			}

			return $result;

	}


function GetFieldMake($dtype,$fieldname,$dfvalue,$mxlen)
{
	$fields = array();
	if($dtype=="int"||$dtype=="datetime")
	{
		if($dfvalue=="" || ereg("[^0-9-]",$dfvalue))
		{
			$dfvalue = 0;
		}
		$fields[0] = " `$fieldname` int(11) NOT NULL default '$dfvalue';";
		$fields[1] = "int(11)";
	}

	else if($dtype=="float")
	{
		if($dfvalue=="" || ereg("[^0-9\.-]",$dfvalue))
		{
			$dfvalue = 0;
		}
		$fields[0] = " `$fieldname` float NOT NULL default '$dfvalue';";
		$fields[1] = "float";
	}
	else if($dtype=="img"||$dtype=="media"||$dtype=="imgfile")
	{
		if(empty($dfvalue))
		{
			$dfvalue = '';
		}
		if($mxlen=="")
		{
			$mxlen = 200;
		}
		if($mxlen > 255)
		{
			$mxlen = 100;
		}
		$fields[0] = " `$fieldname` varchar($mxlen) NOT NULL default '$dfvalue';";
		$fields[1] = "varchar($mxlen)";
	}
	else if($dtype=="multitext"||$dtype=="htmltext")
	{
		$fields[0] = " `$fieldname` mediumtext;";
		$fields[1] = "mediumtext";
	}
	else if($dtype=="textdata")
	{
		if(empty($dfvalue))
		{
			$dfvalue = '';
		}
		$fields[0] = " `$fieldname` varchar(100) NOT NULL default '';";
		$fields[1] = "varchar(100)";
	}
	else if($dtype=="textchar")
	{
		if(empty($dfvalue))
		{
			$dfvalue = '';
		}
		$fields[0] = " `$fieldname` char(100) NOT NULL default '$dfvalue';";
		$fields[1] = "char(100)";
	}
	else if($dtype=="checkbox")
	{
		$dfvalue = str_replace(',',"','",$dfvalue);
		$dfvalue = "'".$dfvalue."'";
		$fields[0] = " `$fieldname` set($dfvalue) NULL;";
		$fields[1] = "set($dfvalue)";
	}
	else if($dtype=="select" || $dtype=="radio")
	{
		$dfvalue = str_replace(',',"','",$dfvalue);
		$dfvalue = "'".$dfvalue."'";
		$fields[0] = " `$fieldname` enum($dfvalue) NULL;";
		$fields[1] = "enum($dfvalue)";
	}
	else
	{
		if(empty($dfvalue))
		{
			$dfvalue = '';
		}
		if(empty($mxlen))
		{
			$mxlen = 100;
		}
		if($mxlen > 255)
		{
			$mxlen = 250;
		}
		$fields[0] = " `$fieldname` varchar($mxlen) NOT NULL default '$dfvalue';";
		$fields[1] = "varchar($mxlen)";
	}
	return $fields;
}

	function field_add(){
		$return = false;
		$row = $this->find($_REQUEST[id]);
		if(!$row){
			return $return;
		}
		$fieldset = $row['fieldset'];
		$trueTable = TAB_PREFIX.$row['type'];
		$fieldinfos = $this->GetFieldMake($_POST[dtype],$_POST[fieldname],$_POST[vdefault],$_POST[mxlen]);
		$ntabsql = $fieldinfos[0];
		$buideType = $fieldinfos[1];
		$rs = $this->pdo->exec("ALTER TABLE `$trueTable` ADD  $ntabsql");
		if($rs===false){
			$return = false;
		}else{
			$fieldset=unserialize($fieldset);
			if(empty($fieldset)){
				$fieldset=array(array("fieldname"=>$_POST[fieldname],"des"=>$_POST[itemname],"type"=>$_POST[dtype],"build"=>$buideType));
			}else{
				$fieldset[]=array("fieldname"=>$_POST[fieldname],"des"=>$_POST[itemname],"type"=>$_POST[dtype],"build"=>$buideType);
			}
			$fieldset=serialize($fieldset);
			if($this->mod(array('id'=>$_REQUEST[id],'fieldset'=>$fieldset))){
				$return = true;
			}
		}
		return $return;
	}

	function field_del(){
		$return = false;
		$row = $this->find($_REQUEST[id]);
		$trueTable = TAB_PREFIX.$row['type'];
		$fname = $_REQUEST['fieldname'];
		$rs = $this->pdo->exec("ALTER TABLE `$trueTable` DROP `$fname` ");
		if($rs===false){
			$return = false;

		}else{
			$fieldset=unserialize($row[fieldset]);
			foreach($fieldset as $key => $val){
				if($val['fieldname']==$fname){
					unset($fieldset[$key]);

				}

			}
			$fieldset=serialize($fieldset);
			if($this->mod(array('id'=>$_REQUEST[id],'fieldset'=>$fieldset))){
				$return = true;
			}
		}
	return $return;
	}

}
?>