<?php
class Common {
		static function sizeCount($bytes) {
			if ($bytes >= pow(2,40)) {
				$return = round($bytes / pow(1024,4), 2);
				$suffix = "TB";
			} elseif ($bytes >= pow(2,30)) {
				$return = round($bytes / pow(1024,3), 2);
				$suffix = "GB";
			} elseif ($bytes >= pow(2,20)) {
				$return = round($bytes / pow(1024,2), 2);
				$suffix = "MB";
			} elseif ($bytes >= pow(2,10)) {
				$return = round($bytes / pow(1024,1), 2);
				$suffix = "KB";
			} else {
				$return = $bytes;
				$suffix = "Byte";
			}
			return $return ." " . $suffix;
		}


		static function getRealIpAddr(){
    			if (!empty($_SERVER['HTTP_CLIENT_IP'])){
        		$ip=$_SERVER['HTTP_CLIENT_IP'];
    			}elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
   			 //to check ip is pass from proxy
    			{
       		 		$ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
   				 }else{
        			$ip=$_SERVER['REMOTE_ADDR'];
   				}
    			return $ip;
			}


		static function HTMLEncode($str){
        	if($str!=""){
                $str=str_replace(">","&gt;",$str);
                $str=str_replace("<","&lt;",$str);
                $str=str_replace(chr(32)," ",$str);
                $str=str_replace(chr(34),"&quto;",$str);
                $str=str_replace(chr(39),"&#39;",$str);
                $str=str_replace(chr(13),"",$str);
                $str=str_replace(chr(10).chr(10),"</p><p>",$str);
                $str=str_replace(chr(10),"<br>",$str);
                return $str;
       		 }
		}

	    static function createdir($path){
			if (!file_exists($path)){
				common::createdir(dirname($path));
				@mkdir($path, 0775);
				return true;
			} elseif(file_exists($path)){
				return true;
			} else {
				return false;
			}
		}


		static function pinyin($str,$ishead=0){
			$restr = "";
			$str = APP_CHARSET == 'gb2312' ? trim($str) : utf82gb(trim($str));
			$slen = strlen($str);
			if($slen<2) return $str;

			$fp = fopen(APP_CLASS_PATH."data/pinyin.db","r");
			while(!feof($fp)){
			$line = trim(fgets($fp));
			$pinyins[$line[0].$line[1]] = substr($line,3,strlen($line)-3);
			}
			fclose($fp);

			for($i=0;$i<$slen;$i++){
				if(ord($str[$i])>0x80){
					$c = $str[$i].$str[$i+1];
					$i++;
					if(isset($pinyins[$c])){
						if($ishead==0) $restr .= $pinyins[$c];
						else $restr .= $pinyins[$c][0];
					}else $restr .= "-";
				}else if( preg_match("/[a-z0-9]/i",$str[$i]) ){	$restr .= $str[$i]; }
				else{ $restr .= "-";  }
			}
		unset($pinyins);
		return $restr;

		}







	}
?>
