<?php
class upload {
	private $filepath;
	private $allowtype = array('gif','jpg','png','jpeg');
	private $maxsize   = 1000000;
	private $israndname= true;

	private $originName;
	private $tmpFileName;
	private $fileType;
	private $fileSize;
	private $newFileName;
	private $errorNum  =0;
	private $errorMess ='';

    function __construct($options=array()){
    	foreach($options as $key => $val){
    		$key=strtolower($key);
    		if(!in_array($key,get_class_vars(get_class($this)))){
    			continue;
    		}
    		$this->setOption($key,$val);
    	}

    }




    private function setOption($key,$val){
    	$this->$key=$val;
    }
    private function getError(){
    	$str="ϴļ<font color='red'>$this->originName</font>ʱ:";
    	switch($this->errorNum){
    		case 4  : $str.='ûļϴ';break;
    		case 3  : $str.='ļֻϴ';break;
    		case 2  : $str.='ϴļHTMLMAX_FILE_SIZEѡֵָ';break;
    		case 1  : $str.='ϴļphp.iniupload_max_filesizeѡֵ';break;
			case -1 : $str.='δ';break;
			case -2 : $str.='ļϴļܳ'.$this->maxsize.'ֽ';break;
			case -3 : $str.='ϴʧ';break;
			case -4 : $str.='ϴļĿ¼ʧܣָϴĿ¼';break;
			case -5 : $str.='ָϴļ·';break;
			default : $str.='δ֪';
    	}

    	return $str.'<br>';
    }


    private function createdir($path)
	{
		if (!file_exists($path)){
			$this->createdir(dirname($path));
			@mkdir($path, 0775);
			return true;
		} elseif(file_exists($path)){
			return true;
		} else {
			return false;
		}
	}


    private function checkFilePath(){
    	if(empty($this->filepath)){
    		$this->setOption('errorNum',-5);
    		return false;
    	}
    	if(!file_exists($this->filepath)){
    		if(!$this->createdir($this->filepath)){
    			$this->setOption('errorNum',-4);
    			return false;
    		}
    	}
    	return true;

    }
    private function checkFileTpye(){
    	if(in_array(strtolower($this->fileType),$this->allowtype)){
    		return true;
    	}else{
    		$this->setOption('errorNum',-1);
    		return false;
    	}

    }
    private function checkFileSize(){
    	if($this->fileSize > $this->maxsize){
    		$this->setOption('errorNum',-2);
    		return false;
    	}else{
    		return true;
    	}

    }
    private function setNewFileName(){
    	if($this->israndname){
    		$this->setOption('newFileName',$this->proRandName());
    	}else{
    		$this->setOption('newFileName',$this->originName);
    	}

    }
    private function proRandName(){
    	$fileName = date('YmdHis').rand(100,999);
    	return $fileName.'.'.$this->fileType;

    }



    function uploadFile($fileField){
    	$return = true;
    	if(!$this->checkFilePath()){
    		$this->errorMess=$this->getError();
    		return false;
    	}
    	$name     = $_FILES[$fileField]['name'];
    	$tmp_name = $_FILES[$fileField]['tmp_name'];
    	$size     = $_FILES[$fileField]['size'];
    	$error    = $_FILES[$fileField]['error'];
    	if(is_array($name)){
    		$errors = array();
    		for($i=0;$i<count($name);$i++){
    			if($this->setFiles($name[$i],$tmp_name[$i],$size[$i],$error[$i])){
    				if(!$this->checkFileSize() || !$this->checkFileTpye()){
    					$errors[]=$this->getError();
    					$return = false;
    				}
    			}else{
    				$errors[]=$this->getError();
    				$return = false;
    			}
    			if(!$return){
    				$this->setFiles();
    			}

    		}
    		if($return){
    			$fileNames=array();
    			for($i=0;$i<count($name);$i++){
    				if($this->setFiles($name[$i],$tmp_name[$i],$size[$i],$error[$i])){
    					$this->setNewFileName();
    					if(!$this->copyFile()){
    						$errors=$this->getError();
    						$return=false;
    					}else{
    						$fileNames[]=$this->newFileName;
    					}

    				}

    			}
    			$this->newFileName = $fileNames;
    		}
    		$this->errorMess=$errors;
    		return $return;

    	}else{

    		if($this->setFiles($name,$tmp_name,$size,$error)){
    			if($this->checkFileSize() && $this->checkFileTpye()){
    				$this->setNewFileName();
    				if($this->copyFile()){
    					return true;
    				}else{
    					$return = false;
    				}

    			}else{
    				$return = false;
    			}

    		}else{
    			$return = false;
    		}
    		if(!$return){
    			$this->errorMess=$this->getError();
    		}
    		return $return;
    	}


    }
    private function copyFile(){
    	if(!$this->errorNum){
    		$filepath=rtrim($this->filepath,'/').'/';
    		$filepath.=$this->newFileName;

    		if(@move_uploaded_file($this->tmpFileName,$filepath)){
    			return true;
    		}else{
    			$this->setOption('errorNum', -3);
				return false;
    		}
    	}else{
    		return false;
    	}
    }
    private function setFiles($name='',$tmp_name='',$size=0,$error=0){
    	$this->setOption('errorNum',$error);
    	if($error){
    		return false;
    	}
    	$this->setOption('originName',$name);
    	$this->setOption('tmpFileName',$tmp_name);
    	$str = explode('.',$name);
    	$this->setOption('fileType',$str[count($str)-1]);
    	$this->setOption('fileSize',$size);
    	return true;

    }
    function getNewFileName(){
    	return $this->newFileName;

    }
    function getErrorMsg(){
    	if(is_array($this->errorMess)){
    		foreach($this->errorMess as $key =>$val){
    			$html.=$val."<br>";
    		}
    		return $html;
    	}else{
    		return $this->errorMess;
    	}

    }
    function getFileSize(){
    	return $this->fileSize;
    }
}
?>