<?php
header("Content-type: text/html; charset=utf-8"); 
class UPImages {
        var $annexFolder = "annex";//附件存放点，默认为：annex
        var $smallFolder = "smallimg";//缩略图存放路径，注：必须是放在 $annexFolder下的子目录，默认为：smallimg
        var $upFileType = "jpg gif png";//上传的类型，默认为：jpg gif png rar zip
        var $upFileMax = 1;//上传大小限制，单位是“KB”，默认为：1024KB
        var $maxWidth = 500; //图片最大宽度
        var $maxHeight = 600; //图片最大高度
        function UPImages($annexFolder,$smallFolder) {
                $this->annexFolder = $annexFolder;
                $this->smallFolder = $smallFolder;
        }
        function upLoad($inputName) {
                $imageName = time();//设定当前时间为图片名称
                if(@empty($_FILES[$inputName]["name"]) || $_FILES[$inputName]["size"]<=0) $this->show_err("没有上传图片信息，或图片太大，请确认");
                $name = explode(".",$_FILES[$inputName]["name"]);//将上传前的文件以“.”分开取得文件类型
                $imgCount = count($name);//获得截取的数量
                $imgType = $name[$imgCount-1];//取得文件的类型
                if(stripos($this->upFileType,$imgType) === false) $this->show_err("上传文件类型仅支持 ".$this->upFileType." 不支持 ".$imgType);
                $photo = $imageName.".".$imgType;//写入数据库的文件名
                $uploadFile = $this->annexFolder."/".$photo;//上传后的文件名称
				$upFileok = move_uploaded_file($_FILES[$inputName]["tmp_name"],$uploadFile) or $this->show_err("请查看上传目录的写权限");
                if($upFileok) {
                        $imgSize = $_FILES[$inputName]["size"];
                        $kSize = round($imgSize/1024);
                        if($kSize > ($this->upFileMax*1024)) {
                                @unlink($uploadFile);
                                $this->show_err("上传文件不能超过 ".$this->upFileMax."MB");
                        }
                } else {
                        $this->show_err("上传图片失败，请确认你的上传文件不超过 $upFileMax MB 或上传时间超时");
                }
                return $photo;
        }
        function getInfo($photo) {
                $photo = $this->annexFolder."/".$photo;
                $imageInfo = getimagesize($photo);
                $imgInfo["width"] = $imageInfo[0];
                $imgInfo["height"] = $imageInfo[1];
                $imgInfo["type"] = $imageInfo[2];
                $imgInfo["name"] = basename($photo);
                return $imgInfo;
        }
        function ResizeImg($photo,$new_path,$width=128,$height=128) {
                $imgInfo = $this->getInfo($photo);
                $photo = $this->annexFolder."/".$photo;//获得图片源
                if($imgInfo["type"] == 1) {
                        $img = imagecreatefromgif($photo);
						$ext=".gif";
                } elseif($imgInfo["type"] == 2) {
                        $img = imagecreatefromjpeg($photo);
						$ext=".jpg";
                } elseif($imgInfo["type"] == 3) {
                        $img = imagecreatefrompng($photo);
						$ext=".png";
                } else {
                        $img = "";
                }
				$newName = substr($imgInfo["name"],0,strrpos($imgInfo["name"], ".")).$ext;//新图片名称
                if(empty($img)) return False;
                $width = ($width > $imgInfo["width"]) ? $imgInfo["width"] : $width;
                $height = ($height > $imgInfo["height"]) ? $imgInfo["height"] : $height;
                $srcW = $imgInfo["width"];
                $srcH = $imgInfo["height"];
				$temp_w = round($srcW/$width,2);
				$temp_h = round($srcH/$height,2);
				if($temp_w > $temp_h)
					$height = $srcH/$temp_w;
				else
					$width = $srcW/$temp_h;
                //if ($srcW * $width > $srcH * $height) {
                 //       $height = round($srcH * $width / $srcW);
                //} else {
                 //       $width = round($srcW * $height / $srcH);
                //}
                if (function_exists("imagecreatetruecolor")) {
                        $newImg = imagecreatetruecolor($width, $height);
                        ImageCopyResampled($newImg, $img, 0, 0, 0, 0, $width, $height, $imgInfo["width"], $imgInfo["height"]);
                } else {
                        $newImg = imagecreate($width, $height);
                        ImageCopyResized($newImg, $img, 0, 0, 0, 0, $width, $height, $imgInfo["width"], $imgInfo["height"]);
                }
                if ($this->toFile) {
                        if (file_exists($new_path."/".$newName)) @unlink($new_path."/".$newName);
                        ImageJPEG($newImg,$new_path."/".$newName);
                        return $new_path."/".$newName;
                } else {
                        ImageJPEG($newImg);
                }
                ImageDestroy($newImg);
                ImageDestroy($img);
                return $newName;
        }
		function show_err($err_str)
		{
			echo"<span style=\"font-size:16px; font-weight:bold; color:FF0000;\">出错啦：</span><br /><br />";
			die($err_str . "[<span onclick=\"history.back();\" style=\"cursor:pointer; color=#360; font-size:14px; font-weight:bold;\">点击这里返回</span>]");
		}
}
?>