<?php
if(!defined('IN_MICECMS')){header("HTTP/1.0 404 Not Found");die();}
function convert_bytes($val) {
	$val=(float)$val;
	if ($val < 1024)
		return $val.'B';
	$k = $val / 1024;
	if ($k >= 1024) {
		$m = $k / 1024;
		if ($m >= 1024)
			$n = number_format($m/1024,2).' GB';
		else
			$n = number_format($m,2).' MB';
	} else
		$n = number_format($k,2).' KB';
	return str_replace('.00', '', $n);
}


function read_dir($dir,$type='both',$extra=false,$allowed_ext=false) {
	$info=array();
	$dh=opendir($dir);
	while (false !== ($m_name = readdir($dh))) {
		if( $m_name[0]=='.' ) continue;	// skip all folders whose name starts with a dot
		if ( is_dir( $dir.$m_name ) && ($type!='file') ) {
			if($extra) {
				$tinfo['id']=substr($m_name,strrchr($m_name,'/'));
				$tinfo['path']=$dir.$m_name."/";
				$tinfo['size']=_NA;
				$tinfo['created']=filectime($dir.$m_name);
				$info[]=$tinfo;
			} else
				$info[] = $m_name;
		}
		
		if ( is_file( $dir.$m_name ) && ($type!='dir')  ){
			if (!$allowed_ext or (in_array(FileExtName($m_name), $allowed_ext))) {
				if($extra) {
					$tinfo['id']=substr($m_name,strrchr($m_name,'/'));
					$tinfo['path']=$dir.$m_name;
					$tinfo['size']=convert_bytes(filesize($dir.$m_name));
					$tinfo['created']=filectime($dir.$m_name);
					$info[]=$tinfo;
				} else
					$info[]=$m_name;
			}
		}
	}
	return $info;
}

?>