<?php
if(!defined('IN_MICECMS')){header("HTTP/1.0 404 Not Found");die();}
//获取文章列表(SQL条件语句，起始记录数，偏移记录数)
function ArticleList($micefun,$subsql,$nrows,$offset){		//Nrows,起始记录数，0为第一条,1为第2条
	$article=new model_Article();
	if($subsql){
		$article->setSubsection($subsql);
	}
	if($offset > 0){
		$article->setNrows($nrows);			//记录下标从0开始
		$article->setOffset($offset);
		$results=$article->doSelectLimit();
	}else{
		$results=$article->doSelect();
	}
	return $results;
}

//获取文章列表,page页面方式(SQL条件语句，每页显示记录数，页数)
function ArticlePagerList($micefun,$subsql,$pages,$pagenum){	
	//pages每页显示记录数，pagenum当前页数，从1开始
	$article=new model_Article();
	if($subsql){
		$article->setSubsection($subsql);
	}
	if($pages > 0 and $pagenum > 0){
		$article->setPages($pages);			//当前页数，从1开始
		$article->setPagenum($pagenum);
		$results=$article->Pager();
	}else{
		$results=$article->doSelect();
	}
	return $results;
}

//获取page导航条
function ArticlePager($micefun,$subsql,$pages,$pagenum,$listnum,$cid){	
	//pages每页显示记录数，pagenum当前页数，从1开始,listnum导航条里显示多少页

	$url=ListUrl('micefun',$cid,'{PID}');

	$article=new model_Article();
	if($subsql){
		$article->setSubsection($subsql);
	}
	if($pages > 0 and $pagenum > 0){
		$article->setPages($pages);			//当前页数，从1开始
		$article->setPagenum($pagenum);
		$results=$article->Pager();
	}else{
		$results=$article->doSelect();
	}
	$page = $article->Page();
	$totalpages = $article->TotalPages();
	$totals = $article->Totals();

	$listnum2 = ceil(($listnum-1)/2);
	if ($pagenum > $listnum2)
	{
		if($listnum % 2 == 0)
			$pagenuma = $pagenum - $listnum2 + 1;
		else
			$pagenuma = $pagenum - $listnum2;

		$pagenumb = $pagenum + $listnum2;
	}
	else
	{
		$pagenuma = 1;
		$pagenumb = $listnum;
	}
	if ($pagenumb > $totalpages)
	{
		if ($totalpages - $listnum + 1 > 0)
			$pagenuma = $totalpages - $listnum + 1;
		else
			$pagenuma = 1;

		$pagenumb = $totalpages;
	}

	if($pagenum > 1)
	{
		$returns = "<a href='".str_replace('{PID}',1,$url)."'>首页</a> ";
		$returns .= "<a href='".str_replace('{PID}',$pagenum-1,$url)."'>上一页</a> ";
	}
	for ($i = $pagenuma; $i <= $pagenumb; $i++)
	{
		if ($i == $pagenum)
			$returns .= $i." ";
		else
			$returns .= "<a href='".str_replace('{PID}',$i,$url)."'>".$i."</a> ";
	}
	if($pagenum < $totalpages){
		$returns .= "<a href='".str_replace('{PID}',$pagenum+1,$url)."'>下一页</a> ";
		$returns .= "<a href='".str_replace('{PID}',$totalpages,$url)."'>尾页</a>";
	}

	$returns .= $article->Page().'/'.$article->TotalPages();
	$returns .= '页 共 '.$article->Totals().' 条记录';

	$miceSession = new session();
	$miceSession->set('list_page', $article->TotalPages());

	return $returns;
}

//获取上一条文章信息
function ArticlePrev($micefun,$CategoryId,$Createdat){	
	$article=new model_Article();
	if($CategoryId and $Createdat){
		$article->setSubsection('WHERE isvisible=0 AND category_id LIKE \'%,'.$CategoryId.',%\' AND createdat<'.$Createdat.' order by createdat desc');
	}
	$results=$article->doSelectOne();
	if($results){
		return '<a href="'.ArticleUrl('micefun',$CategoryId,$results->getArticleId()).'">'.$results->getTitle().'</a>';
	}else{
		return '没有了';		
	}
}

//获取下一条文章信息
function ArticleNext($micefun,$CategoryId,$Createdat){	
	$article=new model_Article();
	if($CategoryId and $Createdat){
		$article->setSubsection('WHERE isvisible=0 AND category_id LIKE \'%,'.$CategoryId.',%\' AND createdat>'.$Createdat.' order by createdat asc');
	}
	$results=$article->doSelectOne();
	if($results){
		return '<a href="'.ArticleUrl('micefun',$CategoryId,$results->getArticleId()).'">'.$results->getTitle().'</a>';
	}else{
		return '没有了';		
	}
}

//获取文章内容(文章ID)
function Article($micefun,$articleid){
	if($articleid){
		$article=new model_Article();
		$article->setSubsection('WHERE article_id='.$articleid);
		$results=$article->doSelectOne();
	}else{
		$results=new model_Article();
	}
	return $results;
}

//获取分类列表(SQL条件语句，起始记录数，偏移记录数)
function CategoryList($micefun,$subsql,$nrows,$offset){		//Nrows,起始记录数，0为第一条,1为第2条
	$category=new model_Category();
	if($subsql){
		$category->setSubsection($subsql);
	}
	if($offset > 0){
		$category->setNrows($nrows);			//记录下标从0开始
		$category->setOffset($offset);
		$results=$category->doSelectLimit();
	}else{
		$results=$category->doSelect();
	}
	return $results;
}

//获取分类id
function CategoryId($micefun,$str){
	$strs=explode(',',$str);
	return $strs[sizeof($strs)-2];
}

//获取分类路径名称
function CategoryPath($micefun,$str,$splitstr){
	$strs=explode(',',$str);
	$pathname='';
	foreach($strs as $cid){
		if($cid){
			$category=new model_Category();
			$category->setSubsection('WHERE type LIKE \'article%\' AND category_id='.$cid);
			$categoryrs=$category->doSelectOne();
			$pathname.=$splitstr.'<a href="'.ListUrl('micefun',$cid).'">'.$categoryrs->getTitle().'</a>';
		}
	}
	return $pathname;
}

//获取链接列表,$linktype,0表示文字链接,1表示图片链接,2表示所有链接
function LinkList($micefun,$linktype,$categoryid,$nrows,$offset){
	$link=new model_Link();
	$subsql='';
	if($linktype==0){
		$subsql='WHERE logo=\'0\'';
	}elseif($linktype==1){
		$subsql='WHERE logo>\'0\'';
	}
	if($categoryid>0){
		$subsql.=' AND category_id LIKE \'%,'.$categoryid.',%\' ';
	}
	$subsql.=' ORDER BY orderid DESC';
	$link->setSubsection($subsql);
	$link->setNrows($nrows);
	$link->setOffset($offset);
	$results=$link->doSelectLimit();
	return $results;
}

//获取文件列表(SQL条件语句，起始记录数，偏移记录数)
function FileList($micefun,$subsql,$nrows,$offset){		//Nrows,起始记录数，0为第一条,1为第2条
	$file=new model_File();
	if($subsql){
		$file->setSubsection($subsql);
	}
	if($offset > 0){
		$file->setNrows($nrows);			//记录下标从0开始
		$file->setOffset($offset);
		$results=$file->doSelectLimit();
	}else{
		$results=$file->doSelect();
	}
	return $results;
}

//获取投票名称
function PollTitle($micefun,$pollid){
	$pollcategory=new model_Pollcategory();
	$pollcategory->setSubsection('WHERE isvisible=0 AND pollcategory_id='.$pollid);
	$results=$pollcategory->doSelectOne();
	return $results->getTitle();
}

//获取可选投票的选项数
function PollChecks($micefun,$pollid){
	$pollcategory=new model_Pollcategory();
	$pollcategory->setSubsection('WHERE isvisible=0 AND pollcategory_id='.$pollid);
	$results=$pollcategory->doSelectOne();
	if($results->getChecks()==1)
		$checktype='radio';
	else
		$checktype='checkbox';
	return $checktype;
}

//获取投票列表
function PollList($micefun,$pollid,$nrows,$offset){
	$poll=new model_Poll();
	$poll->setSubsection('WHERE pollcategory_id='.$pollid.' ORDER BY orderid ASC');
	$poll->setNrows($nrows);
	$poll->setOffset($offset);
	$results=$poll->doSelectLimit();
	return $results;
}

//获取评论列表(SQL条件语句，起始记录数，偏移记录数)
function FormList($micefun,$subsql,$nrows,$offset){		//Nrows,起始记录数，0为第一条,1为第2条
	$form=new model_Form();
	if($subsql){
		$form->setSubsection($subsql);
	}
	if($offset > 0){
		$form->setNrows($nrows);			//记录下标从0开始
		$form->setOffset($offset);
		$results=$form->doSelectLimit();
	}else{
		$results=$form->doSelect();
	}
	return $results;
}

//更新浏览次数
function UpBrowses($micefun,$article_id){
	$article=new model_Article();
	$article->setSubsection('WHERE article_id='.$article_id);
	$results=$article->doSelectOne();

	$article->setBrowses($results->getBrowses()+1);
	$article->doUpdate();

	return '';
}

//弹出对话框
function MessageBox($jsstring)
{
	$ret= '<html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7"><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><meta http-equiv="Content-Language" content="zh-cn" /><title>'.MICE_TITLE.'</title><base href="'.MICE_URL.MICE_TPL.'/admin/" /><link href="css/Default.css" rel="stylesheet" type="text/css" /><link href="css/fieldset.css" rel="stylesheet" type="text/css"><script language="JavaScript">var baseurl = "'.MICE_URL.MICE_TPL.'/admin/";</script><script type="text/javascript" src="js/Main.js"></script>';

	$ret.= "<Script language='JavaScript'>function msgbox(){";
	if($jsstring != "")
	{
		$ret.= $jsstring;
	}
	$ret.= "return;}</Script></head><body onload='javascript:msgbox();'><table width='100%' height='100%'><tr><td></td></tr></table></body></html>";
	echo $ret;
}

//整除
function MiceDivisible($micefun,$num,$num2) {
	$result=floor(($num*100)/($num2*1));
	return $result;
}

//返回session
function MiceSession($micefun,$info){
	$miceSession = new session();
	return $miceSession->get($info);
}
?>