<?php
if(!defined('IN_MICECMS')){header("HTTP/1.0 404 Not Found");die();}
class miceRouter{
	
	private $path;
	private $static_router=array();
	
	public function __construct($pth=''){
		if(!empty($path)) $this->set_path($path);
	}
	
	public function set_path($path){
		if(!is_dir($path)){
			$this->error('Invalid app path:'.$path);
		}
		$path = rtrim($path,'/');
		$this->path	= $path;
	}
	
	public function addRouter($key,$router){
		$this->static_router[$key] = $router;
	}
	
	public function dispatch(){
		if(!empty($_GET['router'])){
			$router = strip_tags($_GET['router']);
		}else{
			$router = $this->path_info();
		}

		//list($route,$zip) = explode('.',$router);
		$parts = array();
		if(!empty($router)){
			$partarray = explode('/',$router);
			$i=0;
			foreach($partarray as $part){
				if($part!=''){
					$parts[$i++]=$part;
				}
			}
			
			if(!empty($this->static_router)){
				//静态分配
				$this_static_router = $this->static_router[current($parts)];
				if(isset($this_static_router)){					
					array_shift($parts);
					$parts = array_merge($this_static_router,$parts);
				}
			}
			//动态分配
			$file_path = $this->path.'/';
			$temp_class_name = '';
			if(!empty($parts)){
				foreach ($parts as $part){
					$part=str_replace(MICE_HTML_EXT,'',$part);
					$file_path .= $part;
					
					if(is_dir($file_path)){
						$file_path .= '/';
						$temp_class_name .= $part.'_';
						if(is_file($file_path.$part.'.php')){
							include_once $file_path.$part.'.php';
						}
						array_shift($parts);
						continue;
					}elseif(is_file($file_path.'Action.php')){
						$file_path .= 'Action.php';
						$temp_class_name .= $part;
						$action_name = $temp_class_name.'Action';
						array_shift($parts);
						break;
					}else{
						$file_path = rtrim($file_path,$part);
						break;
					}
				}
			}
			if(empty($action_name)){
				$file_path .= 'indexAction.php';
				$action_name = $temp_class_name.'indexAction';
				if(!is_file($file_path)){
					$this->error('indexAction.php is not exists!');
				}
			}
			$params = $parts;
		}else{
			$file_path = $this->path.'/'.'indexAction.php';
			$action_name = 'indexAction';
			$params=array();
		}		
		if(!is_readable($file_path)){
			$this->error($file_path.' is not readable!');
		}		

		include_once $file_path;	
		$action=new $action_name($params);
		$action->action();
	}
	
	private function path_info(){
		$this->init_url();
		$path=strip_tags($_SERVER['REQUEST_URI']);
		$strpos=strpos($path,'.php');
		if($strpos){
			$path=substr($path,$strpos+4);  
		}else{
			if(empty($_SERVER['QUERY_STRING'])){
				$strpos=strpos($path,'?');
				if($strpos){
					$path=substr($path,$strpos+1);
				}else{
					$dirlen=strlen(substr(MICE_DIR,strlen($_SERVER["DOCUMENT_ROOT"])+1));
					$path=substr($_SERVER['REQUEST_URI'],$dirlen);
				}
			}else{
				$path=$_SERVER['QUERY_STRING'];
			}
		}
		if(!empty($path)){
			return $path;
		}
		return null;
	}
	
	private function init_url(){
		if ( empty( $_SERVER['REQUEST_URI'] ) ) {
			$_SERVER['REQUEST_URI'] = $_SERVER['SCRIPT_NAME'];
			// Append the query string if it exists and isn't null
			if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
				$_SERVER['REQUEST_URI'] .= '?' . $_SERVER['QUERY_STRING'];
			}
		}
		if(empty($_SERVER['PHP_SELF'])){
			$_SERVER['PHP_SELF']=preg_replace("/(\?.*)?$/",'',$_SERVER["REQUEST_URI"]);
		}
	}
	
	
	private function error($msg){
		throw new miceException($msg);
	}
}
?>