<?php
if(!defined('IN_MICECMS')){header("HTTP/1.0 404 Not Found");die();}

function merge_filters($tag){
     global $mice_filter;
     if (isset($mice_filter['all']) && is_array($mice_filter['all'])){
         foreach ($mice_filter['all'] as $priority => $functions){
             if (isset($mice_filter[$tag][$priority]))
                 $mice_filter[$tag][$priority] = array_merge($mice_filter['all'][$priority], $mice_filter[$tag][$priority]);
             else
                 $mice_filter[$tag][$priority] = array_merge($mice_filter['all'][$priority], array());
             $mice_filter[$tag][$priority] = array_unique($mice_filter[$tag][$priority]);
		}
        
	}
    
	if (isset($mice_filter[$tag]))
         ksort($mice_filter[$tag]);
}

function apply_filters($tag, $string){
     global $mice_filter;
    
     $args = array_slice(func_get_args(), 2);
    
     merge_filters($tag);
    
     // 若没有过滤器,则直接返回第2个参数
    if (!isset($mice_filter[$tag])){
         return $string;
	}
     foreach ($mice_filter[$tag] as $priority => $functions){
         if (!is_null($functions)){
             foreach($functions as $function){
                
                 $all_args = array_merge(array($string), $args);
                 $function_name = $function['function'];
                 $accepted_args = $function['accepted_args'];
                
                 if ($accepted_args == 1)
                     $the_args = array($string);
                 elseif ($accepted_args > 1)
                     $the_args = array_slice($all_args, 0, $accepted_args);
                 elseif ($accepted_args == 0)
                     $the_args = NULL;
                 else
                     $the_args = $all_args;
                
                 $string = call_user_func_array($function_name, $the_args);
			}
		}
	}
     return $string;
}


function add_filter($tag, $function_to_add, $priority = 10, $accepted_args = 1){
     global $mice_filter;
    
     // check that we don't already have the same filter at the same priority
	if (isset($mice_filter[$tag]["$priority"])){
         foreach($mice_filter[$tag]["$priority"] as $filter){
             // uncomment if we want to match function AND accepted_args
            // if ( $filter == array($function, $accepted_args) ) {
            if ($filter['function'] == $function_to_add){
                 return true;
			}
		}
	}
    
     // So the format is mice_filter['tag']['array of priorities']['array of ['array (functions, accepted_args)]']
    $mice_filter[$tag]["$priority"][] = array('function' => $function_to_add, 'accepted_args' => $accepted_args);
    return true;
}


function remove_filter($tag, $function_to_remove, $priority = 10, $accepted_args = 1){
     global $mice_filter;
	 $new_function_list=array();
    
     // rebuild the list of filters
    if (isset($mice_filter[$tag]["$priority"])){
         foreach($mice_filter[$tag]["$priority"] as $filter){
             if ($filter['function'] != $function_to_remove){
                 $new_function_list[] = $filter;
             }
         }
         $mice_filter[$tag]["$priority"] = $new_function_list;
	}
	return true;
}



function do_action($tag, $arg = ''){
     global $mice_filter;
     $extra_args = array_slice(func_get_args(), 2);
     if (is_array($arg))
         $args = array_merge($arg, $extra_args);
     else
         $args = array_merge(array($arg), $extra_args);
    
     merge_filters($tag);
    
     if (!isset($mice_filter[$tag])){
         return;
	 }
     foreach ($mice_filter[$tag] as $priority => $functions){
         if (!is_null($functions)){
             foreach($functions as $function){
                
                 $function_name = $function['function'];
                 $accepted_args = $function['accepted_args'];
                
				if ($accepted_args == 1){
                     if (is_array($arg))
                         $the_args = $arg;
                     else
                         $the_args = array($arg);
				}elseif ($accepted_args > 1){
                     $the_args = array_slice($args, 0, $accepted_args);
				}elseif ($accepted_args == 0){
                     $the_args = NULL;
				}else{
                     $the_args = $args;
				}
                
			$string = call_user_func_array($function_name, $the_args);
			}
		}
    }
	return $string;
}

function add_action($tag, $function_to_add, $priority = 10, $accepted_args = 1){
     add_filter($tag, $function_to_add, $priority, $accepted_args);
}

function remove_action($tag, $function_to_remove, $priority = 10, $accepted_args = 1){
     remove_filter($tag, $function_to_remove, $priority, $accepted_args);
}

function get_plugin_info($plugin_file) { 
	$plugin_data = implode('', file($plugin_file)); 
	preg_match("|Plugin Hook:(.*)|i", $plugin_data, $plugin_hook);
	preg_match("|Plugin Name:(.*)|i", $plugin_data, $plugin_name); 
	preg_match("|Author:(.*)|i", $plugin_data, $author_name); 
	preg_match("|Version:(.*)|i", $plugin_data, $version);
	preg_match("|Plugin URI:(.*)|i", $plugin_data, $plugin_uri); 
	preg_match("|Description:(.*)|i", $plugin_data, $description); 
	$ret=array('plugin_hook'=>trim($plugin_hook[1]),
		'plugin_name'=>$plugin_name[1],
		'author_name'=>$author_name[1],
		'version'=>$version[1],
		'plugin_uri'=>trim($plugin_uri[1]),
		'description'=>$description[1],
	);
	return $ret;
}

?>  