﻿
/////*
////颜色选择器
////*/
var currentColor = "#8B0016";
var currentColorCMYK = "0-100-100-45";
var hexch = new Array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');

var table1 = ['0-100-100-45#8B0016', '0-100-100-25#B2001F', '0-100-100-15#C50023', '0-100-100-0#DF0029', '0-85-70-0#E54646', '0-65-50-0#EE7C6B', '0-45-30-0#F5A89A', '0-20-10-0#FCDAD5'];

var table2 = ['0-90-80-45#8E1E20', '0-90-80-25#B6292B', '0-90-80-15#C82E31', '0-90-80-0#E33539', '0-70-65-0#EB7153', '0-55-50-0#F19373', '0-40-35-0#F6B297', '0-20-20-0#FCD9C4'];

var table3 = ['0-60-100-45#945305', '0-60-100-25#BD6B09', '0-60-100-15#D0770B', '0-60-100-0#EC870E', '0-50-80-0#F09C42', '0-40-60-0#F5B16D', '0-25-40-0#FACE9C', '0-15-20-0#FDE2CA'];

var table4 = ['0-40-100-45#976D00', '0-40-100-25#C18C00', '0-40-100-15#D59B00', '0-40-100-0#F1AF00', '0-30-80-0#F3C246', '0-25-60-0#F9CC76', '0-15-40-0#FCE0A6', '0-10-20-0#FEEBD0'];

var table5 = ['0-0-100-45#9C9900', '0-0-100-25#C7C300', '0-0-100-15#DCD800', '0-0-100-0#F9F400', '0-0-80-0#FCF54C', '0-0-60-0#FEF889', '0-0-40-0#FFFAB3', '0-0-25-0#FFFBD1'];

var table6 = ['60-0-100-45#367517', '60-0-100-25#489620', '60-0-100-15#50A625', '60-0-100-0#5BBD2B', '50-0-80-0#83C75D', '30-0-60-0#AFD788', '25-0-40-0#C8E2B1', '12-0-20-0#E6F1D8'];

var table7 = ['100-0-90-45#006241', '100-0-90-25#007F54', '100-0-90-15#008C5E', '100-0-90-0#00A06B', '80-0-75-0#00AE72', '60-0-55-0#67BF7F', '45-0-35-0#98D0B9', '25-0-20-0#C9E4D6'];

var table8 = ['100-0-40-45#00676B', '100-0-40-25#008489', '100-0-40-15#009298', '100-0-40-0#00A6AD', '80-0-30-0#00B2BF', '60-0-25-0#6EC3C9', '45-0-20-0#99D1D3', '25-0-10-0#CAE5E8'];

var table9 = ['100-60-0-45#103667', '100-60-0-25#184785', '100-60-0-15#1B4F93', '100-60-0-0#205AA7', '85-50-0-0#426EB4', '65-40-0-0#7388C1', '50-25-0-0#94AAD6', '30-15-0-0#BFCAE6'];

var table10 = ['100-90-0-45#211551', '100-90-0-25#2D1E69', '100-90-0-15#322275', '100-90-0-0#3A2885', '85-80-0-0#511F90', '75-65-0-0#635BA2', '60-55-0-0#8273B0', '45-40-0-0#A095C4'];

var table11 = ['80-100-0-45#38044B', '80-100-0-25#490761', '80-100-0-15#52096C', '80-100-0-0#5D0C7B', '65-85-0-0#79378B', '55-65-0-0#8C63A4', '40-50-0-0#AA87B8', '25-30-0-0#C9B5D4'];

var table12 = ['40-100-0-45#64004B', '40-100-0-25#780062', '40-100-0-15#8F006D', '40-100-0-0#A2007C', '35-80-0-0#AF4A92', '25-60-0-0#C57CAC', '20-40-0-0#D2A6C7', '10-20-0-0#E8D3E3'];

var table13 = ['0-0-0-100#000000', '0-0-0-65#707070', '0-0-0-55#898989', '0-0-0-45#A0A0A0', '0-0-0-35#B7B7B7', '0-0-0-30#C2C2C2', '0-0-0-20#D7D7D7', '0-0-0-0#FFFFFF'];

function LoadColorPicker() {
    art.dialog({
        title: '颜色选择',
        content: document.getElementById("morecolor"),
        lock: true,
        ok: function () {
            SetFontColor();
        },
        okVal: "确定",
        cancelVal: '关闭',
        cancel: true

    });

    var color = $("#color");
    for (var i = 1; i <= 13; i++) {
        var obj = eval("table" + i);
        for (var j = 0; j < obj.length; j++) {
            var colorarr = obj[j];
            var strcmyk = colorarr.split("#")[0];
            var arrcmyk = strcmyk.split("-");
            if (arrcmyk.length != 4) {
                alert("error");
                break;
            }
            var c = arrcmyk[0];
            var m = arrcmyk[1];
            var y = arrcmyk[2];
            var k = arrcmyk[3];
            var rgb = "#" + colorarr.split("#")[1];

            var div = document.createElement("DIV");

            div.style.backgroundColor = rgb;
            div.style.float = "left"

            div.style.width = div.style.height = "20px";
            div.style.left = (i - 1) * 20 + "px";
            div.style.top = j * 20 + "px";
            div.style.position = "absolute";
            div.setAttribute("rgb", rgb);
            div.setAttribute("cmyk", strcmyk);

            div.onmousemove = SetColor;
            div.onmousedown = SetCurrentColor;
            color.append(div);
        }
    }
}

function SetColor() {
    var cmykvalue = $(this).attr("cmyk");
    var rgbvalue = $(this).attr("rgb");
    $("#rgbValue").val(rgbvalue);
    $("#showcolor").css("background", rgbvalue);
    var cmyk = cmykvalue.split('-');
    $("#cvalue").val(cmyk[0]);
    $("#mvalue").val(cmyk[1]);
    $("#yvalue").val(cmyk[2]);
    $("#kvalue").val(cmyk[3]);
}

function ShowCurrentColor() {
    $("#showcolor").css("background", currentColor);
    $("#rgbValue").val(currentColor);

    var cmyk = currentColorCMYK.split("-");
    $("#cvalue").val(cmyk[0]);
    $("#mvalue").val(cmyk[1]);
    $("#yvalue").val(cmyk[2]);
    $("#kvalue").val(cmyk[3]);
}

function SetCurrentColor() {
    currentColor = $(this).attr("rgb");
    currentColorCMYK = $(this).attr("cmyk");
    var cmyk = currentColorCMYK.split("-");
    $("#cvalue").val(cmyk[0]);
    $("#mvalue").val(cmyk[1]);
    $("#yvalue").val(cmyk[2]);
    $("#kvalue").val(cmyk[3]);
}
function cmykToRgb(c, m, y, k) {

    var rkfs = Math.round((1 - Math.min(1, (c / 100.0) * (1 - k / 100.0) + k / 100.0)) * 255);
    var gkfs = Math.round((1 - Math.min(1, (m / 100.0) * (1 - k / 100.0) + k / 100.0)) * 255);
    var bkfs = Math.round((1 - Math.min(1, (y / 100.0) * (1 - k / 100.0) + k / 100.0)) * 255);
    var value = "#" + ToHex(rkfs) + "" + ToHex(gkfs) + "" + ToHex(bkfs);

    return value;
}

function ToHex(n) {
    var h, l;

    n = Math.round(n);
    l = n % 16;
    h = Math.floor((n / 16)) % 16;
    return (hexch[h] + hexch[l]);
}

function verify(oldValue) {
    var value;
    var pattern = /^\d{1,3}$/;
    if (pattern.test(oldValue)) {
        var v = parseInt(oldValue);
        if (v > 100) {
            value = 100;
        }
        else {
            value = v;
        }
    }
    if (!value) value = 0;
    return value;
}

function SetCmykToRgb() {
    var c = verify(document.getElementById("cvalue").value);
    var m = verify(document.getElementById("mvalue").value);
    var y = verify(document.getElementById("yvalue").value);
    var k = verify(document.getElementById("kvalue").value);
    var rgbValue = cmykToRgb(c, m, y, k);
    document.getElementById("showcolor").style.backgroundColor = rgbValue;
    document.getElementById("rgbValue").value = rgbValue;
    currentColor = rgbValue;
    currentColorCMYK = c + "-" + m + "-" + y + "-" + k;
    window.status = currentColor + " " + currentColorCMYK;
}
