<?php
/**
 * @author 39wifi.com
 *QQ  177189495
 */
class Image{
    //࿪ʼ
    public $originimage = ""; //ԴͼƬļַ
    public $imageext = ""; //ԴͼƬʽ
    public $thumbimage = ""; //ͼļŵַ
    public $thumb_maxwidth = 1440; //ͼ
    public $thumb_maxheight = 900; //ͼ߶
    public $watermark_text = ""; //ˮӡ
    public $watermark_minwidth = 300; //ԴͼƬСȣڴֵʱˮӡ
    public $watermark_minheight = 200; //ԴͼƬС߶ȣڴֵʱˮӡ
    public $watermark_fontfile = ""; //ļ
    public $watermark_fontsize = 14; //С
    public $watermark_logo = "config/water.png"; //ˮӡLOGOַ
    public $watermark_transparent = 20; //ˮӡLOGO͸
    private $origin_width = 0; //ԴͼƬ
    private $origin_height = 0; //ԴͼƬ߶
    private $imageQuilty = 90; //ͼƬ
    private $tmp_originimage = ""; //ʱͼƬ(ԴͼƬ)
    private $tmp_thumbimage = ""; //ʱͼƬ(ͼ)
    private $tmp_waterimage = ""; //ʱͼƬ(ˮӡLOGO)
    private $_waterPosition = 2; //1м 2½
    //ͼ
    public function gen_thumbimage() {
        if ($this->originimage == "" || $this->thumbimage == "") {
            return 0;
        }
        $this->get_oriwidthheight ();
        if ($this->origin_width < $this->thumb_maxwidth && $this->origin_height < $this->thumb_maxheight) {
            $this->thumb_maxwidth = $this->origin_width;
            $this->thumb_maxheight = $this->origin_height;
        } else {
            if ($this->origin_width < $this->origin_height) {
                $this->thumb_maxwidth = ($this->thumb_maxheight / $this->origin_height) * $this->origin_width;
            } else {
                $this->thumb_maxheight = ($this->thumb_maxwidth / $this->origin_width) * $this->origin_height;
            }
        }
        $this->get_imagetype ();
        $this->gen_tmpimage_origin ();
        $this->gen_tmpimage_thumb ();
        if ($this->tmp_originimage == "" || $this->tmp_thumbimage == "") {
            return - 1;
        }
        imagecopyresampled ( $this->tmp_thumbimage, $this->tmp_originimage, 0, 0, 0, 0, $this->thumb_maxwidth, $this->thumb_maxheight, $this->origin_width, $this->origin_height );
        switch ($this->imageext) {
            case "gif" :
                imagegif ( $this->tmp_thumbimage, $this->thumbimage );
                return 1;
                break;
            case "jpg" :
                imagejpeg ( $this->tmp_thumbimage, $this->thumbimage, $this->imageQuilty );
                return 2;
                break;
            case "png" :
                imagepng ( $this->tmp_thumbimage, $this->thumbimage );
                return 3;
                break;
            default :
                return - 2;
                break;
        }
    }
    //ˮӡ
    public function add_watermark1() {
        if ($this->originimage == "" || $this->watermark_text == "" || $this->watermark_fontfile == "") {
            return 0;
        }
        $this->get_oriwidthheight ();
        if ($this->origin_width < $this->watermark_minwidth || $this->origin_height < $this->watermark_minheight) {
            return 0;
        }
        $this->get_imagetype ();
        $this->gen_tmpimage_origin ();
        if ($this->tmp_originimage == "") {
            return - 1;
        }
        $textcolor = imagecolorallocate ( $this->tmp_originimage, 255, 0, 0 );
        $angle = 0;
        $px = $this->origin_width / 2 - 200;
        $py = $this->origin_height / 2 - 10;
        imagettftext ( $this->tmp_originimage, $this->watermark_fontsize, $angle, $px, $py, $textcolor, $this->watermark_fontfile, $this->watermark_text );
        switch ($this->imageext) {
            case "gif" :
                imagegif ( $this->tmp_originimage, $this->originimage );
                return 1;
                break;
            case "jpg" :
                imagejpeg ( $this->tmp_originimage, $this->originimage, $this->imageQuilty );
                return 2;
                break;
            case "png" :
                imagepng ( $this->tmp_originimage, $this->originimage );
                return 3;
                break;
            default :
                return - 2;
                break;
        }
    }
    //LOGOˮӡ
    public function add_watermark2() {
        if ($this->originimage == "" || $this->watermark_logo == "") {
            return 0;
        }
        $this->get_oriwidthheight ();
        if ($this->origin_width < $this->watermark_minwidth || $this->origin_height < $this->watermark_minheight) {
            return 0;
        }
        $this->get_imagetype ();
        $this->gen_tmpimage_origin ();
        $this->gen_tmpimage_waterlogo ();
        if ($this->tmp_originimage == "" || $this->tmp_waterimage == "") {
            return - 1;
        }
        list ( $logo_width, $logo_height ) = getimagesize ( $this->watermark_logo );
        //м
        $waterZb = $this->waterPosition ( $logo_width, $logo_height );
        $px = $waterZb ['x'];
        $py = $waterZb ['y'];
        imagecopymerge ( $this->tmp_originimage, $this->tmp_waterimage, $px, $py, 0, 0, $logo_width, $logo_height, $this->watermark_transparent );
        switch ($this->imageext) {
            case "gif" :
                imagegif ( $this->tmp_originimage, $this->originimage );
                return 1;
                break;
            case "jpg" :
                imagejpeg ( $this->tmp_originimage, $this->originimage, $this->imageQuilty );
                return 2;
                break;
            case "png" :
                imagepng ( $this->tmp_originimage, $this->originimage );
                return 3;
                break;
            default :
                return - 2;
                break;
        }
    }
      
    /**
     * ϴͼ
     * עϴļС
     *@param String $files $_FILES['upload'] 
     *@param String  $path  洢Ŀ¼ Ĭ/static/attached/
     *@param boolean $isWater Ƿˮӡ
     * @return string $filePath ҳurlͼƬ·
     */
    public function upload($files, $path, $isWater) {
        if (is_uploaded_file ( $files ['tmp_name'] )) {
            $upfile = $files;
            $name = $upfile [name];
            $type = $upfile [type];
            $size = $upfile [size];
            $tmp_name = $upfile [tmp_name];
            $error = $upfile [error];
              
            if ($size > 1048576) {
                return array ('status' => false, 'message' => "$nameͼƬ̫󳬹1MB" );
            }
              
            $rs = $this->getImageSize ( $tmp_name );
            if (! $rs ['status']) {
                $rs ['message'] = $name . $rs ['message'];
                return $rs;
            }
              
            // ļ
            $save_path = getcwd () . "/static/attached/" . $path . "/";
            $save_url = "./static/attached/" . $path . "/";
            $ym = date ( "Ym" );
            $save_path .= $ym . "/";
            $save_url .= $ym . "/";
            if (! file_exists ( $save_path )) {
                mkdir ( $save_path );
            }
              
            if ($error == '0') {
                $fileType = substr ( $name, strpos ( $name, "." ) + 1 );
                $prefix = $this->getRandPrefix ();
                $newName = date ( "YmdHi" ) . $prefix . "." . $fileType;
                $filepath = $save_path . $newName;
                move_uploaded_file ( $tmp_name, $filepath );
              
            }
              
            if ($isWater) {
                $this->water ( $filepath );
            }
              
            return array ('status' => true, 'message' => $save_url . $newName );
        }
    }
      
    /**
     * ͼƬˮӡ
     * @param unknown_type $image
     */
    public function water($image) {
        $this->watermark_logo = ROOT . $this->watermark_logo;
        $this->originimage = $image;
        //LOGOˮӡ
        $this->add_watermark2 ();
    }
      
    /**
     * 
     * ȡǰ׺
     */
    private function getRandPrefix() {
        $string = "abcdefghijklmnopqrstuvwxyz0123456789";
        $prefix = '';
        for($i = 0; $i < 4; $i ++) {
            $rand = rand ( 0, 33 );
            $prefix .= $string {$rand};
        }
        return $prefix;
    }
      
    //ͼƬС
    private function getImageSize($image) {
        list ( $width, $height, $type, $attr ) = getimagesize ( $image );
          
        if ($type != 2 && $type != 3) {
            return array ('status' => false, 'message' => "ͼƬʽȷ,ϴJPGPNGͼƬ" . $type );
        }
        //ͼƬС
        if ($width > 1440) {
            return array ('status' => false, 'message' => "ͼƬС1440px,ǰΪ" . $width . "px" );
        }
          
        if ($height > 900) {
            return array ('status' => false, 'message' => "ͼƬ߶С900px,ǰΪ" . $height . "px" );
          
        }
        return array ('status' => true );
    }
      
    /**
     * ͼ
     * 
     * @param String $imagefile ԭʼļ
     * @param String $thumbWidth  ͼ
     * @param String $thumbHeight ͼ߶
     * @return String ͼurl         
     */
    public function reduceImage($imagefile, $thumbWidth, $thumbHeight, $path = "thumb") {
          
        // ͼ
        $dir = date ( "Ym", time () );
        $imagefile = ROOT . $imagefile;
        $imagefile_s = ROOT . "static/attached/" . $path . "/" . $dir . "/s_" . basename ( $imagefile );
        $imagetrans = new Image ();
        $imagetrans->originimage = $imagefile;
        $imagetrans->thumbimage = $imagefile_s;
        $imagetrans->thumb_maxwidth = $thumbWidth;
        $imagetrans->thumb_maxheight = $thumbHeight;
        $isokid = $imagetrans->gen_thumbimage ();
          
        return "./static/attached/" . $path . "/" . $dir . "/s_" . basename ( $imagefile );
      
    }
    /**
     * ˮӡλ
     * @param int $logo_width
     * @param int $logo_height
     * @return ˮӡ
     */
    private function waterPosition($logo_width, $logo_height) {
        switch ($this->_waterPosition) {
            case 1 :
                $px = $this->origin_width / 2 - $logo_width / 2;
                $py = $this->origin_height / 2 - $logo_height / 2;
                break;
            case 2 :
                $px = $this->origin_width - $logo_width - 10;
                $py = $this->origin_height - $logo_height - 10;
                break;
            default :
                $px = $this->origin_width / 2 - $logo_width / 2;
                $py = $this->origin_height / 2 - $logo_height / 2;
                break;
        }
          
        return array ('x' => $px, 'y' => $py );
    }
    //ȡͼƬߴ
    private function get_oriwidthheight() {
        list ( $this->origin_width, $this->origin_height ) = getimagesize ( $this->originimage );
        return 1;
    }
    /*
     * ͼƬʽ
     * ԭҪexif չ
     */
    private function get_imagetype() {
        $ext = $this->getImgext ( $this->originimage );
        switch ($ext) {
            case 1 :
                $this->imageext = "gif";
                break;
            case 2 :
                $this->imageext = "jpg";
                break;
            case 3 :
                $this->imageext = "png";
                break;
            default :
                $this->imageext = "unknown";
                break;
        }
    }
    //ʱͼƬ(ԴͼƬ)
    private function gen_tmpimage_origin() {
        $ext = $this->getImgext ( $this->originimage );
        switch ($ext) {
            case 1 :
                $this->tmp_originimage = imagecreatefromgif ( $this->originimage );
                $bgcolor = imagecolorallocate ( $this->tmp_originimage, 0, 0, 0 );
                $bgcolortrans = imagecolortransparent ( $this->tmp_originimage, $bgcolor );
                break;
            case 2 :
                $this->tmp_originimage = imagecreatefromjpeg ( $this->originimage );
                break;
            case 3 :
                $this->tmp_originimage = imagecreatefrompng ( $this->originimage );
                imagesavealpha ( $this->tmp_originimage, true );
                break;
            default :
                $this->tmp_originimage = "";
                break;
        }
    }
    //ʱͼƬ(ͼ)
    private function gen_tmpimage_thumb() {
        $ext = $this->getImgext ( $this->originimage );
        switch ($ext) {
            case 1 :
                $this->tmp_thumbimage = imagecreatetruecolor ( $this->thumb_maxwidth, $this->thumb_maxheight );
                $bgcolor = imagecolorallocate ( $this->tmp_thumbimage, 255, 255, 255 );
                imagefill ( $this->tmp_thumbimage, 0, 0, $bgcolor );
                break;
            case 2 :
                $this->tmp_thumbimage = imagecreatetruecolor ( $this->thumb_maxwidth, $this->thumb_maxheight );
                break;
            case 3 :
                $this->tmp_thumbimage = imagecreatetruecolor ( $this->thumb_maxwidth, $this->thumb_maxheight );
                $bgcolor = imagecolorallocate ( $this->tmp_thumbimage, 255, 255, 255 );
                imagefill ( $this->tmp_thumbimage, 0, 0, $bgcolor );
                imagealphablending ( $this->tmp_thumbimage, false );
                imagesavealpha ( $this->tmp_thumbimage, true );
                break;
            default :
                $this->tmp_thumbimage = "";
                break;
        }
    }
    //ʱͼƬ(LOGOˮӡ)
    private function gen_tmpimage_waterlogo() {
        $ext = $this->getImgext ( $this->watermark_logo );
        switch ($ext) {
            case 1 :
                $this->tmp_waterimage = imagecreatefromgif ( $this->watermark_logo );
                $bgcolor = imagecolorallocate ( $this->tmp_waterimage, 0, 0, 0 );
                $bgcolortrans = imagecolortransparent ( $this->tmp_waterimage, $bgcolor );
                break;
            case 2 :
                $this->tmp_waterimage = imagecreatefromjpeg ( $this->watermark_logo );
                break;
            case 3 :
                $this->tmp_waterimage = imagecreatefrompng ( $this->watermark_logo );
                imagesavealpha ( $this->tmp_waterimage, true );
                break;
            default :
                $this->tmp_waterimage = "";
                break;
        }
    }
    /*
     * ȡ׺
     */
    public function getImgext($filename) {
        return exif_imagetype ( $filename );
    }
    //ͷԴ
    public function __destruct() {
        if (is_object ( $this->tmp_originimage ) == true) {
            imagedestroy ( $this->tmp_originimage );
        }
        if (is_object ( $this->tmp_thumbimage ) == true) {
            imagedestroy ( $this->tmp_thumbimage );
        }
        if (is_object ( $this->tmp_waterimage ) == true) {
            imagedestroy ( $this->tmp_waterimage );
        }
    }
}
?>