<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;
class CategorycityController extends IndexController {
	
	//列表动作-----------------------------------------------------------------------------------------------
	public function indexAction(){
		
		$model=new \Admin\Model\CategoryCityModel();
		foreach($model->IndexGetData(
				//排序
				array(
					array('order'=>'catid','name'=>'ID'),
					array('order'=>'name','name'=>'名称'),
					array('order'=>'code','name'=>'字母码'),
					array('order'=>'upid','name'=>'分类级别'),
					array('order'=>'description','name'=>'排序')
				),
				//查询
				array(	
					'name'=>array('name','search'),
					'catid'=>array('catid','int')
				)
			) as $key=>$value){
			$this->assign($key,$value);
		}

		$this->display();
	}
	
	//添加动作-----------------------------------------------------------------------------------------------
	public function addAction(){
		
		if(IsPost('Submit')){
			$model=new \Admin\Model\CategoryCityModel();
			$result=$model->CreateData($model->FormatData());
			if(!$result['id']){
				$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index/'),3);
			}else{
				$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/edit/catid/'.$result['id']),3);
			}
		}else{
			$this->display();
		}
		
	}

	//修改动作-----------------------------------------------------------------------------------------------
	public function editAction(){
		$id=I('get.catid',0,'int');
		$model=new \Admin\Model\CategoryCityModel();
		$manage=$model->token(false)->where(" catid=$id ")->find();
		if(!$manage['catid']){
			$this->error('修改数据不存在!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
		}
			
		if(IsPost('Submit')){

			if($model->where(" catid=$id ")->save($model->FormatData())){
				$result=array('id'=>$id,'message'=>'修改成功!'.$model->getError());
			}else{
				$result=array('id'=>0,'message'=>'修改失败!'.$model->getError());
			}
			$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/edit/catid/'.$id),3);
		}else{
			$this->assign('manage',$manage);
			$this->display('Categorycity:add');
		}
		
	}
	
	//更新分类动作-----------------------------------------------------------------------------------------------
	public function updateAction(){
		$model=new \Admin\Model\CategoryCityModel();
		//城市分类Json
		$model->UpdateCategoryCityJson(1);  //一级 foxphp_json_city.js
		$model->UpdateCategoryCityJson(3);  //三级 foxphp_json_city_all.js
		$this->error('更新成功!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
	}
	
	//删除动作-----------------------------------------------------------------------------------------------
	public function deleteAction(){
		$model=new \Admin\Model\CategoryCityModel();
		
		if(IsPost('Delete') && $ids=GetCheckBox($_POST['checkbox'])){
			
		}elseif(!IsPost('Delete') && $ids=intval($_GET['catid'])){

		}else{
			$result=array('status'=>false,'message'=>'对不起，请选择ID操作!');
		}	
		
		if($model->where("catid IN($ids)")->delete()){
			$result=array('status'=>true,'message'=>'删除ID '.$ids.'成功!');
		}else{
			$result=array('status'=>false,'message'=>'删除ID '.$ids.'失败!');
		}
		
		$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
	}
	
}