<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;

/****************************************************/
//Admin入口文件,所有后台控制器，必须继承该类
/****************************************************/

class IndexController extends Controller {
	public $group=array();
	//初始化
	public function _initialize(){
		if($this->uid>0 && !$this->AdminAuth()){
			//后台权限
			if(strtolower(MODULE_NAME)=='admin' && strtolower(CONTROLLER_NAME)=='index' && strtolower(ACTION_NAME)=='index'){
				$this->error('对不起，您没有权限操作！','/');
			}
			$this->error('对不起，您没有权限操作！','/admin');
			exit();
		}elseif(!$this->uid){
			$this->error('对不起，请登录后操作！','/admin/login');
			exit();
		}
		
		$this->assign('uid',$this->uid);
		
		$this->assign('username',$this->username);
		
		$this->assign('url',$this->GetModuleUrl());
		
		$this->assign('module',$this->GetModuleName());
		
		$this->assign('controller',$this->GetControllerName());
		
		$this->assign('action',$this->GetActionName());
		
		$model=new \Member\Model\MemberModel();
		$member=$model->UidGetMember($this->uid);
		$this->assign('member',$member);
		//用户组
		$this->group=M('AuthGroup')->token(false)->where(" id=%d ",intval($member['usergroup']))->find();
		$this->assign('group',$this->group);
		
		
		if(!session('UPDATE_KEY')){
			session('UPDATE_KEY',RandomText(32,1));
		}
		
		WriteFile(C('S_APPS').'/Common/Conf/updatekey.php','<?php return $updatekey="'.session('UPDATE_KEY').'"; ?>');
		
		$this->assign('updatekey',session('UPDATE_KEY')); //随机码
	}
	
	//目录
	public function ReadSysDir($dir){
		  $dirarr=array();
		  if($dir){
				if ($handle = @opendir($dir)) {
		   
					 while (false !== ($file = readdir($handle))) {
							if ($file != "." && $file != "..") {
								 
								 $dirarr[]=array('filename'=>$file,'filetime'=>@filemtime($dir.$file),'filesize'=>@filesize($dir.$file));
							}
					 }
					 
					 closedir($handle);
				}
				
				return $dirarr;
		  }
	}
	
	//修改配置
	function SetConfig($post=array()){
		$config=new \Admin\Model\ConfigModel();
		$config->UpdateConfig($post);
	}
	
	//后台权限
	function AdminAuth(){
		//权限
		$auth=new \Think\Auth();
		
		return $auth->check(MODULE_NAME."/".CONTROLLER_NAME."/".ACTION_NAME,$this->uid);
	}
	
	//获取当前模块URL
	public function GetModuleUrl(){
		return strtolower('/'.MODULE_NAME.'/'.CONTROLLER_NAME);
	}
	
	//获取模块名称
	public function GetModuleName(){
		return MODULE_NAME;
	}

	//获取控制器名称
	public function GetControllerName(){
		return strtolower(CONTROLLER_NAME) ? strtolower(CONTROLLER_NAME) : 'index';
	}
	
	//获取动作名称
	public function GetActionName(){
		return strtolower(ACTION_NAME) ? strtolower(ACTION_NAME) : 'index';
	}
	
	public function indexAction(){
		
		//提现
		$withdrawnum=M('Consume')->token(false)->where('paytype=4 AND process=5 AND status=1')->count();
		$this->assign('withdrawnum',$withdrawnum);
		
		//店铺认证
		$certificatenum=M('ShopCertificate')->token(false)->where('status=1')->count();
		$this->assign('certificatenum',$certificatenum);
		
		//举报
		$reportnum=M('Report')->token(false)->where('status=1')->count();
		$this->assign('reportnum',$reportnum);
		
		//退款
		$refundnum=M('Refund')->token(false)->where('process=1')->count();
		$this->assign('refundnum',$refundnum);
		
		//任务审核
		$tasknum=M('Data')->token(false)->where('type=1 AND process=3')->count();
		$this->assign('tasknum',$tasknum);
		
		//服务审核
		$fuwunum=M('Data')->token(false)->where('type=2 AND process=0')->count();
		$this->assign('fuwunum',$fuwunum);
		
		//今日充值
		$moneypayin=M('Consume')->token(false)->where("process=5 AND paytype=3 AND dateline>=UNIX_TIMESTAMP(timestamp(date(sysdate()))) AND dateline<=(UNIX_TIMESTAMP()+86400)")->count();
		$this->assign('moneypayin',$moneypayin);
		
		$this->display();
	}
	
    
}