<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;
use \Org\Util\String;

class MoneyController extends IndexController {
	
	//用户动作-----------------------------------------------------------------------------------------------
	public function indexAction(){
		
		$this->display();
	}
	
	//操作动作-----------------------------------------------------------------------------------------------
	public function operateAction(){
		
		$model=new \Member\Model\MemberModel();
		$uid=intval($_GET['uid']);
		$member=$model->UidGetMember($uid);
		
		if(!empty($_POST['Submit']) && $member['uid']){
			$money=intval($_POST['money']);
			$type=intval($_POST['type']);
			$subject=String::msubstr(I('post.subject'),0,50,C('S_CHARSET'),false);
			
			if($money<1){
				$this->error('金额操作最低1元!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/operate/uid/'.$uid),3);
			}
			
			if($money>99999){
				$this->error('金额操作最高99999元!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/operate/uid/'.$uid),3);
			}
		
			$consume=new \Consume\Model\ConsumeModel();

			if($type==1){
				//增加
				$consume->AddUserMoney($member['uid'],$member['username'],$money,$subject);
			}else{
				//减少
				$consume->ReduceUserMoney($member['uid'],$member['username'],$money,$subject);
			}

			$this->error('操作成功!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/operate/uid/'.$uid),3);
			
		}else{
			if(empty($uid) || !$member['uid']){
				$this->error('UID不存在!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
			}
			
			$this->assign('member',$member);
			
			$this->display();
		}
	}
			
}