<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;
class NewsController extends IndexController {
	
	//列表动作-----------------------------------------------------------------------------------------------
	public function indexAction(){
		
		$model=new \Admin\Model\ArticleModel();
		
		$sqlwhere=array(' type=%d ',array('type'=>1));
		
		foreach($model->IndexGetData(
				//排序
				array(
					array('order'=>'id','name'=>'ID'),
					array('order'=>'uid','name'=>'用户UID'),
					array('order'=>'author','name'=>'作者'),
					array('order'=>'subject','name'=>'名称'),
					array('order'=>'catid','name'=>'分类'),
					array('order'=>'status','name'=>'状态'),
					array('order'=>'dateline','name'=>'发布时间'),
				),
				//查询
				array(	
					'subject'=>array('subject','search'),
					'id'=>array('id','int'),
					'uid'=>array('uid','int')
				),
				'id DESC'
				,
				20				
				,
				$sqlwhere
				
			) as $key=>$value){
			$this->assign($key,$value);
		}

		$this->display('News:index');
	}
	
	//添加动作-----------------------------------------------------------------------------------------------
	public function addAction(){
		
		if(IsPost('Submit')){
			$model=new \Admin\Model\ArticleModel();
			$result=$model->CreateData($model->FormatData(1));
			if(!$result['id']){
				$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index/'),3);
			}else{
				$id=$result['id'];
				$upload=new \Upload\Model\FileModel();
				$upload->UseFile('aid',$id);
				$file = $upload->token(false)->where(" aid=$id AND thumbcut is not null ")->order('dateline ASC')->find();
				if(!empty($file['thumbcut'])){
					M('Article')->where("id=$id")->save(array('picture'=>$file['thumbcut']));
				}
				$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/edit/id/'.$result['id']),3);
			}
		}else{
			$this->assign('uploadid','aid'); //设置上传文件文章字段
			$this->assign('type',1); 
			$this->display('News:add');
		}
		
	}

	//修改动作-----------------------------------------------------------------------------------------------
	public function editAction(){
		$id=I('get.id',0,'int');
		$model=new \Admin\Model\ArticleModel();
		$manage=$model->token(false)->where(" id=$id ")->find();
		if(!$manage['id']){
			$this->error('修改数据不存在!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
		}
			
		if(IsPost('Submit')){
			$result=$model->EditData($model->FormatData(1));

			if($result['id']){
				$id=$result['id'];
				$upload=new \Upload\Model\FileModel();
				$upload->UseFile('aid',$id);
				$file = $upload->token(false)->where(" aid=$id AND thumbcut is not null ")->order('dateline ASC')->find();
				if(!empty($file['thumbcut'])){
					M('Article')->where("id=$id")->save(array('picture'=>$file['thumbcut']));
				}
			}			
			$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/edit/id/'.$id),3);
		}else{
			$this->assign('manage',$manage);
			$this->assign('id',$manage['id']);
			$this->assign('type',1); 
			$this->display('News:add');
		}
		
	}
	
	//删除动作-----------------------------------------------------------------------------------------------
	public function deleteAction(){
		$model=new \Admin\Model\ArticleModel();
		$result=$model->DeleteData();
		$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
	}
	
}