<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;
class RefundController extends IndexController {
	
	//列表动作-----------------------------------------------------------------------------------------------
	public function indexAction(){
		
		$model=new \Admin\Model\RefundModel();
		foreach($model->IndexGetData(
				//排序
				array(
					array('order'=>'rid','name'=>'退款ID'),
					array('order'=>'cid','name'=>'支付订单ID'),
					array('order'=>'oid','name'=>'稿件ID'),
					array('order'=>'id','name'=>'任务'),
					array('order'=>'money','name'=>'交易金额'),
					array('order'=>'refund','name'=>'退款金额'),
					array('order'=>'buyer_uid','name'=>'买家UID'),
					array('order'=>'buyer_username','name'=>'买家用户名'),
					array('order'=>'seller_uid','name'=>'卖家UID'),
					array('order'=>'seller_username','name'=>'卖家用户名'),
					array('order'=>'process','name'=>'退款流程'),
					array('order'=>'service_uid','name'=>'网站客服UID'),
					array('order'=>'service_username','name'=>'网站客服用户名'),
					array('order'=>'dateline','name'=>'发布时间')
				),
				//查询
				array(	
					'id'=>array('id','int'),
					'buyer_uid'=>array('buyer_uid','int'),
					'seller_uid'=>array('seller_uid','int')
				)
				
			) as $key=>$value){
			$this->assign($key,$value);
		}

		$this->display();
	}
	
	//同意动作-----------------------------------------------------------------------------------------------
	public function agreeAction(){
	
		$model=new \Refund\Model\RefundModel();
		$id=$model->ReportAgree(intval($_POST['rid']),intval($_POST['money'])*100,1);
		if($id>0){
			$this->ajaxReturn(array('title'=>'退款操作','message'=>'退款成功!','status'=>'ok','refresh'=>true));
		}else{
			$this->ajaxReturn(array('title'=>'退款失败','message'=>$model->getError(),'status'=>'error'));
		}
	}
	
	//显示动作-----------------------------------------------------------------------------------------------
	public function showAction(){
		
		$refund=new \Refund\Model\RefundModel();
		$data=$refund->ShowRefund($_GET['rid']);
		if(empty($data['rid'])){
			$this->error('对不起，数据不在存！',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
			exit();
		}
	 
		$this->assign('rid',$data['rid']);
		$this->assign('manage',$data);
		$data=$refund->GetReportMessage();
		$this->assign('list',$data['list']);
		$this->assign('page',$data['page']);
		$this->display();	
	}
	
	//删除动作-----------------------------------------------------------------------------------------------
	public function deleteAction(){
		$model=new \Admin\Model\RefundModel();
		$result=$model->DeleteData('rid');
		$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
	}
	
}