<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;
class ReportController extends IndexController {
	
	//列表动作-----------------------------------------------------------------------------------------------
	public function indexAction(){
		
		$model=new \Admin\Model\ReportModel();

		foreach($model->IndexGetData(
				//排序
				array(
					array('order'=>'id','name'=>'ID'),
					array('order'=>'oid','name'=>'稿件ID'),
					array('order'=>'uid','name'=>'用户UID'),
					array('order'=>'ruid','name'=>'被举报人UID'),
					array('order'=>'subject','name'=>'名称'),
					array('order'=>'content','name'=>'内容'),
					array('order'=>'status','name'=>'状态'),
					array('order'=>'dateline','name'=>'举报时间'),
				),
				//查询
				array(	
					'subject'=>array('subject','search'),
					'id'=>array('id','int'),
					'oid'=>array('oid','int'),
					'uid'=>array('uid','int')
				)
				
			) as $key=>$value){
			$this->assign($key,$value);
		}

		$this->display();
	}
	
	
	//举报操作-----------------------------------------------------------------------------------------------
	public function operateAction(){
		
		if(!empty($_POST['Success'])){
			
			$ids=GetCheckBox($_POST['checkbox']);
		  
			if($ids){
				
				M('Report')->token(false)->where(" rid IN($ids) ")->save(array('status'=>1));

				$refresh.='<p>'.$ids.'号举报设置已处理成功！</p>';

			}else{

				$refresh='<p>请选操作数据！</p>';

			}
			
		}elseif(!empty($_POST['Failure'])){
			
			$ids=GetCheckBox($_POST['checkbox']);
		  
			if($ids){
				
				M('Report')->token(false)->where(" rid IN($ids) ")->save(array('status'=>2));

				$refresh.='<p>'.$ids.'号举报设置未处理成功！</p>';

			}else{

				$refresh='<p>请选操作数据！</p>';

			}
		
		}else{
			
			$ids=GetCheckBox($_POST['checkbox']);
		  
			if($ids){
				
				M('Report')->token(false)->where(" rid IN($ids) ")->delete();

				$refresh.='<p>'.$ids.'号举报删除成功！</p>';

			}else{

				$refresh='<p>请选操作数据！</p>';

			}
		}
		
		$this->error($refresh,U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
		
	}
	
	
	//删除动作-----------------------------------------------------------------------------------------------
	public function deleteAction(){
		$model=new \Admin\Model\ReportModel();
		$result=$model->DeleteData('rid');
		$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
	}
	
}