<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;
class SlideController extends IndexController {
	
	//列表动作-----------------------------------------------------------------------------------------------
	public function indexAction(){
		
		$model=new \Admin\Model\SlideModel();
		
		foreach($model->IndexGetData(
				//排序
				array(
					array('order'=>'id','name'=>'ID'),
					array('order'=>'type','name'=>'类型'),
					array('order'=>'subject','name'=>'标题'),
					array('order'=>'link','name'=>'链接'),
					array('order'=>'image','name'=>'图片地址'),
					array('order'=>'displayorder','name'=>'排序'),
					array('order'=>'status','name'=>'状态')
				),
				//查询
				array(	
					'subject'=>array('subject','search'),
					'id'=>array('id','int')
				)
				
			) as $key=>$value){
			$this->assign($key,$value);
		}

		$this->display();
	}
	
	//添加动作-----------------------------------------------------------------------------------------------
	public function addAction(){
		
		if(IsPost('Submit')){
			$model=new \Admin\Model\SlideModel();
			$result=$model->CreateData($model->FormatData());
			if(!$result['id']){
				$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index/'),3);
			}else{
				$id=$result['id'];
				$upload=new \Upload\Model\FileModel();
				$upload->UseFile('slide',$id);
				$file = $upload->token(false)->where(" slide=$id AND thumbcut is not null ")->order('dateline ASC')->find();
				if(!empty($file['thumbcut'])){
					M('Slide')->where("id=$id")->save(array('image'=>$file['filepath']));
				}
				$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/edit/id/'.$result['id']),3);
			}
		}else{
			$this->assign('uploadid','slide'); //设置上传文件文章字段
			$this->display();
		}
		
	}

	//修改动作-----------------------------------------------------------------------------------------------
	public function editAction(){
		$id=I('get.id',0,'int');
		$model=new \Admin\Model\SlideModel();
		$manage=$model->token(false)->where(" id=$id ")->find();
		if(!$manage['id']){
			$this->error('修改数据不存在!',U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
		}
			
		if(IsPost('Submit')){
			$result=$model->EditData($model->FormatData());

			if($result['id']){
				$id=$result['id'];
				$upload=new \Upload\Model\FileModel();
				$upload->UseFile('slide',$id);
				$file = $upload->token(false)->where(" slide=$id AND thumbcut is not null ")->order('dateline ASC')->find();
				if(!empty($file['thumbcut'])){
					M('Slide')->where("id=$id")->save(array('image'=>$file['filepath']));
				}
			}			
			$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/edit/id/'.$id),3);
		}else{
			$this->assign('manage',$manage);
			$this->assign('uploadid','slide'); //设置上传文件文章字段
			$this->assign('id',$manage['id']);
			$this->display('Slide:add');
		}
		
	}
	
	//删除动作-----------------------------------------------------------------------------------------------
	public function deleteAction(){
		$model=new \Admin\Model\SlideModel();
		$result=$model->DeleteData();
		$this->error($result['message'],U(MODULE_NAME.'/'.CONTROLLER_NAME.'/index'),3);
	}
	
}